/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.channels.Channels;
import org.jboss.xnio.channels.StreamSinkChannel;

public class BlockingWritableByteChannel
implements GatheringByteChannel,
Flushable {
    private final StreamSinkChannel delegate;

    public BlockingWritableByteChannel(StreamSinkChannel delegate) {
        this.delegate = delegate;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long res;
        StreamSinkChannel delegate = this.delegate;
        while ((res = delegate.write(srcs, offset, length)) == 0L && Buffers.hasRemaining(srcs, offset, length)) {
            delegate.awaitWritable();
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int res;
        StreamSinkChannel delegate = this.delegate;
        while ((res = delegate.write(src)) == 0 && src.hasRemaining()) {
            delegate.awaitWritable();
        }
        return res;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void flush() throws IOException {
        Channels.flushBlocking(this.delegate);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

