/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.test;

import java.io.Closeable;
import java.io.IOException;
import junit.framework.TestCase;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.test.support.LoggingHelper;

public final class IoUtilsTestCase
extends TestCase {
    static {
        LoggingHelper.init();
    }

    public void testDirectExecutor() {
        final Thread t = Thread.currentThread();
        final boolean[] ok = new boolean[1];
        IoUtils.directExecutor().execute(new Runnable(){

            @Override
            public void run() {
                IoUtilsTestCase.assertSame((Object)t, (Object)Thread.currentThread());
                ok[0] = true;
            }
        });
        IoUtilsTestCase.assertTrue((boolean)ok[0]);
    }

    public void testNullExecutor() {
        IoUtils.nullExecutor().execute(new Runnable(){

            @Override
            public void run() {
                IoUtilsTestCase.fail((String)"null executor ran task");
            }
        });
    }

    public void testSafeClose() {
        IoUtils.safeClose(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new RuntimeException("This error should be consumed but logged");
            }
        });
        IoUtils.safeClose(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new Error("This error should be consumed but logged");
            }
        });
        IoUtils.safeClose(new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("This error should be consumed but logged");
            }
        });
    }
}

