/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.test;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import junit.framework.TestCase;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.test.support.LoggingHelper;

public final class BuffersTestCase
extends TestCase {
    static {
        LoggingHelper.init();
    }

    private void doTestFlip(Buffer buffer) {
        int pos = buffer.position();
        int cap = buffer.capacity();
        BuffersTestCase.assertEquals((int)cap, (int)buffer.limit());
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.flip(buffer));
        BuffersTestCase.assertEquals((int)0, (int)buffer.position());
        BuffersTestCase.assertEquals((int)pos, (int)buffer.limit());
        BuffersTestCase.assertEquals((int)cap, (int)buffer.capacity());
    }

    public void testFlipByte() {
        ByteBuffer buf = ByteBuffer.allocate(100);
        byte[] byArray = new byte[6];
        byArray[0] = 5;
        byArray[1] = 4;
        byArray[2] = 3;
        byArray[3] = 2;
        byArray[4] = 1;
        byte[] data = byArray;
        byte[] data2 = new byte[data.length];
        buf.put(data);
        this.doTestFlip(buf);
        buf.get(data2);
        BuffersTestCase.assertTrue((boolean)Arrays.equals(data, data2));
        BuffersTestCase.assertFalse((boolean)buf.hasRemaining());
    }

    public void testFlipChar() {
        CharBuffer buf = CharBuffer.allocate(100);
        char[] cArray = new char[6];
        cArray[0] = 5;
        cArray[1] = 4;
        cArray[2] = 3;
        cArray[3] = 2;
        cArray[4] = '\u0001';
        char[] data = cArray;
        char[] data2 = new char[data.length];
        buf.put(data);
        this.doTestFlip(buf);
        buf.get(data2);
        BuffersTestCase.assertTrue((boolean)Arrays.equals(data, data2));
        BuffersTestCase.assertFalse((boolean)buf.hasRemaining());
    }

    private void doTestClear(Buffer buffer) {
        BuffersTestCase.assertFalse((buffer.position() == 0 ? 1 : 0) != 0);
        int cap = buffer.capacity();
        BuffersTestCase.assertFalse((buffer.limit() == cap ? 1 : 0) != 0);
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.clear(buffer));
        BuffersTestCase.assertEquals((int)0, (int)buffer.position());
        BuffersTestCase.assertEquals((int)cap, (int)buffer.limit());
        BuffersTestCase.assertEquals((int)cap, (int)buffer.capacity());
    }

    public void testClearByte() {
        ByteBuffer buf = ByteBuffer.allocate(100);
        byte[] byArray = new byte[6];
        byArray[0] = 5;
        byArray[1] = 4;
        byArray[2] = 3;
        byArray[3] = 2;
        byArray[4] = 1;
        byte[] data = byArray;
        buf.put(data);
        buf.put(data);
        buf.put(data);
        buf.flip();
        buf.get();
        buf.get();
        this.doTestClear(buf);
    }

    public void testClearChar() {
        CharBuffer buf = CharBuffer.allocate(100);
        char[] cArray = new char[6];
        cArray[0] = 5;
        cArray[1] = 4;
        cArray[2] = 3;
        cArray[3] = 2;
        cArray[4] = '\u0001';
        char[] data = cArray;
        buf.put(data);
        buf.put(data);
        buf.put(data);
        buf.flip();
        buf.get();
        buf.get();
        this.doTestClear(buf);
    }

    private void doTestLimit(Buffer buffer) {
        BuffersTestCase.assertFalse((buffer.limit() == 50 ? 1 : 0) != 0);
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.limit(buffer, 50));
        BuffersTestCase.assertEquals((int)50, (int)buffer.limit());
    }

    public void testLimitByte() {
        ByteBuffer buf = ByteBuffer.allocate(100);
        byte[] byArray = new byte[6];
        byArray[0] = 5;
        byArray[1] = 4;
        byArray[2] = 3;
        byArray[3] = 2;
        byArray[4] = 1;
        byte[] data = byArray;
        buf.put(data);
        buf.put(data);
        buf.put(data);
        buf.flip();
        buf.get();
        buf.get();
        this.doTestLimit(buf);
    }

    public void testLimitChar() {
        CharBuffer buf = CharBuffer.allocate(100);
        char[] cArray = new char[6];
        cArray[0] = 5;
        cArray[1] = 4;
        cArray[2] = 3;
        cArray[3] = 2;
        cArray[4] = '\u0001';
        char[] data = cArray;
        buf.put(data);
        buf.put(data);
        buf.put(data);
        buf.flip();
        buf.get();
        buf.get();
        this.doTestLimit(buf);
    }

    private void doTestMarkReset(Buffer buffer) {
        int p = buffer.position();
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.mark(buffer));
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.skip(buffer, 10));
        BuffersTestCase.assertFalse((buffer.position() == p ? 1 : 0) != 0);
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.reset(buffer));
        BuffersTestCase.assertTrue((buffer.position() == p ? 1 : 0) != 0);
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.skip(buffer, 10));
        BuffersTestCase.assertFalse((buffer.position() == p ? 1 : 0) != 0);
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.reset(buffer));
        BuffersTestCase.assertTrue((buffer.position() == p ? 1 : 0) != 0);
    }

    public void testMarkResetByte() {
        ByteBuffer buf = ByteBuffer.allocate(100);
        byte[] byArray = new byte[6];
        byArray[0] = 5;
        byArray[1] = 4;
        byArray[2] = 3;
        byArray[3] = 2;
        byArray[4] = 1;
        byte[] data = byArray;
        buf.put(data);
        buf.put(data);
        buf.put(data);
        buf.flip();
        buf.get();
        buf.get();
        this.doTestMarkReset(buf);
    }

    public void testMarkResetChar() {
        CharBuffer buf = CharBuffer.allocate(100);
        char[] cArray = new char[6];
        cArray[0] = 5;
        cArray[1] = 4;
        cArray[2] = 3;
        cArray[3] = 2;
        cArray[4] = '\u0001';
        char[] data = cArray;
        buf.put(data);
        buf.put(data);
        buf.put(data);
        buf.flip();
        buf.get();
        buf.get();
        this.doTestMarkReset(buf);
    }

    private void doTestPosition(Buffer buffer) {
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.position(buffer, 25));
        BuffersTestCase.assertEquals((int)25, (int)buffer.position());
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.position(buffer, 0));
        BuffersTestCase.assertEquals((int)0, (int)buffer.position());
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.position(buffer, 100));
        BuffersTestCase.assertEquals((int)100, (int)buffer.position());
    }

    public void testPositionByte() {
        this.doTestPosition(ByteBuffer.allocate(200));
    }

    public void testPositionChar() {
        this.doTestPosition(CharBuffer.allocate(200));
    }

    private void doTestRewind(Buffer buffer) {
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.position(buffer, 45));
        BuffersTestCase.assertEquals((int)45, (int)buffer.position());
        BuffersTestCase.assertSame((Object)buffer, (Object)Buffers.rewind(buffer));
        BuffersTestCase.assertEquals((int)0, (int)buffer.position());
    }

    public void testRewindByte() {
        this.doTestRewind(ByteBuffer.allocate(200));
    }

    public void testRewindChar() {
        this.doTestRewind(CharBuffer.allocate(200));
    }

    public void testPositiveSliceByte() {
        ByteBuffer buf = ByteBuffer.allocate(200);
        byte[] byArray = new byte[8];
        byArray[0] = 5;
        byArray[1] = 10;
        byArray[2] = 15;
        byArray[3] = 20;
        byArray[5] = 5;
        byArray[6] = 10;
        byArray[7] = 15;
        byte[] data = byArray;
        buf.put(data).put(data).put(data).put(data).put(data).put(data).put(data);
        buf.flip();
        int lim = buf.limit();
        int cap = buf.capacity();
        ByteBuffer slice1 = Buffers.slice(buf, 7);
        BuffersTestCase.assertEquals((int)0, (int)slice1.position());
        BuffersTestCase.assertEquals((int)7, (int)slice1.capacity());
        BuffersTestCase.assertEquals((int)7, (int)slice1.limit());
        BuffersTestCase.assertEquals((int)7, (int)buf.position());
        BuffersTestCase.assertEquals((int)lim, (int)buf.limit());
        BuffersTestCase.assertEquals((int)cap, (int)buf.capacity());
        ByteBuffer slice2 = Buffers.slice(buf, 14);
        BuffersTestCase.assertEquals((int)0, (int)slice2.position());
        BuffersTestCase.assertEquals((int)14, (int)slice2.capacity());
        BuffersTestCase.assertEquals((int)14, (int)slice2.limit());
        BuffersTestCase.assertEquals((int)21, (int)buf.position());
    }

    public void testPositiveSliceChar() {
        CharBuffer buf = CharBuffer.allocate(200);
        char[] cArray = new char[8];
        cArray[0] = 5;
        cArray[1] = 10;
        cArray[2] = 15;
        cArray[3] = 20;
        cArray[5] = 5;
        cArray[6] = 10;
        cArray[7] = 15;
        char[] data = cArray;
        buf.put(data).put(data).put(data).put(data).put(data).put(data).put(data);
        buf.flip();
        int lim = buf.limit();
        int cap = buf.capacity();
        CharBuffer slice1 = Buffers.slice(buf, 7);
        BuffersTestCase.assertEquals((int)0, (int)slice1.position());
        BuffersTestCase.assertEquals((int)7, (int)slice1.capacity());
        BuffersTestCase.assertEquals((int)7, (int)slice1.limit());
        BuffersTestCase.assertEquals((int)7, (int)buf.position());
        BuffersTestCase.assertEquals((int)lim, (int)buf.limit());
        BuffersTestCase.assertEquals((int)cap, (int)buf.capacity());
        CharBuffer slice2 = Buffers.slice(buf, 14);
        BuffersTestCase.assertEquals((int)0, (int)slice2.position());
        BuffersTestCase.assertEquals((int)14, (int)slice2.capacity());
        BuffersTestCase.assertEquals((int)14, (int)slice2.limit());
        BuffersTestCase.assertEquals((int)21, (int)buf.position());
    }

    public void testNegativeSliceByte() {
        ByteBuffer buf = ByteBuffer.allocate(200);
        byte[] byArray = new byte[8];
        byArray[0] = 5;
        byArray[1] = 10;
        byArray[2] = 15;
        byArray[3] = 20;
        byArray[5] = 5;
        byArray[6] = 10;
        byArray[7] = 15;
        byte[] data = byArray;
        buf.put(data).put(data).put(data).put(data).put(data).put(data).put(data);
        buf.flip();
        int lim = buf.limit();
        int cap = buf.capacity();
        ByteBuffer slice1 = Buffers.slice(buf, 7 - lim);
        BuffersTestCase.assertEquals((int)0, (int)slice1.position());
        BuffersTestCase.assertEquals((int)7, (int)slice1.capacity());
        BuffersTestCase.assertEquals((int)7, (int)slice1.limit());
        BuffersTestCase.assertEquals((int)7, (int)buf.position());
        BuffersTestCase.assertEquals((int)lim, (int)buf.limit());
        BuffersTestCase.assertEquals((int)cap, (int)buf.capacity());
        ByteBuffer slice2 = Buffers.slice(buf, 14 - lim + 7);
        BuffersTestCase.assertEquals((int)0, (int)slice2.position());
        BuffersTestCase.assertEquals((int)14, (int)slice2.capacity());
        BuffersTestCase.assertEquals((int)14, (int)slice2.limit());
        BuffersTestCase.assertEquals((int)21, (int)buf.position());
    }

    public void testNegativeSliceChar() {
        CharBuffer buf = CharBuffer.allocate(200);
        char[] cArray = new char[8];
        cArray[0] = 5;
        cArray[1] = 10;
        cArray[2] = 15;
        cArray[3] = 20;
        cArray[5] = 5;
        cArray[6] = 10;
        cArray[7] = 15;
        char[] data = cArray;
        buf.put(data).put(data).put(data).put(data).put(data).put(data).put(data);
        buf.flip();
        int lim = buf.limit();
        int cap = buf.capacity();
        CharBuffer slice1 = Buffers.slice(buf, 7 - lim);
        BuffersTestCase.assertEquals((int)0, (int)slice1.position());
        BuffersTestCase.assertEquals((int)7, (int)slice1.capacity());
        BuffersTestCase.assertEquals((int)7, (int)slice1.limit());
        BuffersTestCase.assertEquals((int)7, (int)buf.position());
        BuffersTestCase.assertEquals((int)lim, (int)buf.limit());
        BuffersTestCase.assertEquals((int)cap, (int)buf.capacity());
        CharBuffer slice2 = Buffers.slice(buf, 14 - lim + 7);
        BuffersTestCase.assertEquals((int)0, (int)slice2.position());
        BuffersTestCase.assertEquals((int)14, (int)slice2.capacity());
        BuffersTestCase.assertEquals((int)14, (int)slice2.limit());
        BuffersTestCase.assertEquals((int)21, (int)buf.position());
    }

    private void doTestFillByte(ByteBuffer buf) {
        BuffersTestCase.assertSame((Object)buf, (Object)Buffers.fill(buf, 5, 30));
        BuffersTestCase.assertSame((Object)buf, (Object)Buffers.fill(buf, 90, 20));
        BuffersTestCase.assertEquals((int)50, (int)buf.position());
        BuffersTestCase.assertEquals((int)5, (int)buf.get(3));
        BuffersTestCase.assertEquals((int)5, (int)buf.get(29));
        BuffersTestCase.assertEquals((int)90, (int)buf.get(30));
        BuffersTestCase.assertEquals((int)90, (int)buf.get(31));
        BuffersTestCase.assertEquals((int)90, (int)buf.get(49));
    }

    public void testFillByte() {
        ByteBuffer buf = ByteBuffer.allocate(100);
        this.doTestFillByte(buf);
        ByteBuffer dbuf = ByteBuffer.allocateDirect(100);
        this.doTestFillByte(dbuf);
    }

    private void doTestFillChar(CharBuffer buf) {
        BuffersTestCase.assertSame((Object)buf, (Object)Buffers.fill(buf, 5, 30));
        BuffersTestCase.assertSame((Object)buf, (Object)Buffers.fill(buf, 90, 20));
        BuffersTestCase.assertEquals((int)50, (int)buf.position());
        BuffersTestCase.assertEquals((int)5, (int)buf.get(3));
        BuffersTestCase.assertEquals((int)5, (int)buf.get(29));
        BuffersTestCase.assertEquals((int)90, (int)buf.get(30));
        BuffersTestCase.assertEquals((int)90, (int)buf.get(31));
        BuffersTestCase.assertEquals((int)90, (int)buf.get(49));
    }

    public void testFillChar() {
        CharBuffer buf = CharBuffer.allocate(100);
        this.doTestFillChar(buf);
    }
}

