/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.jboss.xnio.Buffers;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.channels.AllocatedMessageChannel;
import org.jboss.xnio.channels.ReadableMessageChannel;
import org.jboss.xnio.channels.SslTcpChannel;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.SuspendableReadChannel;
import org.jboss.xnio.channels.SuspendableWriteChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.WrappingAllocatedMessageChannel;
import org.jboss.xnio.channels.WrappingSslTcpChannel;
import org.jboss.xnio.channels.WritableMessageChannel;
import org.jboss.xnio.log.Logger;

public final class Channels {
    private static final Logger sslLog = Logger.getLogger("org.jboss.xnio.ssl");

    private Channels() {
    }

    public static AllocatedMessageChannel createAllocatedMessageChannel(StreamChannel streamChannel, OptionMap optionMap) {
        return new WrappingAllocatedMessageChannel(streamChannel, optionMap);
    }

    public static SslTcpChannel createSslTcpChannel(SSLContext sslContext, TcpChannel tcpChannel, Executor executor, OptionMap optionMap) throws IOException {
        InetSocketAddress peerAddress = (InetSocketAddress)tcpChannel.getPeerAddress();
        return new WrappingSslTcpChannel(tcpChannel, sslContext.createSSLEngine(peerAddress.getHostName(), peerAddress.getPort()), executor);
    }

    public static ChannelListener<TcpChannel> createSslTcpChannelListener(final SSLContext sslContext, final ChannelListener<? super SslTcpChannel> sslChannelListener, final Executor executor, final OptionMap optionMap) throws IOException {
        return new ChannelListener<TcpChannel>(){

            @Override
            public void handleEvent(TcpChannel channel) {
                boolean ok = false;
                try {
                    try {
                        sslChannelListener.handleEvent(Channels.createSslTcpChannel(sslContext, channel, executor, optionMap));
                        ok = true;
                    }
                    catch (IOException e) {
                        sslLog.error((Throwable)e, "Failed to open SSL channel", new Object[0]);
                        if (!ok) {
                            IoUtils.safeClose(channel);
                        }
                    }
                }
                finally {
                    if (!ok) {
                        IoUtils.safeClose(channel);
                    }
                }
            }
        };
    }

    public static void flushBlocking(SuspendableWriteChannel channel) throws IOException {
        while (!channel.flush()) {
            channel.awaitWritable();
        }
    }

    public static <C extends WritableByteChannel & SuspendableWriteChannel> int writeBlocking(C channel, ByteBuffer buffer) throws IOException {
        int t = 0;
        while (buffer.hasRemaining()) {
            int res = channel.write(buffer);
            if (res == 0) {
                ((SuspendableWriteChannel)channel).awaitWritable();
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends WritableByteChannel & SuspendableWriteChannel> int writeBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        long remaining = unit.toMillis(time);
        long now = System.currentTimeMillis();
        int t = 0;
        while (buffer.hasRemaining() && remaining > 0L) {
            int res = channel.write(buffer);
            if (res == 0) {
                ((SuspendableWriteChannel)channel).awaitWritable(remaining, TimeUnit.MILLISECONDS);
                long l = -now;
                now = System.currentTimeMillis();
                remaining -= Math.max(l + now, 0L);
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends GatheringByteChannel & SuspendableWriteChannel> long writeBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long t = 0L;
        while (Buffers.hasRemaining(buffers, offs, len)) {
            long res = channel.write(buffers, offs, len);
            if (res == 0L) {
                ((SuspendableWriteChannel)channel).awaitWritable();
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends GatheringByteChannel & SuspendableWriteChannel> long writeBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long remaining = unit.toMillis(time);
        long now = System.currentTimeMillis();
        long t = 0L;
        while (Buffers.hasRemaining(buffers, offs, len) && remaining > 0L) {
            long res = channel.write(buffers, offs, len);
            if (res == 0L) {
                ((SuspendableWriteChannel)channel).awaitWritable(remaining, TimeUnit.MILLISECONDS);
                long l = -now;
                now = System.currentTimeMillis();
                remaining -= Math.max(l + now, 0L);
                continue;
            }
            t += res;
        }
        return t;
    }

    public static <C extends WritableMessageChannel & SuspendableWriteChannel> void sendBlocking(C channel, ByteBuffer buffer) throws IOException {
        while (!channel.send(buffer)) {
            channel.awaitWritable();
        }
    }

    public static <C extends WritableMessageChannel & SuspendableWriteChannel> boolean sendBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        long l;
        long now = System.currentTimeMillis();
        for (long remaining = unit.toMillis(time); remaining > 0L; remaining -= Math.max(l + now, 0L)) {
            if (!channel.send(buffer)) {
                channel.awaitWritable(remaining, TimeUnit.MILLISECONDS);
                l = -now;
                now = System.currentTimeMillis();
                continue;
            }
            return true;
        }
        return false;
    }

    public static <C extends WritableMessageChannel & SuspendableWriteChannel> void sendBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        while (!channel.send(buffers, offs, len)) {
            channel.awaitWritable();
        }
    }

    public static <C extends WritableMessageChannel & SuspendableWriteChannel> boolean sendBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long l;
        long now = System.currentTimeMillis();
        for (long remaining = unit.toMillis(time); remaining > 0L; remaining -= Math.max(l + now, 0L)) {
            if (!channel.send(buffers, offs, len)) {
                channel.awaitWritable(remaining, TimeUnit.MILLISECONDS);
                l = -now;
                now = System.currentTimeMillis();
                continue;
            }
            return true;
        }
        return false;
    }

    public static <C extends ReadableByteChannel & SuspendableReadChannel> int readBlocking(C channel, ByteBuffer buffer) throws IOException {
        int res;
        while ((res = channel.read(buffer)) == 0 && buffer.hasRemaining()) {
            ((SuspendableReadChannel)channel).awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableByteChannel & SuspendableReadChannel> int readBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        int res = channel.read(buffer);
        if (res == 0 && buffer.hasRemaining()) {
            ((SuspendableReadChannel)channel).awaitReadable(time, unit);
            return channel.read(buffer);
        }
        return res;
    }

    public static <C extends ScatteringByteChannel & SuspendableReadChannel> long readBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long res;
        while ((res = channel.read(buffers, offs, len)) == 0L) {
            ((SuspendableReadChannel)channel).awaitReadable();
        }
        return res;
    }

    public static <C extends ScatteringByteChannel & SuspendableReadChannel> long readBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long res = channel.read(buffers, offs, len);
        if (res == 0L && Buffers.hasRemaining(buffers, offs, len)) {
            ((SuspendableReadChannel)channel).awaitReadable(time, unit);
            return channel.read(buffers, offs, len);
        }
        return res;
    }

    public static <C extends ReadableMessageChannel & SuspendableReadChannel> int receiveBlocking(C channel, ByteBuffer buffer) throws IOException {
        int res;
        while ((res = channel.receive(buffer)) == 0) {
            channel.awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableMessageChannel & SuspendableReadChannel> int receiveBlocking(C channel, ByteBuffer buffer, long time, TimeUnit unit) throws IOException {
        int res = channel.receive(buffer);
        if (res == 0) {
            channel.awaitReadable(time, unit);
            return channel.receive(buffer);
        }
        return res;
    }

    public static <C extends ReadableMessageChannel & SuspendableReadChannel> long receiveBlocking(C channel, ByteBuffer[] buffers, int offs, int len) throws IOException {
        long res;
        while ((res = channel.receive(buffers, offs, len)) == 0L) {
            channel.awaitReadable();
        }
        return res;
    }

    public static <C extends ReadableMessageChannel & SuspendableReadChannel> long receiveBlocking(C channel, ByteBuffer[] buffers, int offs, int len, long time, TimeUnit unit) throws IOException {
        long res = channel.receive(buffers, offs, len);
        if (res == 0L) {
            channel.awaitReadable(time, unit);
            return channel.receive(buffers, offs, len);
        }
        return res;
    }
}

