/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.xnio.FlagSet;
import org.jboss.xnio.FlagsOption;
import org.jboss.xnio.Sequence;
import org.jboss.xnio.SequenceOption;
import org.jboss.xnio.SingleOption;

public abstract class Option<T>
implements Serializable {
    private static final long serialVersionUID = -1564427329140182760L;
    private final Class<?> declClass;
    private final String name;

    Option(Class<?> declClass, String name) {
        this.declClass = declClass;
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
    }

    public static <T> Option<T> simple(Class<?> declClass, String name, Class<T> type) {
        return new SingleOption<T>(declClass, name, type);
    }

    public static <T> Option<Sequence<T>> sequence(Class<?> declClass, String name, Class<T> elementType) {
        return new SequenceOption<T>(declClass, name, elementType);
    }

    public static <T extends Enum<T>> Option<FlagSet<T>> flags(Class<?> declClass, String name, Class<T> elementType) {
        return new FlagsOption<T>(declClass, name, elementType);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " (" + this.declClass.getName() + "#" + this.name + ")";
    }

    public abstract T cast(Object var1) throws ClassCastException;

    protected final Object readResolve() throws ObjectStreamException {
        try {
            Field field = this.declClass.getField(this.name);
            int modifiers = field.getModifiers();
            if (!Modifier.isProtected(modifiers)) {
                throw new InvalidObjectException("Invalid Option instance (the field is not public)");
            }
            if (!Modifier.isStatic(modifiers)) {
                throw new InvalidObjectException("Invalid Option instance (the field is not static)");
            }
            return field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new InvalidObjectException("Invalid Option instance (no matching field)");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidObjectException("Invalid Option instance (Illegal access on field get)");
        }
    }

    public static SetBuilder setBuilder() {
        return new SetBuilder();
    }

    public static class SetBuilder {
        private List<Option<?>> optionSet = new ArrayList();

        SetBuilder() {
        }

        public SetBuilder add(Option<?> option) {
            if (option == null) {
                throw new NullPointerException("option is null");
            }
            this.optionSet.add(option);
            return this;
        }

        public SetBuilder addAll(Collection<Option<?>> options) {
            if (options == null) {
                throw new NullPointerException("options is null");
            }
            for (Option<?> option : options) {
                this.add(option);
            }
            return this;
        }

        public Set<Option<?>> create() {
            return Collections.unmodifiableSet(new LinkedHashSet(this.optionSet));
        }
    }
}

