/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.xnio.AbstractIoFuture;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.IoUtils;

public interface IoFuture<T>
extends Cancellable {
    @Override
    public IoFuture<T> cancel();

    public Status getStatus();

    public Status await();

    public Status await(long var1, TimeUnit var3);

    public Status awaitInterruptibly() throws InterruptedException;

    public Status awaitInterruptibly(long var1, TimeUnit var3) throws InterruptedException;

    public T get() throws IOException, CancellationException;

    public T getInterruptibly() throws IOException, InterruptedException, CancellationException;

    public IOException getException() throws IllegalStateException;

    public <A> IoFuture<T> addNotifier(Notifier<? super T, A> var1, A var2);

    public static abstract class HandlingNotifier<T, A>
    implements Notifier<T, A> {
        @Override
        public void notify(IoFuture<? extends T> future, A attachment) {
            switch (future.getStatus()) {
                case CANCELLED: {
                    this.handleCancelled(attachment);
                    break;
                }
                case DONE: {
                    try {
                        this.handleDone(future.get(), attachment);
                        break;
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException();
                    }
                }
                case FAILED: {
                    this.handleFailed(future.getException(), attachment);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public void handleCancelled(A attachment) {
        }

        public void handleFailed(IOException exception, A attachment) {
        }

        public void handleDone(T result, A attachment) {
        }
    }

    public static class Manager<T> {
        private final Executor executor;
        private final AbstractIoFuture<T> ioFuture;

        public Manager(final Executor executor) {
            this.executor = executor;
            this.ioFuture = new AbstractIoFuture<T>(){

                @Override
                protected Executor getNotifierExecutor() {
                    return executor;
                }
            };
        }

        public Manager() {
            this(IoUtils.directExecutor());
        }

        public IoFuture<T> getIoFuture() {
            return this.ioFuture;
        }

        public void addCancelHandler(Cancellable cancellable) {
            this.ioFuture.addCancelHandler(cancellable);
        }

        public boolean setResult(T result) {
            return this.ioFuture.setResult(result);
        }

        public boolean setException(IOException exception) {
            return this.ioFuture.setException(exception);
        }

        public boolean finishCancel() {
            return this.ioFuture.finishCancel();
        }

        public void runNotifier(Runnable runnable) {
            this.ioFuture.runNotifier(runnable);
        }

        public Executor getNotifierExecutor() {
            return this.executor;
        }
    }

    public static interface Notifier<T, A> {
        public void notify(IoFuture<? extends T> var1, A var2);
    }

    public static enum Status {
        WAITING,
        DONE,
        CANCELLED,
        FAILED;

    }
}

