/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.jboss.xnio.channels.StreamChannel;

public class BlockingByteChannel
implements ScatteringByteChannel,
GatheringByteChannel,
ByteChannel {
    private final StreamChannel delegate;

    public BlockingByteChannel(StreamChannel delegate) {
        this.delegate = delegate;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long res;
        StreamChannel delegate = this.delegate;
        while ((res = delegate.read(dsts, offset, length)) == 0L) {
            delegate.awaitReadable();
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        long res;
        StreamChannel delegate = this.delegate;
        while ((res = delegate.read(dsts)) == 0L) {
            delegate.awaitReadable();
        }
        return res;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int res;
        StreamChannel delegate = this.delegate;
        while ((res = delegate.read(dst)) == 0) {
            delegate.awaitReadable();
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long res;
        StreamChannel delegate = this.delegate;
        while ((res = delegate.write(srcs, offset, length)) == 0L) {
            delegate.awaitWritable();
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        long res;
        StreamChannel delegate = this.delegate;
        while ((res = delegate.write(srcs)) == 0L) {
            delegate.awaitWritable();
        }
        return res;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int res;
        StreamChannel delegate = this.delegate;
        while ((res = delegate.write(src)) == 0) {
            delegate.awaitWritable();
        }
        return res;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

