/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.channels.Channel;
import java.nio.channels.Selector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.zip.ZipFile;
import org.jboss.xnio.BoundConnector;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.CloseableExecutor;
import org.jboss.xnio.Connector;
import org.jboss.xnio.FutureConnection;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IoUtils {
    private static final Executor NULL_EXECUTOR = new Executor(){
        private final String string = String.format("null executor <%s>", Integer.toHexString(this.hashCode()));

        public void execute(Runnable command) {
        }

        public String toString() {
            return this.string;
        }
    };
    private static final Executor DIRECT_EXECUTOR = new Executor(){
        private final String string = String.format("direct executor <%s>", Integer.toHexString(this.hashCode()));

        public void execute(Runnable command) {
            command.run();
        }

        public String toString() {
            return this.string;
        }
    };
    private static final IoHandler<Channel> NULL_HANDLER = new IoHandler<Channel>(){
        private final String string = String.format("null handler <%s>", Integer.toHexString(this.hashCode()));

        @Override
        public void handleOpened(Channel channel) {
        }

        @Override
        public void handleReadable(Channel channel) {
        }

        @Override
        public void handleWritable(Channel channel) {
        }

        @Override
        public void handleClosed(Channel channel) {
        }

        public String toString() {
            return this.string;
        }
    };
    private static final IoHandlerFactory<Channel> NULL_HANDLER_FACTORY = new IoHandlerFactory<Channel>(){
        private final String string = String.format("null handler factory <%s>", Integer.toHexString(this.hashCode()));

        @Override
        public IoHandler<Channel> createHandler() {
            return NULL_HANDLER;
        }

        public String toString() {
            return this.string;
        }
    };
    private static final Closeable NULL_CLOSEABLE = new Closeable(){
        private final String string = String.format("null closeable <%s>", Integer.toHexString(this.hashCode()));

        public void close() throws IOException {
        }

        public String toString() {
            return this.string;
        }
    };
    private static final Logger closeLog = Logger.getLogger("org.jboss.xnio.safe-close");
    private static final IoFuture.Notifier<Object, Closeable> ATTACHMENT_CLOSING_NOTIFIER = new IoFuture.Notifier<Object, Closeable>(){

        @Override
        public void notify(IoFuture<?> future, Closeable attachment) {
            IoUtils.safeClose(attachment);
        }
    };
    private static final IoFuture.Notifier<Closeable, Void> CLOSING_NOTIFIER = new IoFuture.HandlingNotifier<Closeable, Void>(){

        @Override
        public void handleDone(Closeable result, Void attachment) {
            IoUtils.safeClose(result);
        }
    };
    private static final IoFuture.Notifier<Object, CountDownLatch> COUNT_DOWN_NOTIFIER = new IoFuture.Notifier<Object, CountDownLatch>(){

        @Override
        public void notify(IoFuture<?> future, CountDownLatch latch) {
            latch.countDown();
        }
    };
    private static final Logger connLog = Logger.getLogger("org.jboss.xnio.connection");

    private IoUtils() {
    }

    public static <T extends StreamChannel> Closeable createConnection(ChannelSource<T> channelSource, IoHandler<? super T> handler, Executor reconnectExecutor) {
        Connection connection = new Connection(channelSource, handler, reconnectExecutor);
        connection.connect();
        return connection;
    }

    public static Executor delayedExecutor(final ScheduledExecutorService scheduledExecutorService, final long delay, final TimeUnit unit) {
        return new Executor(){

            public void execute(Runnable command) {
                scheduledExecutorService.schedule(command, delay, unit);
            }
        };
    }

    public static Executor directExecutor() {
        return DIRECT_EXECUTOR;
    }

    public static Executor nullExecutor() {
        return NULL_EXECUTOR;
    }

    public static CloseableExecutor closeableExecutor(final ExecutorService executorService, final long timeout, final TimeUnit unit) {
        return new CloseableExecutor(){

            public void close() throws IOException {
                executorService.shutdown();
                try {
                    if (executorService.awaitTermination(timeout, unit)) {
                        return;
                    }
                    executorService.shutdownNow();
                    throw new IOException("Executor did not shut down cleanly (killed)");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    executorService.shutdownNow();
                    throw new InterruptedIOException("Interrupted while awaiting executor shutdown");
                }
            }

            public void execute(Runnable command) {
                executorService.execute(command);
            }
        };
    }

    public static Closeable nullCloseable() {
        return NULL_CLOSEABLE;
    }

    public static IoHandler<Channel> nullHandler() {
        return NULL_HANDLER;
    }

    public static IoHandlerFactory<Channel> nullHandlerFactory() {
        return NULL_HANDLER_FACTORY;
    }

    public static <T extends Channel> IoHandlerFactory<T> singletonHandlerFactory(IoHandler<T> handler) {
        final AtomicReference<IoHandler<T>> reference = new AtomicReference<IoHandler<T>>(handler);
        return new IoHandlerFactory<T>(){

            @Override
            public IoHandler<? super T> createHandler() {
                IoHandler handler = reference.getAndSet(null);
                if (handler == null) {
                    throw new IllegalStateException("Handler already taken from singleton handler factory");
                }
                return handler;
            }
        };
    }

    public static void safeClose(Closeable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(Socket resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(DatagramSocket resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(Selector resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(ServerSocket resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(ZipFile resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(Handler resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Throwable t) {
            closeLog.trace(t, "Closing resource failed", new Object[0]);
        }
    }

    public static void safeClose(IoFuture<? extends Closeable> futureResource) {
        futureResource.cancel().addNotifier(IoUtils.closingNotifier(), null);
    }

    public static IoFuture.Notifier<Object, Closeable> attachmentClosingNotifier() {
        return ATTACHMENT_CLOSING_NOTIFIER;
    }

    public static IoFuture.Notifier<Closeable, Void> closingNotifier() {
        return CLOSING_NOTIFIER;
    }

    public static <T> IoFuture.Notifier<T, Void> runnableNotifier(final Runnable runnable) {
        return new IoFuture.Notifier<T, Void>(){

            @Override
            public void notify(IoFuture<? extends T> future, Void attachment) {
                runnable.run();
            }
        };
    }

    public static <T> Future<T> getFuture(final IoFuture<T> ioFuture) {
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                ioFuture.cancel();
                return ioFuture.await() == IoFuture.Status.CANCELLED;
            }

            @Override
            public boolean isCancelled() {
                return ioFuture.getStatus() == IoFuture.Status.CANCELLED;
            }

            @Override
            public boolean isDone() {
                return ioFuture.getStatus() == IoFuture.Status.DONE;
            }

            @Override
            public T get() throws InterruptedException, ExecutionException {
                try {
                    return ioFuture.getInterruptibly();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }

            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    if (ioFuture.awaitInterruptibly(timeout, unit) == IoFuture.Status.WAITING) {
                        throw new TimeoutException("Operation timed out");
                    }
                    return ioFuture.getInterruptibly();
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }

            public String toString() {
                return String.format("java.util.concurrent.Future wrapper <%s> for %s", Integer.toHexString(this.hashCode()), ioFuture);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void awaitAll(IoFuture<?> ... futures) {
        int len = futures.length;
        CountDownLatch cdl = new CountDownLatch(len);
        for (IoFuture<?> future : futures) {
            future.addNotifier(COUNT_DOWN_NOTIFIER, cdl);
        }
        boolean intr = false;
        try {
            while (cdl.getCount() > 0L) {
                try {
                    cdl.await();
                }
                catch (InterruptedException e) {
                    intr = true;
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void awaitAllInterruptibly(IoFuture<?> ... futures) throws InterruptedException {
        int len = futures.length;
        CountDownLatch cdl = new CountDownLatch(len);
        for (IoFuture<?> future : futures) {
            future.addNotifier(COUNT_DOWN_NOTIFIER, cdl);
        }
        cdl.await();
    }

    public static <I, O> IoFuture<? extends O> cast(IoFuture<I> parent, Class<O> type) {
        return new CastingIoFuture(parent, type);
    }

    public static <T extends Channel> BoundConnector<URI, T> inetUriConnector(final BoundConnector<InetSocketAddress, T> original, final int defaultPort) {
        return new BoundConnector<URI, T>(){

            @Override
            public FutureConnection<URI, T> connectTo(URI dest, IoHandler<? super T> ioHandler) {
                FutureConnection futureConnection = original.connectTo(this.getSockAddr(dest), ioHandler);
                return new UriFutureConnection(futureConnection);
            }

            @Override
            public ChannelSource<T> createChannelSource(URI dest) {
                return original.createChannelSource(this.getSockAddr(dest));
            }

            private InetSocketAddress getSockAddr(URI dest) {
                String destHost = dest.getHost();
                int destPort = dest.getPort();
                InetSocketAddress destSockAddr = new InetSocketAddress(destHost, destPort == -1 ? defaultPort : destPort);
                return destSockAddr;
            }
        };
    }

    public static <A, T extends Channel> BoundConnector<A, T> bindConnector(final Connector<A, T> connector, final A src) {
        return new BoundConnector<A, T>(){

            @Override
            public FutureConnection<A, T> connectTo(A dest, IoHandler<? super T> ioHandler) {
                return connector.connectTo(src, dest, ioHandler);
            }

            @Override
            public ChannelSource<T> createChannelSource(A dest) {
                return connector.createChannelSource(src, dest);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UriFutureConnection<T extends Channel>
    implements FutureConnection<URI, T> {
        private final FutureConnection<InetSocketAddress, T> futureConnection;

        private UriFutureConnection(FutureConnection<InetSocketAddress, T> futureConnection) {
            this.futureConnection = futureConnection;
        }

        @Override
        public URI getLocalAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FutureConnection<URI, T> cancel() {
            this.futureConnection.cancel();
            return this;
        }

        @Override
        public IoFuture.Status getStatus() {
            return this.futureConnection.getStatus();
        }

        @Override
        public IoFuture.Status await() {
            return this.futureConnection.await();
        }

        @Override
        public IoFuture.Status await(long time, TimeUnit timeUnit) {
            return this.futureConnection.await(time, timeUnit);
        }

        @Override
        public IoFuture.Status awaitInterruptibly() throws InterruptedException {
            return this.futureConnection.awaitInterruptibly();
        }

        @Override
        public IoFuture.Status awaitInterruptibly(long time, TimeUnit timeUnit) throws InterruptedException {
            return this.futureConnection.awaitInterruptibly(time, timeUnit);
        }

        @Override
        public T get() throws IOException, CancellationException {
            return (T)((Channel)this.futureConnection.get());
        }

        @Override
        public T getInterruptibly() throws IOException, InterruptedException, CancellationException {
            return (T)((Channel)this.futureConnection.getInterruptibly());
        }

        @Override
        public IOException getException() throws IllegalStateException {
            return this.futureConnection.getException();
        }

        @Override
        public <A> IoFuture<T> addNotifier(IoFuture.Notifier<? super T, A> aNotifier, A attachment) {
            return this.futureConnection.addNotifier((IoFuture.Notifier<? super T, InetSocketAddress>)aNotifier, (InetSocketAddress)attachment);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CastingIoFuture<O, I>
    implements IoFuture<O> {
        private final IoFuture<I> parent;
        private final Class<O> type;

        private CastingIoFuture(IoFuture<I> parent, Class<O> type) {
            this.parent = parent;
            this.type = type;
        }

        @Override
        public IoFuture<O> cancel() {
            this.parent.cancel();
            return this;
        }

        @Override
        public IoFuture.Status getStatus() {
            return this.parent.getStatus();
        }

        @Override
        public IoFuture.Status await() {
            return this.parent.await();
        }

        @Override
        public IoFuture.Status await(long time, TimeUnit timeUnit) {
            return this.parent.await(time, timeUnit);
        }

        @Override
        public IoFuture.Status awaitInterruptibly() throws InterruptedException {
            return this.parent.awaitInterruptibly();
        }

        @Override
        public IoFuture.Status awaitInterruptibly(long time, TimeUnit timeUnit) throws InterruptedException {
            return this.parent.awaitInterruptibly(time, timeUnit);
        }

        @Override
        public O get() throws IOException, CancellationException {
            return this.type.cast(this.parent.get());
        }

        @Override
        public O getInterruptibly() throws IOException, InterruptedException, CancellationException {
            return this.type.cast(this.parent.getInterruptibly());
        }

        @Override
        public IOException getException() throws IllegalStateException {
            return this.parent.getException();
        }

        @Override
        public <A> IoFuture<O> addNotifier(final IoFuture.Notifier<? super O, A> notifier, A attachment) {
            this.parent.addNotifier(new IoFuture.Notifier<I, A>(){

                @Override
                public void notify(IoFuture<? extends I> future, A attachment) {
                    notifier.notify(CastingIoFuture.this, attachment);
                }
            }, attachment);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Connection<T extends StreamChannel>
    implements Closeable {
        private final ChannelSource<T> channelSource;
        private final IoHandler<? super T> handler;
        private final Executor reconnectExecutor;
        private volatile boolean stopFlag = false;
        private volatile IoFuture<? extends T> currentFuture;
        private final NotifierImpl<?> notifier = new NotifierImpl();
        private final HandlerImpl handlerWrapper = new HandlerImpl();
        private final ReconnectTask reconnectTask = new ReconnectTask();

        private Connection(ChannelSource<T> channelSource, IoHandler<? super T> handler, Executor reconnectExecutor) {
            this.channelSource = channelSource;
            this.handler = handler;
            this.reconnectExecutor = reconnectExecutor;
        }

        private void connect() {
            closeLog.trace("Establishing connection");
            IoFuture<T> ioFuture = this.channelSource.open(this.handlerWrapper);
            ioFuture.addNotifier(this.notifier, null);
            this.currentFuture = ioFuture;
        }

        @Override
        public void close() throws IOException {
            this.stopFlag = true;
            IoFuture<T> future = this.currentFuture;
            if (future != null) {
                future.cancel();
            }
        }

        public String toString() {
            return String.format("persistent connection <%s> via %s", Integer.toHexString(this.hashCode()), this.channelSource);
        }

        private final class ReconnectTask
        implements Runnable {
            private ReconnectTask() {
            }

            public void run() {
                if (!Connection.this.stopFlag) {
                    Connection.this.connect();
                }
            }

            public String toString() {
                return String.format("reconnect task <%s> for %s", Integer.toHexString(this.hashCode()), Connection.this);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class HandlerImpl
        implements IoHandler<T> {
            private HandlerImpl() {
            }

            @Override
            public void handleOpened(T channel) {
                Connection.this.handler.handleOpened(channel);
            }

            @Override
            public void handleReadable(T channel) {
                Connection.this.handler.handleReadable(channel);
            }

            @Override
            public void handleWritable(T channel) {
                Connection.this.handler.handleWritable(channel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleClosed(T channel) {
                try {
                    connLog.trace("Connection closed");
                    if (!Connection.this.stopFlag) {
                        Connection.this.reconnectExecutor.execute(Connection.this.reconnectTask);
                    }
                }
                finally {
                    Connection.this.handler.handleClosed(channel);
                }
            }

            public String toString() {
                return String.format("persistent connection handler <%s> wrapping %s", Integer.toHexString(this.hashCode()), Connection.this.handler);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class NotifierImpl<A>
        extends IoFuture.HandlingNotifier<T, A> {
            private NotifierImpl() {
            }

            @Override
            public void handleCancelled(A attachment) {
                connLog.trace("Connection cancelled");
            }

            @Override
            public void handleFailed(IOException exception, A attachment) {
                connLog.trace((Throwable)exception, "Connection failed", new Object[0]);
            }

            @Override
            public void handleDone(T result, A attachment) {
                connLog.trace("Connection established");
            }

            @Override
            public void notify(IoFuture<? extends T> future, A attachment) {
                super.notify(future, attachment);
                if (!Connection.this.stopFlag) {
                    Connection.this.reconnectExecutor.execute(Connection.this.reconnectTask);
                }
            }
        }
    }
}

