/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.jboss.xnio.ChannelSource;
import org.jboss.xnio.CloseableConnector;
import org.jboss.xnio.CloseableTcpAcceptor;
import org.jboss.xnio.CloseableTcpConnector;
import org.jboss.xnio.ConfigurableFactory;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.XnioConfiguration;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.BoundServer;
import org.jboss.xnio.channels.ConnectedStreamChannel;
import org.jboss.xnio.channels.DatagramChannel;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.StreamSinkChannel;
import org.jboss.xnio.channels.StreamSourceChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.OneWayPipeConnectionMBean;
import org.jboss.xnio.management.PipeConnectionMBean;
import org.jboss.xnio.management.PipeServerMBean;
import org.jboss.xnio.management.PipeSinkServerMBean;
import org.jboss.xnio.management.PipeSourceServerMBean;
import org.jboss.xnio.management.TcpConnectionMBean;
import org.jboss.xnio.management.TcpServerMBean;
import org.jboss.xnio.management.UdpServerMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Xnio
implements Closeable {
    private static final Logger mlog = Logger.getLogger("org.jboss.xnio.management");
    private static final String NIO_IMPL_CLASS_NAME = "org.jboss.xnio.nio.NioXnio";
    private static final String PROVIDER_CLASS;
    private static final int mask = 9;
    private static final String MANAGEMENT_DOMAIN = "org.jboss.Xnio";
    private static final AtomicLong mbeanSequence;
    private static String AGENTID_PROPNAME;
    private static String PROVIDER_PROPNAME;
    private static final PrivilegedAction<String> GET_PROVIDER_ACTION;
    private static final PrivilegedAction<String> GET_AGENTID_ACTION;
    private static final Permission SUBCLASS_PERMISSION;
    private final List<MBeanServer> mBeanServers = new ArrayList<MBeanServer>();
    private final String name;
    private static final AtomicInteger xnioSequence;

    public static Xnio create() throws IOException {
        Xnio result;
        try {
            Class<Xnio> xnioClass = Class.forName(PROVIDER_CLASS).asSubclass(Xnio.class);
            Method method = xnioClass.getDeclaredMethod("create", new Class[0]);
            if ((method.getModifiers() & 9) != 9) {
                throw new NoSuchMethodException("Not public and static");
            }
            result = (Xnio)method.invoke(null, new Object[0]);
        }
        catch (ClassCastException e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" is not really an XNIO provider");
            ioe.initCause(e);
            throw ioe;
        }
        catch (ClassNotFoundException e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" was not found");
            ioe.initCause(e);
            throw ioe;
        }
        catch (IllegalAccessException e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" was not instantiatable due to an illegal access exception");
            ioe.initCause(e);
            throw ioe;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" create() method threw an exception");
            ioe.initCause(cause);
            throw ioe;
        }
        catch (NoSuchMethodException e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" does not have an accessible no-argument static create() method");
            ioe.initCause(e);
            throw ioe;
        }
        catch (ExceptionInInitializerError e) {
            IOException ioe = new IOException("The XNIO provider class \"" + PROVIDER_CLASS + "\" was not instantiatable due to an error in initialization");
            ioe.initCause(e);
            throw ioe;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Xnio(XnioConfiguration configuration) {
        List<MBeanServer> servers;
        if (configuration == null) {
            throw new NullPointerException("configuration is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SUBCLASS_PERMISSION);
        }
        String name = configuration.getName();
        int seq = xnioSequence.getAndIncrement();
        this.name = name != null ? name : String.format("%s-%d", this.getClass().getName(), seq);
        List<MBeanServer> list = servers = this.mBeanServers;
        synchronized (list) {
            List<MBeanServer> confServers = configuration.getMBeanServers();
            if (confServers != null) {
                for (MBeanServer server : confServers) {
                    if (server == null) {
                        throw new NullPointerException("server in MBeanServer configuration list is null");
                    }
                    mlog.debug("Registered configured MBeanServer %s", (Object)server);
                    servers.add(server);
                }
            } else {
                String agentidpropval;
                try {
                    agentidpropval = sm != null ? AccessController.doPrivileged(GET_AGENTID_ACTION) : System.getProperty(AGENTID_PROPNAME);
                }
                catch (SecurityException e) {
                    mlog.debug("Unable to read agentid property (%s); JMX features disabled", (Object)e);
                    return;
                }
                if (agentidpropval == null || agentidpropval.length() == 0) {
                    ArrayList<MBeanServer> fullList;
                    try {
                        fullList = sm != null ? AccessController.doPrivileged(new GetMBeanServersAction(null)) : MBeanServerFactory.findMBeanServer(null);
                    }
                    catch (SecurityException e) {
                        mlog.debug("Unable to detect installed mbean servers (%s); JMX features disabled", (Object)e);
                        return;
                    }
                    for (MBeanServer match : fullList) {
                        mlog.debug("Registered MBeanServer %s", (Object)match);
                        servers.add(match);
                    }
                } else {
                    String[] agentids;
                    for (String agentid : agentids = agentidpropval.split(",")) {
                        ArrayList<MBeanServer> matches;
                        String properName = agentid.trim();
                        if (properName.length() == 0) continue;
                        try {
                            matches = sm != null ? AccessController.doPrivileged(new GetMBeanServersAction(properName)) : MBeanServerFactory.findMBeanServer(null);
                        }
                        catch (SecurityException e) {
                            mlog.debug("Unable to locate any MBeanServer for ID \"%s\" (%s); skipping", (Object)properName, (Object)e);
                            continue;
                        }
                        if (matches == null) {
                            mlog.debug("Unable to locate any MBeanServer for ID \"%s\" (no matches); skipping", (Object)properName);
                            continue;
                        }
                        for (MBeanServer match : matches) {
                            mlog.debug("Registered MBeanServer %s for ID \"%s\"", (Object)match, (Object)properName);
                            servers.add(match);
                        }
                    }
                }
            }
        }
    }

    public ConfigurableFactory<BoundServer<SocketAddress, BoundChannel<SocketAddress>>> createTcpServer(Executor executor, IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        throw new UnsupportedOperationException("TCP Server");
    }

    public ConfigurableFactory<BoundServer<SocketAddress, BoundChannel<SocketAddress>>> createTcpServer(IoHandlerFactory<? super TcpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        throw new UnsupportedOperationException("TCP Server");
    }

    public ConfigurableFactory<CloseableTcpConnector> createTcpConnector(Executor executor) {
        throw new UnsupportedOperationException("TCP Connector");
    }

    public ConfigurableFactory<CloseableTcpConnector> createTcpConnector() {
        throw new UnsupportedOperationException("TCP Connector");
    }

    public ConfigurableFactory<BoundServer<SocketAddress, UdpChannel>> createUdpServer(Executor executor, boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        throw new UnsupportedOperationException("UDP Server");
    }

    public ConfigurableFactory<BoundServer<SocketAddress, UdpChannel>> createUdpServer(boolean multicast, IoHandlerFactory<? super UdpChannel> handlerFactory, SocketAddress ... bindAddresses) {
        throw new UnsupportedOperationException("UDP Server");
    }

    public ChannelSource<StreamChannel> createPipeServer(Executor executor, IoHandlerFactory<? super StreamChannel> handlerFactory) {
        throw new UnsupportedOperationException("Pipe Server");
    }

    public ChannelSource<StreamChannel> createPipeServer(IoHandlerFactory<? super StreamChannel> handlerFactory) {
        throw new UnsupportedOperationException("Pipe Server");
    }

    public ChannelSource<StreamSourceChannel> createPipeSourceServer(Executor executor, IoHandlerFactory<? super StreamSinkChannel> handlerFactory) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public ChannelSource<StreamSourceChannel> createPipeSourceServer(IoHandlerFactory<? super StreamSinkChannel> handlerFactory) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public ChannelSource<StreamSinkChannel> createPipeSinkServer(Executor executor, IoHandlerFactory<? super StreamSourceChannel> handlerFactory) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public ChannelSource<StreamSinkChannel> createPipeSinkServer(IoHandlerFactory<? super StreamSourceChannel> handlerFactory) {
        throw new UnsupportedOperationException("One-way Pipe Server");
    }

    public IoFuture<Closeable> createPipeConnection(Executor executor, IoHandler<? super StreamChannel> leftHandler, IoHandler<? super StreamChannel> rightHandler) {
        throw new UnsupportedOperationException("Pipe Connection");
    }

    public IoFuture<Closeable> createPipeConnection(IoHandler<? super StreamChannel> leftHandler, IoHandler<? super StreamChannel> rightHandler) {
        throw new UnsupportedOperationException("Pipe Connection");
    }

    public IoFuture<Closeable> createOneWayPipeConnection(Executor executor, IoHandler<? super StreamSourceChannel> sourceHandler, IoHandler<? super StreamSinkChannel> sinkHandler) {
        throw new UnsupportedOperationException("One-way Pipe Connection");
    }

    public IoFuture<Closeable> createOneWayPipeConnection(IoHandler<? super StreamSourceChannel> sourceHandler, IoHandler<? super StreamSinkChannel> sinkHandler) {
        throw new UnsupportedOperationException("One-way Pipe Connection");
    }

    public ConfigurableFactory<CloseableTcpAcceptor> createTcpAcceptor(Executor executor) {
        throw new UnsupportedOperationException("TCP Acceptor");
    }

    public ConfigurableFactory<CloseableTcpAcceptor> createTcpAcceptor() {
        throw new UnsupportedOperationException("TCP Acceptor");
    }

    public ConfigurableFactory<BoundServer<String, BoundChannel<String>>> createLocalStreamServer(Executor executor, IoHandlerFactory<? super ConnectedStreamChannel<String>> handlerFactory) {
        throw new UnsupportedOperationException("Local IPC Stream Server");
    }

    public ConfigurableFactory<BoundServer<String, BoundChannel<String>>> createLocalStreamServer(IoHandlerFactory<? super StreamChannel> handlerFactory) {
        throw new UnsupportedOperationException("Local IPC Stream Server");
    }

    public ConfigurableFactory<CloseableConnector<String, ConnectedStreamChannel<String>>> createLocalStreamConnector(Executor executor) {
        throw new UnsupportedOperationException("Local IPC Stream Connector");
    }

    public ConfigurableFactory<CloseableConnector<String, ConnectedStreamChannel<String>>> createLocalStreamConnector() {
        throw new UnsupportedOperationException("Local IPC Stream Connector");
    }

    public ConfigurableFactory<BoundServer<String, BoundChannel<String>>> createLocalDatagramServer(Executor executor, IoHandlerFactory<? super DatagramChannel<String>> handlerFactory) {
        throw new UnsupportedOperationException("Local IPC Datagram Server");
    }

    public ConfigurableFactory<BoundServer<String, BoundChannel<String>>> createLocalDatagramServer(IoHandlerFactory<? super DatagramChannel<String>> handlerFactory) {
        throw new UnsupportedOperationException("Local IPC Datagram Server");
    }

    public ConfigurableFactory<CloseableConnector<String, DatagramChannel<String>>> createLocalDatagramConnector(Executor executor) {
        throw new UnsupportedOperationException("Local IPC Datagram Connector");
    }

    public ConfigurableFactory<CloseableConnector<String, DatagramChannel<String>>> createLocalDatagramConnector() {
        throw new UnsupportedOperationException("Local IPC Datagram Connector");
    }

    public void awaken(Thread targetThread) {
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("XNIO provider \"%s\" <%s@%s>", this.getName(), this.getClass().getName(), Integer.toHexString(this.hashCode()));
    }

    @Override
    public abstract void close() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Closeable registerMBean(final Object mBean, final ObjectName mBeanName) {
        List<MBeanServer> servers;
        SecurityManager sm = System.getSecurityManager();
        List<MBeanServer> list = servers = this.mBeanServers;
        synchronized (list) {
            Iterator<MBeanServer> it = servers.iterator();
            if (!it.hasNext()) {
                return IoUtils.nullCloseable();
            }
            final ArrayList<Registration> registrations = new ArrayList<Registration>(servers.size());
            do {
                final MBeanServer server = it.next();
                if (sm != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            Xnio.doRegister(mBean, mBeanName, registrations, server);
                            return null;
                        }
                    });
                    continue;
                }
                Xnio.doRegister(mBean, mBeanName, registrations, server);
            } while (it.hasNext());
            return new RegHandle(registrations);
        }
    }

    private static void doRegister(Object mBean, ObjectName mBeanName, List<Registration> registrations, MBeanServer server) {
        try {
            ObjectInstance instance = server.registerMBean(mBean, mBeanName);
            registrations.add(new Registration(server, instance.getObjectName()));
        }
        catch (JMException e) {
            mlog.debug((Throwable)e, "Failed to register mBean named \"%s\" on server %s", (Object)mBeanName, (Object)server);
        }
        catch (RuntimeOperationsException e) {
            mlog.debug((Throwable)e, "Failed to register mBean named \"%s\" on server %s", (Object)mBeanName, (Object)server);
        }
    }

    private static Entry entry(final String k, final String v) {
        return new Entry(){

            public String getKey() {
                return k;
            }

            public String getValue() {
                return v;
            }

            public String setValue(String value) {
                throw new UnsupportedOperationException("setValue");
            }
        };
    }

    private static Hashtable<String, String> hashtable(Entry ... entries) {
        Hashtable<String, String> table = new Hashtable<String, String>(entries.length);
        for (Entry entry : entries) {
            table.put((String)entry.getKey(), (String)entry.getValue());
        }
        return table;
    }

    protected String getProperty(String name) {
        if (!name.startsWith("xnio.")) {
            throw new SecurityException("Not allowed to read non-XNIO properties");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new GetPropertyAction(name, null));
        }
        return System.getProperty(name);
    }

    protected String getProperty(String name, String defaultValue) {
        if (!name.startsWith("xnio.")) {
            throw new SecurityException("Not allowed to read non-XNIO properties");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new GetPropertyAction(name, defaultValue));
        }
        return System.getProperty(name, defaultValue);
    }

    protected Closeable registerMBean(TcpServerMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("providerType", ObjectName.quote(this.getClass().getName())), Xnio.entry("type", "server"), Xnio.entry("protocol", "tcp"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(TcpConnectionMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("providerType", ObjectName.quote(this.getClass().getName())), Xnio.entry("type", "connection"), Xnio.entry("protocol", "tcp"), Xnio.entry("duplex", "full"), Xnio.entry("bindAddress", ObjectName.quote(mBean.getBindAddress().toString())), Xnio.entry("peerAddress", ObjectName.quote(mBean.getPeerAddress().toString())), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(UdpServerMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("providerType", ObjectName.quote(this.getClass().getName())), Xnio.entry("type", "server"), Xnio.entry("protocol", "udp"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(OneWayPipeConnectionMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("providerType", ObjectName.quote(this.getClass().getName())), Xnio.entry("type", "connection"), Xnio.entry("protocol", "local"), Xnio.entry("duplex", "half"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(PipeConnectionMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("providerType", ObjectName.quote(this.getClass().getName())), Xnio.entry("type", "connection"), Xnio.entry("protocol", "local"), Xnio.entry("duplex", "full"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(PipeServerMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("providerType", ObjectName.quote(this.getClass().getName())), Xnio.entry("type", "server"), Xnio.entry("protocol", "local"), Xnio.entry("duplex", "full"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(PipeSourceServerMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("providerType", ObjectName.quote(this.getClass().getName())), Xnio.entry("type", "server"), Xnio.entry("protocol", "local"), Xnio.entry("duplex", "half"), Xnio.entry("direction", "source"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    protected Closeable registerMBean(PipeSinkServerMBean mBean) {
        try {
            ObjectName mbeanName = new ObjectName(MANAGEMENT_DOMAIN, Xnio.hashtable(Xnio.entry("provider", ObjectName.quote(this.getName())), Xnio.entry("providerType", ObjectName.quote(this.getClass().getName())), Xnio.entry("type", "server"), Xnio.entry("protocol", "local"), Xnio.entry("duplex", "half"), Xnio.entry("direction", "sink"), Xnio.entry("id", Long.toString(mbeanSequence.getAndIncrement()))));
            return this.registerMBean(mBean, mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    static {
        Logger.getLogger("org.jboss.xnio").info("XNIO Version 1.2.0.CR2");
        mbeanSequence = new AtomicLong();
        AGENTID_PROPNAME = "xnio.agentid";
        PROVIDER_PROPNAME = "xnio.provider";
        GET_PROVIDER_ACTION = new GetPropertyAction(PROVIDER_PROPNAME, NIO_IMPL_CLASS_NAME);
        GET_AGENTID_ACTION = new GetPropertyAction(AGENTID_PROPNAME, null);
        SUBCLASS_PERMISSION = new RuntimePermission("xnioProvider");
        String providerClassName = NIO_IMPL_CLASS_NAME;
        try {
            providerClassName = AccessController.doPrivileged(GET_PROVIDER_ACTION);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        PROVIDER_CLASS = providerClassName;
        xnioSequence = new AtomicInteger(1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetPropertyAction
    implements PrivilegedAction<String> {
        private final String propertyName;
        private final String defaultValue;

        private GetPropertyAction(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String run() {
            return System.getProperty(this.propertyName, this.defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetMBeanServersAction
    implements PrivilegedAction<Collection<? extends MBeanServer>> {
        private final String agentId;

        public GetMBeanServersAction(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public Collection<? extends MBeanServer> run() {
            return MBeanServerFactory.findMBeanServer(this.agentId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegHandle
    implements Closeable {
        private final List<Registration> registrations;
        private final AtomicBoolean open = new AtomicBoolean(true);

        private RegHandle(List<Registration> registrations) {
            this.registrations = registrations;
        }

        @Override
        public void close() throws IOException {
            if (this.open.getAndSet(false)) {
                SecurityManager sm = System.getSecurityManager();
                for (final Registration registration : this.registrations) {
                    if (sm != null) {
                        AccessController.doPrivileged(new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                RegHandle.doUnregister(registration);
                                return null;
                            }
                        });
                        continue;
                    }
                    RegHandle.doUnregister(registration);
                }
            }
        }

        private static void doUnregister(Registration registration) {
            MBeanServer server = registration.server;
            ObjectName mBeanName = registration.objectName;
            try {
                server.unregisterMBean(mBeanName);
            }
            catch (InstanceNotFoundException e) {
                mlog.debug((Throwable)e, "Failed to unregister mBean named \"%s\" on server %s", (Object)mBeanName, (Object)server);
            }
            catch (MBeanRegistrationException e) {
                mlog.debug((Throwable)e, "Failed to unregister mBean named \"%s\" on server %s", (Object)mBeanName, (Object)server);
            }
        }
    }

    private static final class Registration {
        private final MBeanServer server;
        private final ObjectName objectName;

        private Registration(MBeanServer server, ObjectName objectName) {
            this.server = server;
            this.objectName = objectName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Entry
    extends Map.Entry<String, String> {
    }
}

