/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIoFuture<T>
implements IoFuture<T> {
    private static final Logger log = Logger.getLogger("org.jboss.xnio.future");
    private final Object lock = new Object();
    private IoFuture.Status status = IoFuture.Status.WAITING;
    private Object result;
    private List<IoFuture.Notifier<T>> notifierList;

    protected AbstractIoFuture() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status getStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status await() {
        Object object = this.lock;
        synchronized (object) {
            boolean intr = false;
            try {
                while (this.status == IoFuture.Status.WAITING) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    @Override
    public IoFuture.Status await(long time, TimeUnit timeUnit) {
        if (time < 0L) {
            time = 0L;
        }
        if ((deadline = (duration = timeUnit.toMillis(time)) + System.currentTimeMillis()) < 0L) {
            deadline = 0x7FFFFFFFFFFFFFFFL;
        }
        var8_5 = this.lock;
        synchronized (var8_5) {
            block17: {
                intr = false;
                while (true) lbl-1000:
                // 3 sources

                {
                    if (this.status != IoFuture.Status.WAITING) break block17;
                    try {
                        this.lock.wait(duration);
                    }
                    catch (InterruptedException e) {
                        block18: {
                            intr = true;
                            if ((duration = deadline - System.currentTimeMillis()) > 0L) continue;
                            var10_9 = IoFuture.Status.WAITING;
                            if (!intr) break block18;
                            Thread.currentThread().interrupt();
                        }
                        return var10_9;
                        {
                            catch (Throwable var11_10) {
                                block19: {
                                    block20: {
                                        duration = deadline - System.currentTimeMillis();
                                        if (duration > 0L) break block19;
                                        var12_11 = IoFuture.Status.WAITING;
                                        if (!intr) break block20;
                                        Thread.currentThread().interrupt();
                                    }
                                    return var12_11;
                                }
                                throw var11_10;
                            }
                        }
                    }
                    duration = deadline - System.currentTimeMillis();
                    if (duration > 0L) ** GOTO lbl-1000
                    var10_8 = IoFuture.Status.WAITING;
                    return var10_8;
                    break;
                }
                finally {
                    if (intr) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status awaitInterruptibly() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.status == IoFuture.Status.WAITING) {
                this.lock.wait();
            }
            return this.status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoFuture.Status awaitInterruptibly(long time, TimeUnit timeUnit) throws InterruptedException {
        long duration;
        long deadline;
        if (time < 0L) {
            time = 0L;
        }
        if ((deadline = (duration = timeUnit.toMillis(time)) + System.currentTimeMillis()) < 0L) {
            deadline = Long.MAX_VALUE;
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.status == IoFuture.Status.WAITING) {
                this.lock.wait(duration);
                duration = deadline - System.currentTimeMillis();
                if (duration > 0L) continue;
                return IoFuture.Status.WAITING;
            }
            return this.status;
        }
    }

    @Override
    public T get() throws IOException, CancellationException {
        Object object = this.lock;
        synchronized (object) {
            switch (this.await()) {
                case DONE: {
                    return (T)this.result;
                }
                case FAILED: {
                    throw (IOException)this.result;
                }
                case CANCELLED: {
                    throw new CancellationException("Operation was cancelled");
                }
            }
            throw new IllegalStateException("Unexpected state " + (Object)((Object)this.status));
        }
    }

    @Override
    public T getInterruptibly() throws IOException, InterruptedException, CancellationException {
        Object object = this.lock;
        synchronized (object) {
            switch (this.awaitInterruptibly()) {
                case DONE: {
                    return (T)this.result;
                }
                case FAILED: {
                    throw (IOException)this.result;
                }
                case CANCELLED: {
                    throw new CancellationException("Operation was cancelled");
                }
            }
            throw new IllegalStateException("Unexpected state " + (Object)((Object)this.status));
        }
    }

    @Override
    public IOException getException() throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.FAILED) {
                return (IOException)this.result;
            }
            throw new IllegalStateException("getException() when state is not FAILED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotifier(IoFuture.Notifier<T> notifier) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                if (this.notifierList == null) {
                    this.notifierList = new ArrayList<IoFuture.Notifier<T>>();
                }
                this.notifierList.add(notifier);
            } else {
                this.runNotifier(notifier);
            }
        }
    }

    private void runAllNotifiers() {
        if (this.notifierList != null) {
            Iterator<IoFuture.Notifier<T>> it = this.notifierList.iterator();
            while (it.hasNext()) {
                IoFuture.Notifier<T> notifier = it.next();
                this.runNotifier(notifier);
                it.remove();
            }
            this.notifierList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setException(IOException exception) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                this.status = IoFuture.Status.FAILED;
                this.result = exception;
                this.runAllNotifiers();
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setResult(T result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                this.status = IoFuture.Status.DONE;
                this.result = result;
                this.runAllNotifiers();
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean finishCancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.status == IoFuture.Status.WAITING) {
                this.status = IoFuture.Status.CANCELLED;
                this.runAllNotifiers();
                this.lock.notifyAll();
                return true;
            }
            return false;
        }
    }

    @Override
    public IoFuture<T> cancel() {
        return this;
    }

    protected void runNotifier(final IoFuture.Notifier<T> notifier) {
        this.getNotifierExecutor().execute(new Runnable(){

            public void run() {
                try {
                    notifier.notify(AbstractIoFuture.this);
                }
                catch (Throwable t) {
                    log.warn(t, "Running notifier failed", new Object[0]);
                }
            }
        });
    }

    protected Executor getNotifierExecutor() {
        return IoUtils.directExecutor();
    }
}

