/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.jboss.xnio.channels.StreamSourceChannel;

public class ChannelInputStream
extends InputStream {
    protected final StreamSourceChannel channel;
    protected volatile boolean closed;

    public ChannelInputStream(StreamSourceChannel channel) {
        this.channel = channel;
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        byte[] array = new byte[1];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        do {
            int res;
            if ((res = this.channel.read(buffer)) == -1) {
                return -1;
            }
            if (res == 1) {
                return array[0] & 0xFF;
            }
            this.channel.awaitReadable();
        } while (!this.closed);
        return -1;
    }

    public int read(byte[] b) throws IOException {
        if (this.closed) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.wrap(b);
        do {
            int res;
            if ((res = this.channel.read(buffer)) == -1) {
                return -1;
            }
            if (res > 0) {
                return res;
            }
            this.channel.awaitReadable();
        } while (!this.closed);
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            return -1;
        }
        ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
        do {
            int res;
            if ((res = this.channel.read(buffer)) == -1) {
                return -1;
            }
            if (res > 0) {
                return res;
            }
            this.channel.awaitReadable();
        } while (!this.closed);
        return -1;
    }

    public void close() throws IOException {
        this.closed = true;
        super.close();
    }
}

