/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.channels.AllocatedMessageChannel;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AllocatedMessageChannelStreamChannelHandler
implements IoHandler<StreamChannel> {
    private static final Logger log = Logger.getLogger(AllocatedMessageChannelStreamChannelHandler.class);
    private volatile AllocatedMessageChannelImpl messageChannel;
    private final int maxInboundMessageSize;
    private final int maxOutboundMessageSize;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final IoHandler<? super AllocatedMessageChannel> handler;
    private final AtomicBoolean isnew = new AtomicBoolean(true);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Object readLock = new Object();
    private final ByteBuffer readLengthBuf = ByteBuffer.allocate(4);
    private long drainCnt;
    private ReadState readState = ReadState.LENGTH;
    private ByteBuffer readBuffer;
    private final Object writeLock = new Object();
    private final ByteBuffer writeLengthBuf = ByteBuffer.allocate(4);
    private WriteState writeState = WriteState.WAITING;
    private ByteBuffer writeBuffer;
    private IOException writeException;
    private boolean writeShutdown;

    AllocatedMessageChannelStreamChannelHandler(IoHandler<? super AllocatedMessageChannel> handler, int maxInboundMessageSize, int maxOutboundMessageSize) {
        this.handler = handler;
        this.maxInboundMessageSize = maxInboundMessageSize;
        this.maxOutboundMessageSize = maxOutboundMessageSize;
    }

    @Override
    public void handleOpened(StreamChannel channel) {
        if (this.isnew.getAndSet(false)) {
            this.messageChannel = new AllocatedMessageChannelImpl(channel);
        }
        if (channel.getOptions().contains(CommonOptions.TCP_NODELAY)) {
            try {
                channel.setOption(CommonOptions.TCP_NODELAY, Boolean.TRUE);
            }
            catch (IOException e) {
                log.trace("Setting TCP_NODELAY on channel %s failed: %s", channel, e);
            }
        }
        this.handler.handleOpened(this.messageChannel);
    }

    @Override
    public void handleReadable(StreamChannel channel) {
        this.handler.handleReadable(this.messageChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleWritable(StreamChannel channel) {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.writeException != null) {
                this.handler.handleWritable(this.messageChannel);
            } else {
                switch (this.writeState) {
                    case LENGTH: {
                        int cnt;
                        while (this.writeLengthBuf.hasRemaining()) {
                            try {
                                cnt = channel.write(this.writeLengthBuf);
                                if (cnt != 0) continue;
                                channel.resumeWrites();
                                return;
                            }
                            catch (IOException e) {
                                this.writeException = e;
                                this.handler.handleWritable(this.messageChannel);
                                return;
                            }
                        }
                        this.writeState = WriteState.BODY;
                    }
                    case BODY: {
                        int cnt;
                        while (this.writeBuffer.hasRemaining()) {
                            try {
                                cnt = channel.write(this.writeBuffer);
                                if (cnt != 0) continue;
                                channel.resumeWrites();
                                return;
                            }
                            catch (IOException e) {
                                this.writeException = e;
                                this.writeState = WriteState.FAILED;
                                this.handler.handleWritable(this.messageChannel);
                                return;
                            }
                        }
                        this.writeBuffer = null;
                        if (this.writeShutdown) {
                            this.writeShutdown = false;
                            try {
                                channel.shutdownWrites();
                            }
                            catch (IOException e) {
                                log.trace("Write shutdown failed: %s", e);
                            }
                            return;
                        }
                        this.writeState = WriteState.WAITING;
                    }
                    case WAITING: {
                        this.handler.handleWritable(this.messageChannel);
                        return;
                    }
                }
            }
        }
    }

    @Override
    public void handleClosed(StreamChannel channel) {
        this.handler.handleClosed(this.messageChannel);
    }

    AllocatedMessageChannel getChannel(StreamChannel channel) {
        if (this.isnew.getAndSet(false)) {
            this.messageChannel = new AllocatedMessageChannelImpl(channel);
        }
        return this.messageChannel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AllocatedMessageChannelImpl
    implements AllocatedMessageChannel {
        private final StreamChannel streamChannel;

        private AllocatedMessageChannelImpl(StreamChannel streamChannel) {
            this.streamChannel = streamChannel;
        }

        @Override
        public boolean isOpen() {
            return !AllocatedMessageChannelStreamChannelHandler.this.closed.get();
        }

        @Override
        public void close() throws IOException {
            if (AllocatedMessageChannelStreamChannelHandler.this.closed.getAndSet(true)) {
                this.streamChannel.close();
            }
        }

        @Override
        public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
            return this.streamChannel.getOption(option);
        }

        @Override
        public Set<ChannelOption<?>> getOptions() {
            return this.streamChannel.getOptions();
        }

        @Override
        public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
            this.streamChannel.setOption(option, value);
            return this;
        }

        @Override
        public boolean send(ByteBuffer buffer) throws IOException {
            return this.send(new ByteBuffer[]{buffer}, 0, 1);
        }

        @Override
        public boolean send(ByteBuffer[] buffers) throws IOException {
            return this.send(buffers, 0, buffers.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean send(ByteBuffer[] buffers, int offs, int len) throws IOException {
            long total = 0L;
            for (int i = 0; i < len; ++i) {
                total += (long)buffers[offs + i].remaining();
            }
            if (total > (long)AllocatedMessageChannelStreamChannelHandler.this.maxOutboundMessageSize) {
                throw new IOException("Packet too large");
            }
            Object object = AllocatedMessageChannelStreamChannelHandler.this.writeLock;
            synchronized (object) {
                if (AllocatedMessageChannelStreamChannelHandler.this.writeException != null) {
                    IOException e = new IOException("Write operation failed");
                    e.initCause(AllocatedMessageChannelStreamChannelHandler.this.writeException);
                    AllocatedMessageChannelStreamChannelHandler.this.writeException = null;
                    throw e;
                }
                switch (AllocatedMessageChannelStreamChannelHandler.this.writeState) {
                    case WAITING: {
                        long cnt;
                        AllocatedMessageChannelStreamChannelHandler.this.writeLengthBuf.clear();
                        AllocatedMessageChannelStreamChannelHandler.this.writeLengthBuf.putInt((int)total);
                        AllocatedMessageChannelStreamChannelHandler.this.writeLengthBuf.flip();
                        while (AllocatedMessageChannelStreamChannelHandler.this.writeLengthBuf.hasRemaining()) {
                            int cnt2 = this.streamChannel.write(AllocatedMessageChannelStreamChannelHandler.this.writeLengthBuf);
                            if (cnt2 != 0) continue;
                            if (AllocatedMessageChannelStreamChannelHandler.this.writeLengthBuf.remaining() == 4) {
                                return false;
                            }
                            AllocatedMessageChannelStreamChannelHandler.this.writeBuffer = ByteBuffer.allocate((int)total);
                            for (int i = 0; i < len; ++i) {
                                AllocatedMessageChannelStreamChannelHandler.this.writeBuffer.put(buffers[offs + i]);
                            }
                            AllocatedMessageChannelStreamChannelHandler.this.writeState = WriteState.LENGTH;
                            this.streamChannel.resumeWrites();
                            return true;
                        }
                        if (total == 0L) {
                            return true;
                        }
                        long sentTotal = 0L;
                        do {
                            if ((cnt = this.streamChannel.write(buffers, offs, len)) != 0L) continue;
                            int rem = (int)(total - sentTotal);
                            AllocatedMessageChannelStreamChannelHandler.this.writeBuffer = ByteBuffer.allocate(rem);
                            AllocatedMessageChannelStreamChannelHandler.this.writeState = WriteState.BODY;
                            this.streamChannel.resumeWrites();
                            return true;
                        } while ((sentTotal += cnt) != total);
                        return true;
                    }
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Override
        public ByteBuffer receive() throws IOException {
            Object object = AllocatedMessageChannelStreamChannelHandler.this.readLock;
            synchronized (object) {
                block12: while (true) {
                    switch (AllocatedMessageChannelStreamChannelHandler.this.readState) {
                        case EOF: {
                            return null;
                        }
                        case DRAIN: {
                            while (AllocatedMessageChannelStreamChannelHandler.this.drainCnt > 0L) {
                                int cnt;
                                AllocatedMessageChannelStreamChannelHandler.this.readBuffer.clear();
                                if ((long)AllocatedMessageChannelStreamChannelHandler.this.readBuffer.limit() > AllocatedMessageChannelStreamChannelHandler.this.drainCnt) {
                                    AllocatedMessageChannelStreamChannelHandler.this.readBuffer.limit((int)AllocatedMessageChannelStreamChannelHandler.this.drainCnt);
                                }
                                if ((cnt = this.streamChannel.read(AllocatedMessageChannelStreamChannelHandler.this.readBuffer)) == -1) {
                                    AllocatedMessageChannelStreamChannelHandler.this.readState = ReadState.EOF;
                                    AllocatedMessageChannelStreamChannelHandler.this.readBuffer = null;
                                    return null;
                                }
                                if (cnt != 0) continue;
                                return EMPTY_BUFFER;
                            }
                            AllocatedMessageChannelStreamChannelHandler.this.readBuffer = null;
                            AllocatedMessageChannelStreamChannelHandler.this.readState = ReadState.LENGTH;
                        }
                        case LENGTH: {
                            int c;
                            while (AllocatedMessageChannelStreamChannelHandler.this.readLengthBuf.hasRemaining()) {
                                c = this.streamChannel.read(AllocatedMessageChannelStreamChannelHandler.this.readLengthBuf);
                                if (c == -1) {
                                    AllocatedMessageChannelStreamChannelHandler.this.readState = ReadState.EOF;
                                    return null;
                                }
                                if (c != 0) continue;
                                return EMPTY_BUFFER;
                            }
                            AllocatedMessageChannelStreamChannelHandler.this.readLengthBuf.flip();
                            int len = AllocatedMessageChannelStreamChannelHandler.this.readLengthBuf.getInt();
                            if (len > AllocatedMessageChannelStreamChannelHandler.this.maxInboundMessageSize || len < 0) {
                                log.trace("Received oversized message (%d), draining", len);
                                AllocatedMessageChannelStreamChannelHandler.this.readState = ReadState.DRAIN;
                                AllocatedMessageChannelStreamChannelHandler.this.drainCnt = (long)len & 0xFFFFFFFFL;
                                continue block12;
                            }
                            AllocatedMessageChannelStreamChannelHandler.this.readBuffer = ByteBuffer.allocate(len);
                            AllocatedMessageChannelStreamChannelHandler.this.readState = ReadState.BODY;
                        }
                        case BODY: {
                            int c;
                            while (AllocatedMessageChannelStreamChannelHandler.this.readBuffer.hasRemaining()) {
                                c = this.streamChannel.read(AllocatedMessageChannelStreamChannelHandler.this.readBuffer);
                                if (c == -1) {
                                    AllocatedMessageChannelStreamChannelHandler.this.readState = ReadState.EOF;
                                    AllocatedMessageChannelStreamChannelHandler.this.readBuffer = null;
                                    return null;
                                }
                                if (c != 0) continue;
                                return EMPTY_BUFFER;
                            }
                            AllocatedMessageChannelStreamChannelHandler.this.readBuffer.flip();
                            try {
                                ByteBuffer byteBuffer = AllocatedMessageChannelStreamChannelHandler.this.readBuffer;
                                return byteBuffer;
                            }
                            finally {
                                AllocatedMessageChannelStreamChannelHandler.this.readBuffer = null;
                                AllocatedMessageChannelStreamChannelHandler.this.readState = ReadState.LENGTH;
                                AllocatedMessageChannelStreamChannelHandler.this.readLengthBuf.clear();
                            }
                        }
                    }
                    break;
                }
                throw new IllegalStateException();
            }
        }

        @Override
        public void suspendReads() {
            this.streamChannel.suspendReads();
        }

        @Override
        public void suspendWrites() {
            this.streamChannel.suspendWrites();
        }

        @Override
        public void resumeReads() {
            this.streamChannel.resumeReads();
        }

        @Override
        public void resumeWrites() {
            this.streamChannel.resumeWrites();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdownReads() throws IOException {
            Object object = AllocatedMessageChannelStreamChannelHandler.this.readLock;
            synchronized (object) {
                AllocatedMessageChannelStreamChannelHandler.this.readBuffer = null;
                AllocatedMessageChannelStreamChannelHandler.this.readState = ReadState.LENGTH;
                this.streamChannel.shutdownReads();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdownWrites() throws IOException {
            Object object = AllocatedMessageChannelStreamChannelHandler.this.writeLock;
            synchronized (object) {
                if (AllocatedMessageChannelStreamChannelHandler.this.writeState == WriteState.WAITING) {
                    this.streamChannel.shutdownWrites();
                }
                AllocatedMessageChannelStreamChannelHandler.this.writeBuffer = null;
                AllocatedMessageChannelStreamChannelHandler.this.writeState = WriteState.WAITING;
                this.streamChannel.shutdownWrites();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WriteState {
        FAILED,
        WAITING,
        LENGTH,
        BODY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ReadState {
        DRAIN,
        LENGTH,
        BODY,
        EOF;

    }
}

