/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.junit.ContextImpl;

class WeldCDIExtension
implements Extension {
    private final Set<Class<? extends Annotation>> scopesToActivate;
    private final Set<Bean<?>> beans;
    private final List<ContextImpl> contexts;

    public WeldCDIExtension(Set<Class<? extends Annotation>> scopesToActivate, Set<Bean<?>> beans) {
        this.scopesToActivate = scopesToActivate;
        this.beans = beans;
        this.contexts = new ArrayList<ContextImpl>();
    }

    void afterBeandiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        if (this.scopesToActivate != null) {
            for (Class<? extends Annotation> clazz : this.scopesToActivate) {
                ContextImpl ctx = new ContextImpl(clazz, beanManager);
                this.contexts.add(ctx);
                event.addContext((Context)ctx);
            }
        }
        if (this.beans != null) {
            for (Bean bean : this.beans) {
                event.addBean(bean);
            }
        }
    }

    public void activateContexts() {
        if (this.contexts.isEmpty()) {
            return;
        }
        for (ContextImpl context : this.contexts) {
            context.activate();
        }
    }

    public void deactivateContexts() {
        if (this.contexts.isEmpty()) {
            return;
        }
        for (ContextImpl context : this.contexts) {
            context.deactivate();
        }
    }
}

