/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.inject.Singleton;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.events.AbstractContainerEvent;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.beans.InstanceManager;
import org.jboss.weld.environment.se.beans.ParametersFactory;
import org.jboss.weld.environment.se.contexts.ThreadContext;
import org.jboss.weld.environment.se.contexts.activators.ActivateRequestScopeInterceptor;
import org.jboss.weld.environment.se.contexts.activators.ActivateThreadScope;
import org.jboss.weld.environment.se.contexts.activators.ActivateThreadScopeInterceptor;
import org.jboss.weld.environment.se.contexts.interceptors.ActivateThreadScope;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.environment.se.threading.RunnableDecorator;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.util.annotated.ForwardingAnnotatedType;

@Vetoed
public class WeldSEBeanRegistrant
implements Extension {
    private ThreadContext threadContext;

    public void registerWeldSEBeans(@Observes BeforeBeanDiscovery event, BeanManager manager) {
        if (WeldSEBeanRegistrant.ignoreEvent(event)) {
            return;
        }
        event.addAnnotatedType(VetoedSuppressedAnnotatedType.from(ParametersFactory.class, manager));
        event.addAnnotatedType(VetoedSuppressedAnnotatedType.from(InstanceManager.class, manager));
        event.addAnnotatedType(VetoedSuppressedAnnotatedType.from(RunnableDecorator.class, manager));
        event.addAnnotatedType(VetoedSuppressedAnnotatedType.from(ActivateRequestScopeInterceptor.class, manager));
        event.addAnnotatedType(VetoedSuppressedAnnotatedType.from(ActivateThreadScopeInterceptor.class, manager));
    }

    public void registerWeldSEContexts(@Observes AfterBeanDiscovery event, BeanManager manager) {
        if (WeldSEBeanRegistrant.ignoreEvent(event)) {
            return;
        }
        String contextId = BeanManagerProxy.unwrap(manager).getContextId();
        this.threadContext = new ThreadContext(contextId);
        event.addContext(this.threadContext);
        event.addBean(new WeldContainerBean(contextId));
    }

    <T> void replaceDeprecatedActivator(@Observes @WithAnnotations(value={ActivateThreadScope.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType<T> annotatedType = event.getAnnotatedType();
        WeldSELogger.LOG.deprecatedActivatorAnnotationUsed(ActivateThreadScope.class.getName(), org.jboss.weld.environment.se.contexts.activators.ActivateThreadScope.class.getName(), annotatedType.getJavaClass());
        event.setAnnotatedType(new AnnotatedTypeWrapper<T>(annotatedType));
    }

    private static boolean ignoreEvent(Object event) {
        return !(event instanceof AbstractContainerEvent);
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    static class AnnotatedMethodWrapper<X>
    implements AnnotatedMethod<X> {
        private final AnnotatedMethod<X> delegate;
        private final ImmutableSet<Annotation> annotations;

        public AnnotatedMethodWrapper(AnnotatedMethod<X> annotatedMethod) {
            this.delegate = annotatedMethod;
            this.annotations = this.replaceDeprecatedAnnotations(this.delegate.getAnnotations());
        }

        @Override
        public Method getJavaMember() {
            return this.delegate.getJavaMember();
        }

        @Override
        public List<AnnotatedParameter<X>> getParameters() {
            return this.delegate.getParameters();
        }

        @Override
        public boolean isStatic() {
            return this.delegate.isStatic();
        }

        @Override
        public AnnotatedType<X> getDeclaringType() {
            return this.delegate.getDeclaringType();
        }

        @Override
        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        @Override
        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            for (Annotation annotation : this.annotations) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                return (T)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        @Override
        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        private ImmutableSet<Annotation> replaceDeprecatedAnnotations(Set<Annotation> delegateAnnotations) {
            ImmutableSet.Builder annotationBuilder = ImmutableSet.builder();
            for (Annotation annotation : delegateAnnotations) {
                if (annotation.annotationType().equals(ActivateThreadScope.class)) {
                    annotationBuilder.add(ActivateThreadScope.Literal.INSTANCE);
                    continue;
                }
                annotationBuilder.add(annotation);
            }
            return annotationBuilder.build();
        }
    }

    static class AnnotatedTypeWrapper<X>
    implements AnnotatedType<X> {
        private final AnnotatedType<X> delegate;
        private final ImmutableSet<AnnotatedMethod<? super X>> annotatedMethods;
        private final ImmutableSet<Annotation> annotations;

        public AnnotatedTypeWrapper(AnnotatedType<X> annotatedType) {
            this.delegate = annotatedType;
            this.annotatedMethods = this.replaceDeprecatedAnnotatedMethods(this.delegate.getMethods());
            this.annotations = this.replaceDeprecatedAnnotations(this.delegate.getAnnotations());
        }

        @Override
        public Class<X> getJavaClass() {
            return this.delegate.getJavaClass();
        }

        @Override
        public Set<AnnotatedConstructor<X>> getConstructors() {
            return this.delegate.getConstructors();
        }

        @Override
        public Set<AnnotatedMethod<? super X>> getMethods() {
            return this.annotatedMethods;
        }

        @Override
        public Set<AnnotatedField<? super X>> getFields() {
            return this.delegate.getFields();
        }

        @Override
        public Type getBaseType() {
            return this.delegate.getBaseType();
        }

        @Override
        public Set<Type> getTypeClosure() {
            return this.delegate.getTypeClosure();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            for (Annotation annotation : this.annotations) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                return (T)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        @Override
        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        private ImmutableSet<AnnotatedMethod<? super X>> replaceDeprecatedAnnotatedMethods(Set<AnnotatedMethod<? super X>> delegateMethods) {
            ImmutableSet.Builder annotatedMethodBuilder = ImmutableSet.builder();
            for (AnnotatedMethod<X> originalMethod : delegateMethods) {
                if (originalMethod.isAnnotationPresent(ActivateThreadScope.class)) {
                    annotatedMethodBuilder.add(new AnnotatedMethodWrapper<X>(originalMethod));
                    continue;
                }
                annotatedMethodBuilder.add(originalMethod);
            }
            return annotatedMethodBuilder.build();
        }

        private ImmutableSet<Annotation> replaceDeprecatedAnnotations(Set<Annotation> delegateAnnotations) {
            ImmutableSet.Builder annotationBuilder = ImmutableSet.builder();
            for (Annotation annotation : delegateAnnotations) {
                if (annotation.annotationType().equals(ActivateThreadScope.class)) {
                    annotationBuilder.add(ActivateThreadScope.Literal.INSTANCE);
                    continue;
                }
                annotationBuilder.add(annotation);
            }
            return annotationBuilder.build();
        }
    }

    private static class WeldContainerBean
    implements Bean<WeldContainer> {
        private final String contextId;

        private WeldContainerBean(String contextId) {
            this.contextId = contextId;
        }

        @Override
        public WeldContainer create(CreationalContext<WeldContainer> creationalContext) {
            return WeldContainer.instance(this.contextId);
        }

        @Override
        public void destroy(WeldContainer instance, CreationalContext<WeldContainer> creationalContext) {
        }

        @Override
        public Set<Type> getTypes() {
            return ImmutableSet.of(WeldContainer.class, Object.class);
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return ImmutableSet.of(AnyLiteral.INSTANCE, DefaultLiteral.INSTANCE);
        }

        @Override
        public Class<? extends Annotation> getScope() {
            return Singleton.class;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        @Override
        public boolean isAlternative() {
            return false;
        }

        @Override
        public Class<?> getBeanClass() {
            return WeldSEBeanRegistrant.class;
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        @Override
        public boolean isNullable() {
            return false;
        }
    }

    private static class VetoedSuppressedAnnotatedType<T>
    extends ForwardingAnnotatedType<T> {
        private final AnnotatedType<T> annotatedType;

        static <T> VetoedSuppressedAnnotatedType<T> from(Class<T> clazz, BeanManager beanManager) {
            return new VetoedSuppressedAnnotatedType<T>(beanManager.createAnnotatedType(clazz));
        }

        public VetoedSuppressedAnnotatedType(AnnotatedType<T> annotatedType) {
            this.annotatedType = annotatedType;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            if (annotationType == Vetoed.class) {
                return null;
            }
            return this.annotatedType.getAnnotation(annotationType);
        }

        @Override
        public Set<Annotation> getAnnotations() {
            HashSet<Annotation> annotations = new HashSet<Annotation>();
            for (Annotation a : this.annotatedType.getAnnotations()) {
                if (a.annotationType() == Vetoed.class) continue;
                annotations.add(a);
            }
            return annotations;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            if (annotationType == Vetoed.class) {
                return false;
            }
            return this.annotatedType.isAnnotationPresent(annotationType);
        }

        @Override
        public AnnotatedType<T> delegate() {
            return this.annotatedType;
        }
    }
}

