/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.webbeans.integration.microcontainer.deployer.metadata;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.EjbJar30MetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.InterceptorClassesMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.virtual.VirtualFile;
import org.jboss.webbeans.integration.microcontainer.deployer.DeployersUtils;

/**
 * Adds wb custom interceptor to ejb deployments.
 *
 * @author <a href="mailto:ales.justin@jboss.org">Ales Justin</a>
 */
@SuppressWarnings("deprecation")
public class WBEjbInterceptorMetadataDeployer extends WebBeansAwareMetadataDeployer<JBossMetaData>
{
   private static final String INTERCEPTOR_CLASS_NAME = "org.jboss.webbeans.ejb.SessionBeanInterceptor";

   private InterceptorMetaData SBI;
   private InterceptorBindingMetaData IBMD;

   public WBEjbInterceptorMetadataDeployer()
   {
      super(JBossMetaData.class);
      
      addInput(DeployersUtils.WEB_BEANS_FILES);
      addInput("merged." + JBossMetaData.class.getName());
      setStage(DeploymentStages.POST_CLASSLOADER);

      // create interceptor metadata instance
      SBI = new InterceptorMetaData();
      SBI.setInterceptorClass(INTERCEPTOR_CLASS_NAME);

      // create interceptor binding metadata instance
      IBMD = new InterceptorBindingMetaData();
      InterceptorClassesMetaData interceptorClasses = new InterceptorClassesMetaData();
      interceptorClasses.add(INTERCEPTOR_CLASS_NAME);
      IBMD.setInterceptorClasses(interceptorClasses);
      IBMD.setEjbName("*");
   }

   protected void internalDeploy(VFSDeploymentUnit unit, JBossMetaData jbmd, VirtualFile wbXml) throws DeploymentException
   {
      InterceptorsMetaData interceptors = jbmd.getInterceptors();
      if (interceptors == null)
      {
         InterceptorsMetaData imd = new InterceptorsMetaData();
         imd.add(SBI);
         EjbJar3xMetaData ejmd = new EjbJar30MetaData();
         ejmd.setInterceptors(imd);

         jbmd.merge(null, ejmd);
      }
      else
      {
         interceptors.add(SBI); // clone?
      }

      JBossAssemblyDescriptorMetaData assemblyDescriptor = jbmd.getAssemblyDescriptor();
      if (assemblyDescriptor == null)
      {
         assemblyDescriptor = new JBossAssemblyDescriptorMetaData();
         jbmd.setAssemblyDescriptor(assemblyDescriptor);
      }
      InterceptorBindingsMetaData interceptorBindings = assemblyDescriptor.getInterceptorBindings();
      if (interceptorBindings == null)
      {
         interceptorBindings = new InterceptorBindingsMetaData();
         assemblyDescriptor.setInterceptorBindings(interceptorBindings);
      }
      interceptorBindings.add(IBMD); // clone?
   }
}