package org.jboss.webbeans.integration.microcontainer.deployer.cl;


import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

import org.jboss.deployers.vfs.plugins.classloader.PathUrlIntegrationDeployer;
import org.jboss.util.StringPropertyReplacer;

/**
 * Web Beans RI integration deployer.
 *
 * @param <T> exact input type
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public abstract class WebBeansUrlIntegrationDeployer<T> extends PathUrlIntegrationDeployer<T>
{
   protected WebBeansUrlIntegrationDeployer(Class<T> input)
   {
      super(input);
      setIntegrationURLs(getURLs());
      setFiles(new String[]{"META-INF/web-beans.xml", "WEB-INF/web-beans.xml"});
   }

   /**
    * Get the WebBeans integration urls.
    *
    * @return the webbeans jbossas integration urls
    */
   protected Set<URL> getURLs()
   {
      try
      {
         String libOpt = getServerHome() + getOptionalLib();
         libOpt = StringPropertyReplacer.replaceProperties(libOpt);

         Set<URL> urls = new HashSet<URL>(2);
         urls.add(new URL(libOpt + "webbeans-ri.jar"));
         urls.add(new URL(libOpt + "webbeans-ri-int-jbossas.jar"));
         return urls;
      }
      catch (MalformedURLException e)
      {
         throw new IllegalArgumentException("Unexpected error: " + e);
      }
   }

   /**
    * Get server home.
    *
    * @return the jboss server home location
    */
   protected String getServerHome()
   {
      return "${jboss.server.home.url}";
   }

   /**
    * Get the optinal lib path.
    *
    * @return the integration path
    */
   protected String getOptionalLib()
   {
      return "deployers/webbeans.deployer/lib-int/";
   }
}
