/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import javax.net.ssl.SSLSession;
import org.apache.tomcat.util.net.SSLSupport;
import org.jboss.web.CoyoteLogger;
import org.jboss.web.CoyoteMessages;

public abstract class SSLImplementation {
    private static final String[] implementations = new String[]{"org.apache.tomcat.util.net.jsse.JSSEImplementation"};

    public static SSLImplementation getInstance() throws ClassNotFoundException {
        for (int i = 0; i < implementations.length; ++i) {
            try {
                SSLImplementation impl = SSLImplementation.getInstance(implementations[i]);
                return impl;
            }
            catch (Exception e) {
                if (!CoyoteLogger.UTIL_LOGGER.isTraceEnabled()) continue;
                CoyoteLogger.UTIL_LOGGER.trace("Error creating " + implementations[i], e);
                continue;
            }
        }
        throw new ClassNotFoundException(CoyoteMessages.MESSAGES.noSslImplementation());
    }

    public static SSLImplementation getInstance(String className) throws ClassNotFoundException {
        if (className == null) {
            return SSLImplementation.getInstance();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (SSLImplementation)clazz.newInstance();
        }
        catch (Exception e) {
            if (CoyoteLogger.UTIL_LOGGER.isDebugEnabled()) {
                CoyoteLogger.UTIL_LOGGER.debug("Error loading SSL Implementation " + className, e);
            }
            throw new ClassNotFoundException(CoyoteMessages.MESSAGES.errorLoadingSslImplementation(className), e);
        }
    }

    public abstract String getImplementationName();

    public abstract SSLSupport getSSLSupport(SSLSession var1);
}

