/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.StringManager;
import org.jboss.logging.Logger;

public class HostConfig
implements LifecycleListener {
    protected static Logger log = Logger.getLogger(HostConfig.class);
    protected File appBase = null;
    protected File configBase = null;
    protected String configClass = "org.apache.catalina.startup.ContextConfig";
    protected String contextClass = "org.apache.catalina.core.StandardContext";
    protected Host host = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected ArrayList<String> serviced = new ArrayList();

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.host = (Host)((Object)event.getLifecycle());
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("hostConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("periodic")) {
            this.check();
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    protected File appBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected File configBase() {
        if (this.configBase != null) {
            return this.configBase;
        }
        File file = new File(System.getProperty("catalina.base"), "conf");
        Container parent = this.host.getParent();
        if (parent != null && parent instanceof Engine) {
            file = new File(file, parent.getName());
        }
        file = new File(file, this.host.getName());
        try {
            this.configBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.configBase = file;
        }
        return this.configBase;
    }

    public String getConfigBaseName() {
        return this.configBase().getAbsolutePath();
    }

    protected String getConfigFile(String path) {
        String basename = null;
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    protected String getDocBase(String path) {
        String basename = null;
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.start"));
        }
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.stop"));
        }
        this.undeployApps();
        this.appBase = null;
        this.configBase = null;
    }

    protected void undeployApps() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.undeploying"));
        }
    }

    protected void check() {
    }
}

