/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.threads.ExecutionInterruptedException;
import org.jboss.threads.ExecutionTimedOutException;
import org.jboss.threads.InterruptHandler;
import org.jboss.threads.Messages;
import org.jboss.threads.StoppedExecutorException;
import org.jboss.threads.ThreadCreationException;

public class Messages_$logger
extends DelegatingBasicLogger
implements Messages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Messages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void version(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.version$str(), (Object)version);
    }

    protected String version$str() {
        return "JBoss Threads version %s";
    }

    protected String noThreadCreated$str() {
        return "JBTHR00001: Thread factory did not produce a thread";
    }

    @Override
    public final ThreadCreationException noThreadCreated() {
        ThreadCreationException result = new ThreadCreationException(String.format(this.getLoggingLocale(), this.noThreadCreated$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String taskLimitReached$str() {
        return "JBTHR00002: Task limit reached";
    }

    @Override
    public final RejectedExecutionException taskLimitReached() {
        RejectedExecutionException result = new RejectedExecutionException(String.format(this.getLoggingLocale(), this.taskLimitReached$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationTimedOut$str() {
        return "JBTHR00003: Operation timed out";
    }

    @Override
    public final TimeoutException operationTimedOut() {
        TimeoutException result = new TimeoutException(String.format(this.getLoggingLocale(), this.operationTimedOut$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationCancelled$str() {
        return "JBTHR00004: Operation was cancelled";
    }

    @Override
    public final CancellationException operationCancelled() {
        CancellationException result = new CancellationException(String.format(this.getLoggingLocale(), this.operationCancelled$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String operationFailed$str() {
        return "JBTHR00005: Operation failed";
    }

    @Override
    public final ExecutionException operationFailed(Throwable cause) {
        ExecutionException result = new ExecutionException(String.format(this.getLoggingLocale(), this.operationFailed$str(), new Object[0]), cause);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddThread$str() {
        return "JBTHR00006: Unable to add new thread to the running set";
    }

    @Override
    public final ThreadCreationException cannotAddThread() {
        ThreadCreationException result = new ThreadCreationException(String.format(this.getLoggingLocale(), this.cannotAddThread$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String executionInterrupted$str() {
        return "JBTHR00007: Task execution interrupted";
    }

    @Override
    public final ExecutionInterruptedException executionInterrupted() {
        ExecutionInterruptedException result = new ExecutionInterruptedException(String.format(this.getLoggingLocale(), this.executionInterrupted$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String executionRejected$str() {
        return "JBTHR00008: Task rejected";
    }

    @Override
    public final RejectedExecutionException executionRejected() {
        RejectedExecutionException result = new RejectedExecutionException(String.format(this.getLoggingLocale(), this.executionRejected$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String shutDownInitiated$str() {
        return "JBTHR00009: Executor has been shut down";
    }

    @Override
    public final StoppedExecutorException shutDownInitiated() {
        StoppedExecutorException result = new StoppedExecutorException(String.format(this.getLoggingLocale(), this.shutDownInitiated$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String executionTimedOut$str() {
        return "JBTHR00010: Task execution timed out";
    }

    @Override
    public final ExecutionTimedOutException executionTimedOut() {
        ExecutionTimedOutException result = new ExecutionTimedOutException(String.format(this.getLoggingLocale(), this.executionTimedOut$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void executionFailed(Throwable cause, Runnable task) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.executionFailed$str(), (Object)task);
    }

    protected String executionFailed$str() {
        return "JBTHR00011: Task execution failed for task %s";
    }

    protected String cannotAwaitWithin$str() {
        return "JBTHR00012: Cannot await termination of a thread pool from one of its own threads";
    }

    @Override
    public final IllegalStateException cannotAwaitWithin() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotAwaitWithin$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noExecutorsAvailable$str() {
        return "JBTHR00013: No executors available to run task";
    }

    @Override
    public final RejectedExecutionException noExecutorsAvailable() {
        RejectedExecutionException result = new RejectedExecutionException(String.format(this.getLoggingLocale(), this.noExecutorsAvailable$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void taskSubmitFailed(RejectedExecutionException e, Runnable task) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.taskSubmitFailed$str(), (Object)task);
    }

    protected String taskSubmitFailed$str() {
        return "JBTHR00014: Error submitting task %s to executor";
    }

    protected String keepAliveNotZero$str() {
        return "JBTHR00100: Keep-alive may only be set to 0 for this executor type";
    }

    @Override
    public final IllegalArgumentException keepAliveNotZero() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.keepAliveNotZero$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotReduceMaxBelowCurrent$str() {
        return "JBTHR00101: Cannot reduce maximum threads below current thread number of running threads";
    }

    @Override
    public final IllegalArgumentException cannotReduceMaxBelowCurrent() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotReduceMaxBelowCurrent$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String arrayNotEmpty$str() {
        return "JBTHR00102: Empty array parameter is not empty";
    }

    @Override
    public final IllegalArgumentException arrayNotEmpty() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.arrayNotEmpty$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noInterruptHandlers$str() {
        return "JBTHR00103: The current thread does not support interrupt handlers";
    }

    @Override
    public final IllegalStateException noInterruptHandlers() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noInterruptHandlers$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notShutDown$str() {
        return "JBTHR00104: Executor is not shut down";
    }

    @Override
    public final IllegalStateException notShutDown() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.notShutDown$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String concurrentModification$str() {
        return "JBTHR00105: Concurrent modification of collection detected";
    }

    @Override
    public final ConcurrentModificationException concurrentModification() {
        ConcurrentModificationException result = new ConcurrentModificationException(String.format(this.getLoggingLocale(), this.concurrentModification$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noSuchElement$str() {
        return "JBTHR00106: No such element (iteration past end)";
    }

    @Override
    public final NoSuchElementException noSuchElement() {
        NoSuchElementException result = new NoSuchElementException(String.format(this.getLoggingLocale(), this.noSuchElement$str(), new Object[0]));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownThrowable$str() {
        return "JBTHR00107: Unknown throwable received";
    }

    @Override
    public final RuntimeException unknownThrowable(Throwable t) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unknownThrowable$str(), new Object[0]), t);
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void interruptHandlerThrew(Throwable cause, InterruptHandler interruptHandler) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.interruptHandlerThrew$str(), (Object)interruptHandler);
    }

    protected String interruptHandlerThrew$str() {
        return "JBTHR00108: Interrupt handler %s threw an exception";
    }

    protected String notAllowedContainerManaged$str() {
        return "JBTHR00200: %s() not allowed on container-managed executor";
    }

    @Override
    public final SecurityException notAllowedContainerManaged(String methodName) {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.notAllowedContainerManaged$str(), methodName));
        Messages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

