/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.jboss.profiler.jvmti.JVMTIInterface;

public class JBossMemoryTestCase
extends TestCase {
    public JBossMemoryTestCase() {
    }

    public JBossMemoryTestCase(String name) {
        super(name);
    }

    protected static ClassLoader newClassLoader(Class anyUserClass) throws Exception {
        URL classLocation = anyUserClass.getProtectionDomain().getCodeSource().getLocation();
        StringTokenizer tokenString = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        String pathIgnore = System.getProperty("java.home");
        if (pathIgnore == null) {
            pathIgnore = classLocation.toString();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        while (tokenString.hasMoreElements()) {
            String value = tokenString.nextToken();
            URL itemLocation = new File(value).toURL();
            if (itemLocation.equals(classLocation) || itemLocation.toString().indexOf(pathIgnore) < 0) continue;
            urls.add(itemLocation);
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        URLClassLoader masterClassLoader = URLClassLoader.newInstance(urlArray, null);
        URLClassLoader appClassLoader = URLClassLoader.newInstance(new URL[]{classLocation}, masterClassLoader);
        return appClassLoader;
    }

    private static void resetObject(Object object, Field[] fields) {
        for (int fieldN = 0; fieldN < fields.length; ++fieldN) {
            try {
                System.out.print("        Field[" + fieldN + "] " + fields[fieldN].getName());
                fields[fieldN].set(object, null);
                System.out.println("...done");
                continue;
            }
            catch (Exception e) {
                System.out.println("...error " + e.getMessage());
            }
        }
    }

    protected void checkUnload(WeakReference weakReferenceOnLoader, String className, String reportHTMLFile) throws Exception {
        JVMTIInterface jvmti = new JVMTIInterface();
        if (jvmti.isActive()) {
            jvmti.forceGC();
            Class clazz = jvmti.getClassByName(className);
            if (clazz != null) {
                jvmti.heapSnapshot("snapshot", "mem");
                clazz = null;
                String report = jvmti.exploreClassReferences(className, 10, true, false, false, false, false);
                System.out.println(report);
                File outputfile = new File(reportHTMLFile);
                FileOutputStream outfile = new FileOutputStream(outputfile);
                PrintStream realoutput = new PrintStream(outfile);
                realoutput.println(report);
                realoutput.close();
                jvmti.forceGC();
                clazz = jvmti.getClassByName(className);
                if (clazz == null) {
                    System.out.println("Attention: After clearing every field on AspectManager, GC could release the classLoader");
                }
                JBossMemoryTestCase.fail((String)("Class " + className + " still referenced. Look at report for more details"));
            }
        } else {
            System.gc();
            Thread.sleep(1000L);
        }
        JBossMemoryTestCase.assertNull((String)"The classLoader is supposed to be released. Something is holding a reference. If you activate -agentlib:jbossAgent this testcase will generate a report with referenceHolders.", weakReferenceOnLoader.get());
    }

    private Field[] getDeclaredFields(Class clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class classIteration = clazz; classIteration != null; classIteration = classIteration.getSuperclass()) {
            Field[] fields = classIteration.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                list.add(fields[i]);
            }
        }
        return list.toArray(new Field[list.size()]);
    }

    protected void clearEverySingleFieldOnInstances(String className) {
        System.out.println("Clearing " + className);
        JVMTIInterface jvmti = new JVMTIInterface();
        Class[] classes = jvmti.getLoadedClasses();
        Object[] objects = null;
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].getName().equals(className)) continue;
            Field[] fields = this.getDeclaredFields(classes[i]);
            objects = jvmti.getAllObjects(classes[i]);
            for (int j = 0; j < objects.length; ++j) {
                JBossMemoryTestCase.resetObject(objects[j], fields);
            }
            if (objects.length != 0) continue;
            JBossMemoryTestCase.resetObject(null, fields);
        }
        classes = null;
        objects = null;
    }
}

