/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import org.teiid.core.util.HashCodeUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.proc.Statement;

public class BranchingStatement
extends Statement {
    private String label;
    private BranchingMode mode;

    public BranchingStatement() {
        this(BranchingMode.BREAK);
    }

    public BranchingStatement(BranchingMode mode) {
        this.mode = mode;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMode(BranchingMode mode) {
        this.mode = mode;
    }

    public BranchingMode getMode() {
        return this.mode;
    }

    @Override
    public int getType() {
        switch (this.mode) {
            case BREAK: {
                return 9;
            }
            case CONTINUE: {
                return 8;
            }
            case LEAVE: {
                return 12;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public BranchingStatement clone() {
        BranchingStatement clone = new BranchingStatement();
        clone.mode = this.mode;
        clone.label = this.label;
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BranchingStatement)) {
            return false;
        }
        BranchingStatement other = (BranchingStatement)obj;
        return StringUtil.equalsIgnoreCase((String)this.label, (String)other.label) && this.mode == other.mode;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.mode.hashCode(), (Object[])new Object[0]);
    }

    public static enum BranchingMode {
        BREAK,
        CONTINUE,
        LEAVE;

    }
}

