/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class JoinType
implements LanguageObject {
    public static final JoinType JOIN_INNER = new JoinType(0, false);
    public static final JoinType JOIN_RIGHT_OUTER = new JoinType(1, true);
    public static final JoinType JOIN_LEFT_OUTER = new JoinType(2, true);
    public static final JoinType JOIN_FULL_OUTER = new JoinType(3, true);
    public static final JoinType JOIN_CROSS = new JoinType(4, false);
    public static final JoinType JOIN_UNION = new JoinType(5, true);
    public static final JoinType JOIN_SEMI = new JoinType(6, false);
    public static final JoinType JOIN_ANTI_SEMI = new JoinType(7, true);
    private int type;
    private boolean outer;

    private JoinType(int type, boolean outer) {
        this.type = type;
        this.outer = outer;
    }

    int getTypeCode() {
        return this.type;
    }

    public JoinType getReverseType() {
        if (this.equals(JOIN_RIGHT_OUTER)) {
            return JOIN_LEFT_OUTER;
        }
        if (this.equals(JOIN_LEFT_OUTER)) {
            return JOIN_RIGHT_OUTER;
        }
        return this;
    }

    public boolean isOuter() {
        return this.outer;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JoinType)) {
            return false;
        }
        return ((JoinType)other).getTypeCode() == this.type;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        return this.type;
    }

    @Override
    public Object clone() {
        return this;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

