/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.SymbolMap;

public class ProjectNode
extends SubqueryAwareRelationalNode {
    private List<? extends Expression> selectSymbols;
    private Map<Expression, Integer> elementMap;
    private boolean needsProject = true;
    private List<Expression> expressions;
    private int[] projectionIndexes;
    private TupleBatch currentBatch;
    private int currentRow = 1;

    protected ProjectNode() {
    }

    public ProjectNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.currentBatch = null;
        this.currentRow = 1;
    }

    public List<? extends Expression> getSelectSymbols() {
        return this.selectSymbols;
    }

    public void setSelectSymbols(List<? extends Expression> symbols) {
        this.selectSymbols = symbols;
        this.elementMap = Collections.emptyMap();
        this.projectionIndexes = new int[this.selectSymbols.size()];
        Arrays.fill(this.projectionIndexes, -1);
        this.expressions = new ArrayList<Expression>(this.selectSymbols.size());
        for (Expression expression : this.selectSymbols) {
            this.expressions.add(SymbolMap.getExpression(expression));
        }
    }

    @Override
    public void addChild(RelationalNode child) {
        super.addChild(child);
        this.init();
    }

    void init() {
        List<? extends Expression> childElements = this.getChildren()[0].getElements();
        this.elementMap = ProjectNode.createLookupMap(childElements);
        this.needsProject = childElements.size() != this.selectSymbols.size();
        for (int i = 0; i < this.selectSymbols.size(); ++i) {
            Integer index;
            Expression symbol = this.selectSymbols.get(i);
            if (symbol instanceof AliasSymbol) {
                index = this.elementMap.get(symbol);
                if (index != null && index == i) {
                    this.projectionIndexes[i] = index;
                    continue;
                }
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            if ((index = this.elementMap.get(symbol)) == null || index != i) {
                this.needsProject = true;
                continue;
            }
            this.projectionIndexes[i] = index;
        }
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.currentBatch == null) {
            if (this.getChildren()[0] == null) {
                this.currentBatch = new TupleBatch(1, new List[]{Arrays.asList(new Object[0])});
                this.currentBatch.setTerminationFlag(true);
            } else {
                this.currentBatch = this.getChildren()[0].nextBatch();
            }
            if (!this.needsProject) {
                TupleBatch result = this.currentBatch;
                this.currentBatch = null;
                return result;
            }
        }
        while (this.currentRow <= this.currentBatch.getEndRow() && !this.isBatchFull()) {
            List tuple = this.currentBatch.getTuple(this.currentRow);
            ArrayList<Object> projectedTuple = new ArrayList<Object>(this.selectSymbols.size());
            for (int i = 0; i < this.expressions.size(); ++i) {
                Expression symbol = this.expressions.get(i);
                this.updateTuple(symbol, i, tuple, projectedTuple);
            }
            this.addBatchRow(projectedTuple);
            ++this.currentRow;
        }
        if (this.currentRow > this.currentBatch.getEndRow()) {
            if (this.currentBatch.getTerminationFlag()) {
                this.terminateBatches();
            }
            this.currentBatch = null;
        }
        return this.pullBatch();
    }

    private void updateTuple(Expression symbol, int projectionIndex, List<?> values, List<Object> tuple) throws BlockedException, TeiidComponentException, ExpressionEvaluationException {
        int index = this.projectionIndexes[projectionIndex];
        if (index != -1) {
            tuple.add(values.get(index));
        } else {
            tuple.add(this.getEvaluator(this.elementMap).evaluate(symbol, values));
        }
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.selectSymbols);
    }

    @Override
    public Object clone() {
        ProjectNode clonedNode = new ProjectNode();
        this.copyTo(clonedNode);
        return clonedNode;
    }

    protected void copyTo(ProjectNode target) {
        super.copyTo(target);
        target.selectSymbols = this.selectSymbols;
        target.needsProject = this.needsProject;
        target.elementMap = this.elementMap;
        target.expressions = this.expressions;
        target.projectionIndexes = this.projectionIndexes;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects(props, "Select Columns", this.selectSymbols);
        return props;
    }

    @Override
    protected Collection<? extends LanguageObject> getObjects() {
        return this.selectSymbols;
    }

    @Override
    public boolean hasFinalBuffer() {
        return !this.needsProject && this.getChildren()[0].hasFinalBuffer();
    }

    @Override
    public TupleBuffer getFinalBuffer(int maxRows) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        return this.getChildren()[0].getFinalBuffer(maxRows);
    }
}

