/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import org.teiid.client.ProcedureErrorInstructionException;
import org.teiid.client.plan.PlanNode;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.sql.symbol.Expression;

public class ErrorInstruction
extends ProgramInstruction {
    public static final String ERROR_PREFIX = "Procedure error:";
    private Expression expression;

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public ErrorInstruction clone() {
        ErrorInstruction clone = new ErrorInstruction();
        clone.expression = this.expression;
        return clone;
    }

    public String toString() {
        return "RAISE ERROR INSTRUCTION: " + this.expression;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode node = new PlanNode("RAISE ERROR");
        node.addProperty("Expression", this.expression.toString());
        return node;
    }

    @Override
    public void process(ProcedurePlan env) throws TeiidComponentException, TeiidProcessingException {
        Object value = env.evaluateExpression(this.expression);
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Processing RaiseErrorInstruction with the value :", value});
        throw new ProcedureErrorInstructionException((BundleUtil.Event)QueryPlugin.Event.TEIID30167, ERROR_PREFIX + (value != null ? value.toString() : ""));
    }
}

