/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.HashSet;
import java.util.List;
import org.teiid.query.mapping.xml.MappingAllNode;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingChoiceNode;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingSequenceNode;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Navigator;

public class MarkExcludeVisitor
extends MappingVisitor {
    HashSet<String> keepNodes;

    public MarkExcludeVisitor(HashSet<String> keepNodes) {
        this.keepNodes = keepNodes;
    }

    @Override
    public void visit(MappingAllNode all) {
        all.setExclude(true);
    }

    @Override
    public void visit(MappingSourceNode element) {
        element.setExclude(true);
    }

    @Override
    public void visit(MappingChoiceNode choice) {
        choice.setExclude(true);
    }

    @Override
    public void visit(MappingRecursiveElement element) {
        element.setExclude(true);
    }

    @Override
    public void visit(MappingSequenceNode sequence) {
        sequence.setExclude(true);
    }

    @Override
    public void visit(MappingAttribute attribute) {
        String name = attribute.getFullyQualifiedName();
        if (this.keepNodes.contains(name)) {
            if (!attribute.isExcluded()) {
                this.includeSelf(attribute.getParentNode());
                this.includeAncestors(attribute.getParentNode());
            }
        } else if (!attribute.isAlwaysInclude()) {
            attribute.setExclude(true);
        }
    }

    @Override
    public void visit(MappingElement element) {
        String name = element.getFullyQualifiedName();
        if (this.keepNodes.contains(name)) {
            if (!element.isExcluded()) {
                this.includeSelf(element);
                this.includeAncestors(element);
            }
        } else if (!element.isAlwaysInclude()) {
            element.setExclude(true);
        }
    }

    void includeSelf(MappingBaseNode element) {
        MappingElement elem;
        List attributes;
        element.setExclude(false);
        if (element instanceof MappingElement && (attributes = (elem = (MappingElement)element).getAttributes()) != null && !attributes.isEmpty()) {
            for (MappingAttribute attribute : attributes) {
                if (!attribute.isAlwaysInclude()) continue;
                attribute.setExclude(false);
            }
        }
    }

    void includeAncestors(MappingBaseNode element) {
        MappingBaseNode parent = element.getParentNode();
        if (parent != null) {
            this.includeSelf(parent);
            this.includeAncestors(parent);
        }
    }

    public static MappingDocument markExcludedNodes(MappingDocument doc, HashSet<String> keepNodes) {
        MarkExcludeVisitor visitor = new MarkExcludeVisitor(keepNodes);
        doc.acceptVisitor(new Navigator(true, visitor));
        return doc;
    }
}

