/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.SymbolMap;

public class PartitionAnalyzer {
    public static Map<ElementSymbol, List<Set<Constant>>> extractPartionInfo(SetQuery setQuery, List<ElementSymbol> projectedSymbols) {
        LinkedList<Query> queries = new LinkedList<Query>();
        if (!PartitionAnalyzer.extractQueries(setQuery, queries)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<ElementSymbol, List<Set<Constant>>> partitions = new LinkedHashMap<ElementSymbol, List<Set<Constant>>>();
        boolean first = true;
        for (Query query : queries) {
            Map<ElementSymbol, Set<Constant>> info = PartitionAnalyzer.extractPartitionInfo(query, projectedSymbols);
            partitions.keySet().retainAll(info.keySet());
            if (first) {
                first = false;
                for (Map.Entry<ElementSymbol, Set<Constant>> entry : info.entrySet()) {
                    ArrayList<Set<Constant>> values = new ArrayList<Set<Constant>>(queries.size());
                    partitions.put(entry.getKey(), values);
                    values.add(entry.getValue());
                }
                continue;
            }
            Set keys = partitions.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                ElementSymbol elementSymbol = (ElementSymbol)iter.next();
                List values = (List)partitions.get(elementSymbol);
                Set<Constant> value = info.get(elementSymbol);
                for (Set set : values) {
                    if (Collections.disjoint(set, value)) continue;
                    iter.remove();
                }
                values.add(value);
            }
        }
        return partitions;
    }

    public static boolean extractQueries(QueryCommand queryCommand, List<Query> result) {
        if (queryCommand instanceof SetQuery) {
            SetQuery sq = (SetQuery)queryCommand;
            if (sq.isAll() && sq.getOperation() == SetQuery.Operation.UNION && sq.getOrderBy() == null && sq.getLimit() == null && sq.getWith() == null) {
                if (!PartitionAnalyzer.extractQueries(sq.getLeftQuery(), result)) {
                    return false;
                }
                return PartitionAnalyzer.extractQueries(sq.getRightQuery(), result);
            }
            return false;
        }
        result.add((Query)queryCommand);
        return true;
    }

    private static Map<ElementSymbol, Set<Constant>> extractPartitionInfo(Query query, List<ElementSymbol> projectedSymbols) {
        Set<Constant> values;
        List<Expression> projected = query.getSelect().getProjectedSymbols();
        List<Criteria> crits = Criteria.separateCriteriaByAnd(query.getCriteria());
        HashMap inMap = new HashMap();
        for (Criteria criteria : crits) {
            if (criteria instanceof CompareCriteria) {
                CompareCriteria cc = (CompareCriteria)criteria;
                if (cc.getOperator() != 1) continue;
                if (cc.getLeftExpression() instanceof Constant) {
                    inMap.put(cc.getRightExpression(), new HashSet<Constant>(Arrays.asList((Constant)cc.getLeftExpression())));
                    continue;
                }
                if (!(cc.getRightExpression() instanceof Constant)) continue;
                inMap.put(cc.getLeftExpression(), new HashSet<Constant>(Arrays.asList((Constant)cc.getRightExpression())));
                continue;
            }
            if (!(criteria instanceof SetCriteria)) continue;
            SetCriteria sc = (SetCriteria)criteria;
            values = new HashSet();
            boolean allConstants = true;
            for (Expression exp : sc.getValues()) {
                if (exp instanceof Constant) {
                    ((HashSet)values).add((Constant)exp);
                    continue;
                }
                allConstants = false;
                break;
            }
            if (!allConstants) continue;
            inMap.put(sc.getExpression(), values);
        }
        HashMap<ElementSymbol, Set<Constant>> result = new HashMap<ElementSymbol, Set<Constant>>();
        for (int i = 0; i < projected.size(); ++i) {
            Expression ex = SymbolMap.getExpression(projected.get(i));
            if (DataTypeManager.isNonComparable((String)DataTypeManager.getDataTypeName(ex.getType()))) continue;
            if (ex instanceof Constant) {
                result.put(projectedSymbols.get(i), Collections.singleton((Constant)ex));
                continue;
            }
            values = (Set)inMap.get(ex);
            if (values == null) continue;
            result.put(projectedSymbols.get(i), values);
        }
        return result;
    }
}

