/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function.aggregate;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.function.aggregate.SingleArgumentAggregateFunction;
import org.teiid.query.util.CommandContext;

public class ArrayAgg
extends SingleArgumentAggregateFunction {
    private ArrayList<Object> result;

    @Override
    public void addInputDirect(Object input, List<?> tuple, CommandContext commandContext) throws TeiidComponentException, TeiidProcessingException {
        if (this.result == null) {
            this.result = new ArrayList();
        }
        this.result.add(input);
        if (this.result.size() > 1000) {
            throw new AssertionError((Object)"Exceeded the max allowable array size of 1000.");
        }
    }

    @Override
    public Object getResult(CommandContext commandContext) throws FunctionExecutionException, ExpressionEvaluationException, TeiidComponentException, TeiidProcessingException {
        if (this.result == null) {
            return null;
        }
        return this.result.toArray();
    }

    @Override
    public void reset() {
        this.result = null;
    }

    @Override
    public boolean respectsNull() {
        return true;
    }
}

