/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import org.teiid.core.util.Base64;

public final class CharsetUtils {
    public static final String HEX_NAME = "HEX";
    static final char[] hex_alphabet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static Charset HEX = new Charset("HEX", new String[0]){

        @Override
        public CharsetEncoder newEncoder() {
            return new FixedEncoder(this, 2, 0.5f, 1.0f){
                char[] chars;
                {
                    this.chars = new char[2];
                }

                @Override
                protected CoderResult encode(ByteBuffer out) {
                    this.cb.get(this.chars);
                    out.put((byte)(Integer.parseInt(new String(this.chars), 16) & 0xFF));
                    return CoderResult.UNDERFLOW;
                }
            };
        }

        @Override
        public CharsetDecoder newDecoder() {
            return new FixedDecoder(this, 1, 2.0f, 2.0f){

                @Override
                public void decode(CharBuffer out) {
                    byte b = this.bb.get();
                    CharsetUtils.toHex(out, b);
                }
            };
        }

        @Override
        public boolean contains(Charset cs) {
            return false;
        }
    };
    public static final String BASE64_NAME = "BASE64";
    public static Charset BASE64 = new Charset("BASE64", new String[0]){

        @Override
        public CharsetEncoder newEncoder() {
            return new FixedEncoder(this, 4, 0.75f, 1.0f){

                @Override
                protected CoderResult encode(ByteBuffer out) {
                    try {
                        out.put(Base64.decode((CharSequence)this.cb));
                        return CoderResult.UNDERFLOW;
                    }
                    catch (IllegalArgumentException e) {
                        return CoderResult.unmappableForLength(4);
                    }
                }
            };
        }

        @Override
        public CharsetDecoder newDecoder() {
            return new FixedDecoder(this, 3, 1.25f, 3.0f){

                @Override
                public void decode(CharBuffer out) {
                    if (this.bb.limit() == this.bb.array().length) {
                        out.put(Base64.encodeBytes((byte[])this.bb.array()));
                    } else {
                        out.put(Base64.encodeBytes((byte[])Arrays.copyOf(this.bb.array(), this.bb.limit())));
                    }
                }
            };
        }

        @Override
        public boolean contains(Charset cs) {
            return false;
        }
    };

    public static void toHex(CharBuffer out, byte b) {
        out.put(hex_alphabet[(b & 0xF0) >> 4]);
        out.put(hex_alphabet[b & 0xF]);
    }

    public static abstract class FixedDecoder
    extends CharsetDecoder {
        protected ByteBuffer bb;

        protected FixedDecoder(Charset cs, int decodeBytes, float averageCharsPerByte, float maxCharsPerByte) {
            super(cs, averageCharsPerByte, maxCharsPerByte);
            this.bb = ByteBuffer.wrap(new byte[decodeBytes]);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                this.bb.put(in.get());
                if (this.bb.hasRemaining()) continue;
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                this.bb.flip();
                this.decode(out);
                this.bb.clear();
            }
            return CoderResult.UNDERFLOW;
        }

        protected abstract void decode(CharBuffer var1);

        @Override
        protected CoderResult implFlush(CharBuffer out) {
            if (this.bb.position() != 0) {
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                this.bb.flip();
                this.decode(out);
                this.bb.clear();
            }
            return super.implFlush(out);
        }

        @Override
        protected void implReset() {
            this.bb.clear();
        }
    }

    public static abstract class FixedEncoder
    extends CharsetEncoder {
        protected CharBuffer cb;

        protected FixedEncoder(Charset cs, int encodeChars, float averageBytesPerChar, float maxBytesPerChar) {
            super(cs, averageBytesPerChar, maxBytesPerChar);
            this.cb = CharBuffer.wrap(new char[encodeChars]);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                this.cb.put(in.get());
                if (this.cb.hasRemaining()) continue;
                if (!out.hasRemaining()) {
                    return CoderResult.OVERFLOW;
                }
                this.cb.flip();
                CoderResult result = this.encode(out);
                if (result != CoderResult.UNDERFLOW) {
                    return result;
                }
                this.cb.clear();
            }
            return CoderResult.UNDERFLOW;
        }

        protected abstract CoderResult encode(ByteBuffer var1);

        @Override
        protected CoderResult implFlush(ByteBuffer out) {
            if (this.cb.position() != 0) {
                return CoderResult.unmappableForLength(this.cb.position());
            }
            return super.implFlush(out);
        }

        @Override
        protected void implReset() {
            this.cb.clear();
        }
    }
}

