/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.StringUtil;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.query.metadata.BasicQueryMetadataWrapper;
import org.teiid.query.metadata.QueryMetadataInterface;

public class MultiSourceMetadataWrapper
extends BasicQueryMetadataWrapper {
    private static final String SUFFIX = ".SOURCE_NAME";
    private Set<String> multiSourceModels;

    public MultiSourceMetadataWrapper(QueryMetadataInterface actualMetadata, Set<String> multiSourceModels) {
        super(actualMetadata);
        this.multiSourceModels = multiSourceModels;
    }

    public static String getGroupName(String fullElementName) {
        int index = fullElementName.lastIndexOf(46);
        if (index >= 0) {
            return fullElementName.substring(0, index);
        }
        return null;
    }

    @Override
    public Object getElementID(String elementName) throws TeiidComponentException, QueryMetadataException {
        if (StringUtil.endsWithIgnoreCase((String)elementName, (String)SUFFIX)) {
            try {
                String groupName = MultiSourceMetadataWrapper.getGroupName(elementName);
                Object groupID = this.getGroupID(groupName);
                List elements = this.getElementIDsInGroupID(groupID);
                for (Object id : elements) {
                    if (!(id instanceof MultiSourceElement)) continue;
                    return id;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.actualMetadata.getElementID(elementName);
    }

    @Override
    public Object getModelID(Object groupOrElementID) throws TeiidComponentException, QueryMetadataException {
        if (groupOrElementID instanceof MultiSourceElement) {
            Object groupID = ((MultiSourceElement)groupOrElementID).groupID;
            return this.getModelID(groupID);
        }
        return this.actualMetadata.getModelID(groupOrElementID);
    }

    @Override
    public String getFullName(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof MultiSourceElement) {
            return ((MultiSourceElement)metadataID).fullName;
        }
        return this.actualMetadata.getFullName(metadataID);
    }

    @Override
    public String getName(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof MultiSourceElement) {
            return "SOURCE_NAME";
        }
        return this.actualMetadata.getName(metadataID);
    }

    @Override
    public List getElementIDsInGroupID(Object groupID) throws TeiidComponentException, QueryMetadataException {
        ArrayList<MultiSourceElement> elements = this.actualMetadata.getElementIDsInGroupID(groupID);
        Object modelID = this.getModelID(groupID);
        String modelName = this.getFullName(modelID);
        if (this.multiSourceModels.contains(modelName)) {
            elements = new ArrayList<MultiSourceElement>(elements);
            String fullName = this.getFullName(groupID) + "." + "SOURCE_NAME";
            boolean elementExists = false;
            for (int i = 0; i < elements.size(); ++i) {
                Object elemID = elements.get(i);
                if (!this.actualMetadata.getName(elemID).equalsIgnoreCase("SOURCE_NAME")) continue;
                elements.set(i, new MultiSourceElement(groupID, i + 1, fullName));
                elementExists = true;
                break;
            }
            if (!elementExists) {
                int position = elements.size() + 1;
                elements.add(new MultiSourceElement(groupID, position, fullName));
            }
        }
        return elements;
    }

    @Override
    public Object getGroupIDForElementID(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return ((MultiSourceElement)elementID).groupID;
        }
        return this.actualMetadata.getGroupIDForElementID(elementID);
    }

    @Override
    public String getElementType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return "string";
        }
        return this.actualMetadata.getElementType(elementID);
    }

    @Override
    public Object getDefaultValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return null;
        }
        return this.actualMetadata.getDefaultValue(elementID);
    }

    @Override
    public Object getMinimumValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return null;
        }
        return this.actualMetadata.getMinimumValue(elementID);
    }

    @Override
    public Object getMaximumValue(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return null;
        }
        return this.actualMetadata.getMaximumValue(elementID);
    }

    @Override
    public int getDistinctValues(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return ((MultiSourceElement)elementID).position;
        }
        return this.actualMetadata.getDistinctValues(elementID);
    }

    @Override
    public int getNullValues(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return ((MultiSourceElement)elementID).position;
        }
        return this.actualMetadata.getNullValues(elementID);
    }

    @Override
    public int getPosition(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return ((MultiSourceElement)elementID).position;
        }
        return this.actualMetadata.getPosition(elementID);
    }

    @Override
    public int getPrecision(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return 0;
        }
        return this.actualMetadata.getPrecision(elementID);
    }

    @Override
    public int getScale(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return 0;
        }
        return this.actualMetadata.getScale(elementID);
    }

    @Override
    public int getRadix(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return 0;
        }
        return this.actualMetadata.getRadix(elementID);
    }

    @Override
    public boolean elementSupports(Object elementID, int elementConstant) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            switch (elementConstant) {
                case 4: {
                    return false;
                }
                case 10: {
                    return false;
                }
                case 2: {
                    return true;
                }
                case 1: {
                    return true;
                }
                case 0: {
                    return true;
                }
                case 5: {
                    return true;
                }
                case 7: {
                    return false;
                }
                case 8: {
                    return false;
                }
                case 9: {
                    return false;
                }
                case 11: {
                    return false;
                }
            }
            throw new UnsupportedOperationException("Attempt to check support for unknown constant: " + elementConstant);
        }
        return this.actualMetadata.elementSupports(elementID, elementConstant);
    }

    @Override
    public Properties getExtensionProperties(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof MultiSourceElement) {
            return new Properties();
        }
        return this.actualMetadata.getExtensionProperties(metadataID);
    }

    @Override
    public String getNameInSource(Object metadataID) throws TeiidComponentException, QueryMetadataException {
        if (metadataID instanceof MultiSourceElement) {
            return null;
        }
        return this.actualMetadata.getNameInSource(metadataID);
    }

    @Override
    public int getElementLength(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return 255;
        }
        return this.actualMetadata.getElementLength(elementID);
    }

    @Override
    public String getNativeType(Object elementID) throws TeiidComponentException, QueryMetadataException {
        if (elementID instanceof MultiSourceElement) {
            return null;
        }
        return this.actualMetadata.getNativeType(elementID);
    }

    @Override
    public boolean isMultiSource(Object modelId) throws QueryMetadataException, TeiidComponentException {
        return this.multiSourceModels.contains(this.getFullName(modelId));
    }

    @Override
    public boolean isMultiSourceElement(Object elementId) throws QueryMetadataException, TeiidComponentException {
        Object modelID;
        String modelName;
        if (elementId instanceof MultiSourceElement) {
            return true;
        }
        Object gid = this.getGroupIDForElementID(elementId);
        if (this.isProcedure(gid) && this.multiSourceModels.contains(modelName = this.getFullName(modelID = this.getModelID(gid)))) {
            String shortName = this.getName(elementId);
            return shortName.equalsIgnoreCase("SOURCE_NAME");
        }
        return false;
    }

    @Override
    public QueryMetadataInterface getDesignTimeMetadata() {
        return new MultiSourceMetadataWrapper(this.actualMetadata.getDesignTimeMetadata(), this.multiSourceModels);
    }
}

