/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;

public class MultiSourceCapabilitiesFinder
implements CapabilitiesFinder {
    private CapabilitiesFinder finder;
    private Collection multiSourceModels;

    public MultiSourceCapabilitiesFinder(CapabilitiesFinder finder, Collection multiSourceModels) {
        this.finder = finder;
        this.multiSourceModels = multiSourceModels;
    }

    @Override
    public SourceCapabilities findCapabilities(String modelName) throws TeiidComponentException {
        SourceCapabilities caps = this.finder.findCapabilities(modelName);
        if (this.multiSourceModels.contains(modelName)) {
            caps = this.modifyCapabilities(caps);
        }
        return caps;
    }

    SourceCapabilities modifyCapabilities(SourceCapabilities caps) {
        MultiSourceHandler handler = new MultiSourceHandler(caps);
        return (SourceCapabilities)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{SourceCapabilities.class}, (InvocationHandler)handler);
    }

    private static class MultiSourceHandler
    implements InvocationHandler {
        private SourceCapabilities caps;
        private static final String CAPABILITY_METHOD = "supportsCapability";
        private static final Set<SourceCapabilities.Capability> DISALLOWED_CAPABILITIES = new HashSet<SourceCapabilities.Capability>(Arrays.asList(SourceCapabilities.Capability.QUERY_UNION, SourceCapabilities.Capability.QUERY_EXCEPT, SourceCapabilities.Capability.QUERY_INTERSECT, SourceCapabilities.Capability.QUERY_AGGREGATES_AVG, SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT, SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR, SourceCapabilities.Capability.QUERY_AGGREGATES_DISTINCT, SourceCapabilities.Capability.QUERY_AGGREGATES_MAX, SourceCapabilities.Capability.QUERY_AGGREGATES_MIN, SourceCapabilities.Capability.QUERY_AGGREGATES_SUM, SourceCapabilities.Capability.QUERY_GROUP_BY, SourceCapabilities.Capability.QUERY_HAVING, SourceCapabilities.Capability.QUERY_ORDERBY, SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, SourceCapabilities.Capability.ROW_LIMIT, SourceCapabilities.Capability.ROW_OFFSET));

        public MultiSourceHandler(SourceCapabilities caps) {
            this.caps = caps;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            SourceCapabilities.Capability capability;
            String methodName = method.getName();
            if (methodName.equals(CAPABILITY_METHOD) && DISALLOWED_CAPABILITIES.contains((Object)(capability = (SourceCapabilities.Capability)((Object)args[0])))) {
                return Boolean.FALSE;
            }
            return method.invoke((Object)this.caps, args);
        }
    }
}

