/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.ResizingArrayList;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ExecutionContextImpl;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.dqp.internal.datamgr.ProcedureBatchHandler;
import org.teiid.dqp.internal.datamgr.RuntimeMetadataImpl;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.language.Call;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.resource.spi.WrappedConnection;
import org.teiid.translator.CacheDirective;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.ReusableExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;

public class ConnectorWorkItem
implements ConnectorWork {
    private AtomicRequestID id;
    private ConnectorManager manager;
    private AtomicRequestMessage requestMsg;
    private ExecutionFactory<Object, Object> connector;
    private RuntimeMetadataImpl queryMetadata;
    private Object connection;
    private Object connectionFactory;
    private ExecutionContextImpl securityContext;
    private volatile ResultSetExecution execution;
    private ProcedureBatchHandler procedureBatchHandler;
    private int expectedColumns;
    private boolean lastBatch;
    private int rowCount;
    private boolean error;
    private AtomicBoolean isCancelled = new AtomicBoolean();
    private org.teiid.language.Command translatedCommand;
    private DataNotAvailableException dnae;

    ConnectorWorkItem(AtomicRequestMessage message, ConnectorManager manager) {
        this.id = message.getAtomicRequestID();
        this.requestMsg = message;
        this.manager = manager;
        AtomicRequestID requestID = this.requestMsg.getAtomicRequestID();
        this.securityContext = new ExecutionContextImpl(message.getCommandContext(), this.requestMsg.getConnectorName(), Integer.toString(requestID.getNodeID()), Integer.toString(requestID.getExecutionId()));
        this.securityContext.setGeneralHint(message.getGeneralHint());
        this.securityContext.setHint(message.getHint());
        this.securityContext.setBatchSize(this.requestMsg.getFetchSize());
        this.securityContext.setSession((Session)this.requestMsg.getWorkContext().getSession());
        this.connector = manager.getExecutionFactory();
        VDBMetaData vdb = this.requestMsg.getWorkContext().getVDB();
        QueryMetadataInterface qmi = (QueryMetadataInterface)vdb.getAttachment(QueryMetadataInterface.class);
        qmi = new TempMetadataAdapter(qmi, new TempMetadataStore());
        this.queryMetadata = new RuntimeMetadataImpl(qmi);
        this.securityContext.setTransactional(this.requestMsg.isTransactional());
        LanguageBridgeFactory factory = new LanguageBridgeFactory(this.queryMetadata);
        factory.setConvertIn(!this.connector.supportsInCriteria());
        this.translatedCommand = factory.translate(message.getCommand());
    }

    @Override
    public void setRequestWorkItem(RequestWorkItem item) {
        this.securityContext.setRequestWorkItem(item);
    }

    public AtomicRequestID getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        try {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Processing CANCEL request"});
            if (this.isCancelled.compareAndSet(false, true)) {
                this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.CANCEL, -1);
                if (this.execution != null) {
                    this.execution.cancel();
                }
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{QueryPlugin.Util.getString("DQPCore.The_atomic_request_has_been_cancelled", new Object[]{this.id})});
            }
        }
        catch (TranslatorException e) {
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30024, new Object[]{this.id}));
        }
    }

    @Override
    public AtomicResultsMessage more() throws TranslatorException {
        if (this.dnae != null) {
            DataNotAvailableException e = this.dnae;
            this.dnae = null;
            throw e;
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Processing MORE request"});
        try {
            return this.handleBatch();
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void close() {
        block14: {
            this.securityContext.setRequestWorkItem(null);
            if (!this.manager.removeState(this.id)) {
                return;
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Processing Close :", this.requestMsg.getCommand()});
            if (!this.error) {
                this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.END, this.rowCount);
            }
            if (this.execution != null) {
                this.execution.close();
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed execution"});
            }
            if (this.connection == null) break block14;
            try {
                this.connector.closeConnection(this.connection, this.connectionFactory);
            }
            catch (Throwable e) {
                LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)e.getMessage());
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed connection"});
            break block14;
            catch (Throwable e) {
                try {
                    LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e, (Object)e.getMessage());
                    if (this.connection == null) break block14;
                }
                catch (Throwable throwable) {
                    if (this.connection != null) {
                        try {
                            this.connector.closeConnection(this.connection, this.connectionFactory);
                        }
                        catch (Throwable e2) {
                            LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e2, (Object)e2.getMessage());
                        }
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed connection"});
                    }
                    throw throwable;
                }
                try {
                    this.connector.closeConnection(this.connection, this.connectionFactory);
                }
                catch (Throwable e3) {
                    LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)e3, (Object)e3.getMessage());
                }
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Closed connection"});
            }
        }
    }

    private TranslatorException handleError(Throwable t) {
        if (t instanceof DataNotAvailableException) {
            throw (DataNotAvailableException)t;
        }
        this.error = true;
        if (t instanceof RuntimeException && t.getCause() != null) {
            t = t.getCause();
        }
        this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.ERROR, null);
        String msg = QueryPlugin.Util.getString("ConnectorWorker.process_failed", new Object[]{this.id});
        if (this.isCancelled.get()) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{msg});
        } else if (t instanceof TranslatorException || t instanceof TeiidProcessingException) {
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Throwable)t, (Object)msg);
        } else {
            LogManager.logError((String)"org.teiid.CONNECTOR", (Throwable)t, (Object)msg);
        }
        if (t instanceof TranslatorException) {
            return (TranslatorException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        return new TranslatorException(t);
    }

    @Override
    public void execute() throws TranslatorException {
        if (this.isCancelled()) {
            throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30476, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30476, new Object[0]));
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.requestMsg.getAtomicRequestID(), "Processing NEW request:", this.requestMsg.getCommand()});
        try {
            Execution exec;
            block14: {
                try {
                    this.connectionFactory = this.manager.getConnectionFactory();
                }
                catch (TranslatorException e) {
                    if (!this.connector.isSourceRequired()) break block14;
                    throw e;
                }
            }
            if (this.connectionFactory != null) {
                this.connection = this.connector.getConnection(this.connectionFactory, (ExecutionContext)this.securityContext);
            }
            if (this.connection == null && this.connector.isSourceRequired()) {
                throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID31108, QueryPlugin.Util.getString("datasource_not_found", new Object[]{this.manager.getConnectionName()}));
            }
            Connection unwrapped = null;
            if (this.connection instanceof WrappedConnection) {
                try {
                    unwrapped = ((WrappedConnection)this.connection).unwrap();
                }
                catch (ResourceException e) {
                    throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30477, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30477, new Object[0]));
                }
            }
            Command command = this.requestMsg.getCommand();
            this.expectedColumns = command.getProjectedSymbols().size();
            if (command instanceof StoredProcedure) {
                this.expectedColumns = ((StoredProcedure)command).getResultSetColumns().size();
            }
            if ((exec = this.requestMsg.getCommandContext().getReusableExecution(this.securityContext.getPartIdentifier())) != null) {
                exec.reset(this.translatedCommand, (ExecutionContext)this.securityContext, this.connection);
            } else {
                exec = this.connector.createExecution(this.translatedCommand, (ExecutionContext)this.securityContext, (RuntimeMetadata)this.queryMetadata, unwrapped == null ? this.connection : unwrapped);
                if (exec instanceof ReusableExecution) {
                    this.requestMsg.getCommandContext().putReusableExecution(this.securityContext.getPartIdentifier(), (ReusableExecution)exec);
                }
            }
            this.setExecution(command, this.translatedCommand, exec);
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.requestMsg.getAtomicRequestID(), "Obtained execution"});
            this.manager.logSRCCommand(this.requestMsg, this.securityContext, CommandLogMessage.Event.NEW, null);
            this.execution.execute();
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Executed command"});
        }
        catch (Throwable t) {
            throw this.handleError(t);
        }
    }

    private void setExecution(Command command, org.teiid.language.Command translatedCommand, final Execution exec) {
        if (translatedCommand instanceof Call) {
            this.execution = (ResultSetExecution)Assertion.isInstanceOf((Object)exec, ProcedureExecution.class, (String)"Call Executions are expected to be ProcedureExecutions");
            StoredProcedure proc = (StoredProcedure)command;
            if (proc.returnParameters()) {
                this.procedureBatchHandler = new ProcedureBatchHandler((Call)translatedCommand, (ProcedureExecution)exec);
            }
        } else if (command instanceof QueryCommand) {
            this.execution = (ResultSetExecution)Assertion.isInstanceOf((Object)exec, ResultSetExecution.class, (String)"QueryExpression Executions are expected to be ResultSetExecutions");
        } else {
            Assertion.isInstanceOf((Object)exec, UpdateExecution.class, (String)"Update Executions are expected to be UpdateExecutions");
            this.execution = new ResultSetExecution(){
                private int[] results;
                private int index;

                public void cancel() throws TranslatorException {
                    exec.cancel();
                }

                public void close() {
                    exec.close();
                }

                public void execute() throws TranslatorException {
                    exec.execute();
                }

                public List<?> next() throws TranslatorException, DataNotAvailableException {
                    if (this.results == null) {
                        this.results = ((UpdateExecution)exec).getUpdateCounts();
                    }
                    if (this.index < this.results.length) {
                        return Arrays.asList(this.results[this.index++]);
                    }
                    return null;
                }
            };
        }
    }

    protected AtomicResultsMessage handleBatch() throws TranslatorException {
        List<?> row;
        ResizingArrayList rows;
        block14: {
            Assertion.assertTrue((!this.lastBatch ? 1 : 0) != 0);
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Getting results from connector"});
            int batchSize = 0;
            rows = new ResizingArrayList(batchSize / 4);
            try {
                while (batchSize < this.requestMsg.getFetchSize()) {
                    row = this.execution.next();
                    if (row == null) {
                        this.lastBatch = true;
                        break;
                    }
                    if (row.size() != this.expectedColumns) {
                        throw new AssertionError((Object)("Inproper results returned.  Expected " + this.expectedColumns + " columns, but was " + row.size()));
                    }
                    ++this.rowCount;
                    ++batchSize;
                    if (this.procedureBatchHandler != null) {
                        row = this.procedureBatchHandler.padRow(row);
                    }
                    rows.add(row);
                    if (this.requestMsg.getMaxResultRows() <= -1 || this.rowCount < this.requestMsg.getMaxResultRows()) continue;
                    if (this.rowCount == this.requestMsg.getMaxResultRows() && !this.requestMsg.isExceptionOnMaxRows()) {
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Exceeded max, returning", this.requestMsg.getMaxResultRows()});
                        this.lastBatch = true;
                        break;
                    }
                    if (this.rowCount <= this.requestMsg.getMaxResultRows() || !this.requestMsg.isExceptionOnMaxRows()) continue;
                    String msg = QueryPlugin.Util.getString("ConnectorWorker.MaxResultRowsExceed", new Object[]{this.requestMsg.getMaxResultRows()});
                    throw new TranslatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30478, msg);
                }
            }
            catch (DataNotAvailableException e) {
                if (rows.size() == 0) {
                    throw e;
                }
                if (e.getWaitUntil() == null) break block14;
                this.dnae = e;
            }
        }
        if (this.lastBatch) {
            if (this.procedureBatchHandler != null && (row = this.procedureBatchHandler.getParameterRow()) != null) {
                rows.add(row);
                ++this.rowCount;
            }
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Obtained last batch, total row count:", this.rowCount});
        } else {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{this.id, "Obtained results from connector, current row count:", this.rowCount});
        }
        int currentRowCount = rows.size();
        if (!this.lastBatch && currentRowCount == 0) {
            LogManager.logWarning((String)"org.teiid.CONNECTOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30004, new Object[]{this.requestMsg.getConnectorName()}));
        }
        AtomicResultsMessage response = ConnectorWorkItem.createResultsMessage(rows.toArray(new List[currentRowCount]));
        response.setSupportsImplicitClose(!this.securityContext.keepExecutionAlive());
        response.setWarnings(this.securityContext.getWarnings());
        if (this.securityContext.getCacheDirective() != null) {
            response.setScope(this.securityContext.getCacheDirective().getScope());
        }
        if (this.lastBatch) {
            response.setFinalRow(this.rowCount);
        }
        return response;
    }

    @Override
    public boolean areLobsUsableAfterClose() {
        return this.connector.areLobsUsableAfterClose();
    }

    public static AtomicResultsMessage createResultsMessage(List<?>[] batch) {
        return new AtomicResultsMessage(batch);
    }

    boolean isCancelled() {
        return this.isCancelled.get();
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public boolean isDataAvailable() {
        return this.securityContext.isDataAvailable();
    }

    @Override
    public boolean copyLobs() {
        return this.connector.isCopyLobs();
    }

    @Override
    public CacheDirective getCacheDirective() throws TranslatorException {
        CacheDirective cd = this.connector.getCacheDirective(this.translatedCommand, (ExecutionContext)this.securityContext, (RuntimeMetadata)this.queryMetadata);
        this.securityContext.setCacheDirective(cd);
        return cd;
    }

    @Override
    public boolean isForkable() {
        return this.connector.isForkable();
    }
}

