/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.lang.ref.WeakReference;
import org.teiid.common.buffer.BaseCacheEntry;
import org.teiid.common.buffer.CacheKey;
import org.teiid.common.buffer.Serializer;

public class CacheEntry
extends BaseCacheEntry {
    private boolean persistent;
    private Object object;
    private final int sizeEstimate;
    private WeakReference<? extends Serializer<?>> serializer;

    public CacheEntry(Long oid) {
        this(new CacheKey(oid, 0L, 0L), 0, null, null, false);
    }

    public CacheEntry(CacheKey key, int sizeEstimate, Object object, WeakReference<? extends Serializer<?>> serializer, boolean persistent) {
        super(key);
        this.sizeEstimate = sizeEstimate;
        this.object = object;
        this.serializer = serializer;
        this.persistent = persistent;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public int getSizeEstimate() {
        return this.sizeEstimate;
    }

    public Object nullOut() {
        Object result = this.getObject();
        this.object = null;
        this.serializer = null;
        return result;
    }

    public Object getObject() {
        return this.object;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setSerializer(WeakReference<? extends Serializer<?>> serializer) {
        this.serializer = serializer;
    }

    public Serializer<?> getSerializer() {
        WeakReference<Serializer<?>> ref = this.serializer;
        if (ref == null) {
            return null;
        }
        return (Serializer)ref.get();
    }
}

