/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jboss.serial.util.StringUtilBuffer;

public class StringUtil {
    static boolean optimizeStrings = true;
    private static final Logger log = Logger.getLogger(StringUtil.class);
    private static final boolean isDebug = log.isDebugEnabled();
    private static ThreadLocal currenBuffer = new ThreadLocal();

    private static void flushByteBuffer(DataOutput out, byte[] byteBuffer, StringUtilBuffer.Position pos) throws IOException {
        out.write(byteBuffer, 0, pos.pos);
        pos.pos = 0;
    }

    public static void saveString(DataOutput out, String str, StringUtilBuffer buffer) throws IOException {
        long len;
        if (!optimizeStrings) {
            StringUtil.saveString(out, str);
            return;
        }
        if (buffer == null) {
            buffer = StringUtil.getThreadLocalBuffer();
        }
        if ((len = StringUtil.calculateUTFSize(str, buffer)) > 65535L) {
            out.writeBoolean(true);
            out.writeLong(len);
        } else {
            out.writeBoolean(false);
            out.writeShort((short)len);
        }
        if (len == (long)str.length()) {
            if (len > (long)buffer.byteBuffer.length) {
                buffer.resizeByteBuffer((int)len);
            }
            int byteLocation = 0;
            while ((long)byteLocation < len) {
                buffer.byteBuffer[byteLocation] = (byte)buffer.charBuffer[byteLocation];
                ++byteLocation;
            }
            out.write(buffer.byteBuffer, 0, (int)len);
        } else {
            int countArray;
            if (isDebug) {
                log.debug((Object)("Saving string with utfSize=" + len + " stringSize=" + str.length()));
            }
            StringUtilBuffer.Position pos = buffer.position.reset();
            int stringLength = str.length();
            for (int bufferPosition = 0; bufferPosition < stringLength; bufferPosition += countArray) {
                countArray = Math.min(stringLength - bufferPosition, buffer.charBuffer.length);
                str.getChars(bufferPosition, bufferPosition + countArray, buffer.charBuffer, 0);
                for (int i = 0; i < countArray; ++i) {
                    char charAtPos = buffer.charBuffer[i];
                    if (charAtPos >= '\u0001' && charAtPos < '\u007f') {
                        if (pos.pos >= buffer.byteBuffer.length) {
                            StringUtil.flushByteBuffer(out, buffer.byteBuffer, pos);
                        }
                        buffer.byteBuffer[pos.pos++] = (byte)charAtPos;
                        continue;
                    }
                    if (charAtPos >= '\u0800') {
                        if (pos.pos + 3 >= buffer.byteBuffer.length) {
                            StringUtil.flushByteBuffer(out, buffer.byteBuffer, pos);
                        }
                        buffer.byteBuffer[pos.pos++] = (byte)(0xE0 | charAtPos >> 12 & 0xF);
                        buffer.byteBuffer[pos.pos++] = (byte)(0x80 | charAtPos >> 6 & 0x3F);
                        buffer.byteBuffer[pos.pos++] = (byte)(0x80 | charAtPos >> 0 & 0x3F);
                        continue;
                    }
                    if (pos.pos + 2 >= buffer.byteBuffer.length) {
                        StringUtil.flushByteBuffer(out, buffer.byteBuffer, pos);
                    }
                    buffer.byteBuffer[pos.pos++] = (byte)(0xC0 | charAtPos >> 6 & 0x1F);
                    buffer.byteBuffer[pos.pos++] = (byte)(0x80 | charAtPos >> 0 & 0x3F);
                }
            }
            StringUtil.flushByteBuffer(out, buffer.byteBuffer, pos);
        }
    }

    private static StringUtilBuffer getThreadLocalBuffer() {
        StringUtilBuffer retValue = (StringUtilBuffer)currenBuffer.get();
        if (retValue == null) {
            retValue = new StringUtilBuffer();
            currenBuffer.set(retValue);
        }
        return retValue;
    }

    public static void saveString(DataOutput out, String str) throws IOException {
        if (optimizeStrings) {
            StringUtilBuffer buffer = StringUtil.getThreadLocalBuffer();
            StringUtil.saveString(out, str, buffer);
        } else {
            out.writeUTF(str);
        }
    }

    private static void pullDataToBuffer(DataInput input, StringUtilBuffer.Position pos, byte[] byteBuffer, long currentPosition, long size) throws IOException {
        pos.pos = 0;
        pos.size = (int)Math.min(size - currentPosition, (long)byteBuffer.length);
        input.readFully(byteBuffer, 0, (int)pos.size);
    }

    public static String readString(DataInput input, StringUtilBuffer buffer) throws IOException {
        if (!optimizeStrings) {
            return input.readUTF();
        }
        if (buffer == null) {
            buffer = StringUtil.getThreadLocalBuffer();
        }
        long size = 0L;
        boolean isLong = input.readBoolean();
        size = isLong ? input.readLong() : (long)input.readUnsignedShort();
        if (isDebug) {
            log.debug((Object)("Reading string with utfSize=" + size + " isLong=" + isLong));
        }
        long count = 0L;
        int charCount = 0;
        StringUtilBuffer.Position pos = buffer.position.reset();
        StringBuffer strbuffer = null;
        while (count < size) {
            if ((long)pos.pos >= pos.size) {
                if (isDebug) {
                    log.debug((Object)("readString::pulling data to Buffer at pos " + pos.pos + " size= " + pos.size));
                }
                StringUtil.pullDataToBuffer(input, pos, buffer.byteBuffer, count, size);
            }
            byte byte1 = buffer.byteBuffer[pos.pos++];
            ++count;
            if (byte1 > 0 && byte1 <= 127) {
                buffer.charBuffer[charCount++] = (char)byte1;
            } else {
                int c = byte1 & 0xFF;
                switch (c >> 4) {
                    case 12: 
                    case 13: {
                        if ((long)pos.pos >= pos.size) {
                            if (isDebug) {
                                log.debug((Object)("readString::pulling data to Buffer at pos test1 " + pos.pos + " size= " + pos.size));
                            }
                            StringUtil.pullDataToBuffer(input, pos, buffer.byteBuffer, count, size);
                        }
                        byte byte2 = buffer.byteBuffer[pos.pos++];
                        buffer.charBuffer[charCount++] = (char)((c & 0x1F) << 6 | byte2 & 0x3F);
                        ++count;
                        break;
                    }
                    case 14: {
                        if ((long)pos.pos >= pos.size) {
                            if (isDebug) {
                                log.debug((Object)("readString::pulling data to Buffer at pos test2 " + pos.pos + " size= " + pos.size));
                            }
                            StringUtil.pullDataToBuffer(input, pos, buffer.byteBuffer, count, size);
                        }
                        byte byte2 = buffer.byteBuffer[pos.pos++];
                        ++count;
                        if ((long)pos.pos >= pos.size) {
                            StringUtil.pullDataToBuffer(input, pos, buffer.byteBuffer, count, size);
                        }
                        byte byte3 = buffer.byteBuffer[pos.pos++];
                        buffer.charBuffer[charCount++] = (char)((c & 0xF) << 12 | (byte2 & 0x3F) << 6 | (byte3 & 0x3F) << 0);
                        ++count;
                    }
                }
            }
            if (charCount != buffer.charBuffer.length) continue;
            if (strbuffer == null) {
                strbuffer = new StringBuffer((int)size);
            }
            strbuffer.append(buffer.charBuffer);
            charCount = 0;
        }
        if (strbuffer != null) {
            strbuffer.append(buffer.charBuffer, 0, charCount);
            return strbuffer.toString();
        }
        return new String(buffer.charBuffer, 0, charCount);
    }

    public static long calculateUTFSize(String str, StringUtilBuffer stringBuffer) {
        long calculatedLen = 0L;
        int stringLength = str.length();
        if (stringLength > stringBuffer.charBuffer.length) {
            stringBuffer.resizeCharBuffer(stringLength);
        }
        str.getChars(0, stringLength, stringBuffer.charBuffer, 0);
        for (int i = 0; i < stringLength; ++i) {
            char c = stringBuffer.charBuffer[i];
            if (c >= '\u0001' && c < '\u007f') {
                ++calculatedLen;
                continue;
            }
            if (c >= '\u0800') {
                calculatedLen += 3L;
                continue;
            }
            calculatedLen += 2L;
        }
        return calculatedLen;
    }
}

