/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.objectmetamodel.safecloning;

import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.jboss.serial.objectmetamodel.safecloning.SafeClone;
import org.jboss.serial.util.ClassMetaConsts;

public class SafeCloningRepository
implements ClassMetaConsts {
    private static final Logger log = Logger.getLogger(SafeCloningRepository.class);
    private static final boolean isDebug = log.isDebugEnabled();
    private SafeClone safeClone;
    TObjectIntHashMap safeToReuse = new TObjectIntHashMap(identityHashStrategy);
    ArrayList reuse = new ArrayList();

    public SafeCloningRepository(SafeClone safeClone) {
        this.safeClone = safeClone;
    }

    public void clear() {
        this.reuse.clear();
        this.safeToReuse.clear();
    }

    public int storeSafe(Object obj) {
        if (this.safeClone.isSafeToReuse(obj)) {
            int description = this.safeToReuse.get(obj);
            if (description == 0) {
                this.safeToReuse.put(obj, this.safeToReuse.size() + 1);
                description = this.safeToReuse.size();
                if (isDebug) {
                    log.debug((Object)("storeSafe::Created a new storeSafe Reference=" + description + " obj=" + obj.getClass().getName()));
                }
                this.reuse.add(obj);
            }
            return description;
        }
        return 0;
    }

    public Object findReference(int reference) {
        Object retobject = this.reuse.get(reference - 1);
        if (isDebug && retobject != null) {
            log.debug((Object)("findReference::found reference " + reference + " on an object=" + retobject.getClass().getName()));
        }
        return retobject;
    }
}

