/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.serial.classmetamodel;

import java.io.IOException;
import org.jboss.serial.classmetamodel.ClassDescriptorStrategy;
import org.jboss.serial.classmetamodel.ClassMetaData;
import org.jboss.serial.classmetamodel.ClassResolver;
import org.jboss.serial.classmetamodel.StreamingClass;
import org.jboss.serial.objectmetamodel.ObjectsCache;

public class DefaultClassDescriptorStrategy
implements ClassDescriptorStrategy {
    public void writeClassDescription(Object obj, ClassMetaData metaData, ObjectsCache cache, int description) throws IOException {
        this.writeClassDescription(obj, metaData, cache, description, true);
    }

    public void writeClassDescription(Object obj, ClassMetaData metaData, ObjectsCache cache, int description, boolean writeClassDescription) throws IOException {
        ObjectsCache.JBossSeralizationOutputInterface outputParent = cache.getOutput();
        int cacheId = cache.findIdInCacheWrite(metaData, false);
        if (cacheId == 0) {
            cacheId = cache.putObjectInCacheWrite(metaData, false);
            outputParent.writeByte(51);
            outputParent.addObjectReference(cacheId);
            if (writeClassDescription) {
                outputParent.writeUTF(metaData.getClassName());
            }
            StreamingClass.saveStream(metaData, outputParent);
        } else {
            outputParent.writeByte(3);
            outputParent.addObjectReference(cacheId);
        }
    }

    public StreamingClass readClassDescription(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input, ClassResolver classResolver, String className) throws IOException {
        return this.readClassDescription(cache, input, classResolver, className, null);
    }

    public StreamingClass readClassDescription(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input, ClassResolver classResolver, String className, Class clazz) throws IOException {
        byte defClass = input.readByte();
        StreamingClass streamingClass = null;
        if (defClass == 51) {
            int referenceId = input.readObjectReference();
            if (className == null) {
                className = input.readUTF();
            }
            streamingClass = StreamingClass.readStream(input, classResolver, cache.getLoader(), className);
            cache.putObjectInCacheRead(referenceId, streamingClass);
        } else {
            int referenceId = input.readObjectReference();
            streamingClass = (StreamingClass)cache.findObjectInCacheRead(referenceId);
            if (streamingClass == null) {
                throw new IOException("Didn't find StreamingClass circular refernce id=" + referenceId);
            }
        }
        return streamingClass;
    }
}

