/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.config.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.config.parser.ModuleOptionParser;
import org.jboss.security.config.parser.StaxParserUtil;
import org.jboss.security.mapping.MappingType;
import org.jboss.security.mapping.config.MappingModuleEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingConfigParser {
    private String typeName = MappingType.ROLE.toString();

    public List<MappingModuleEntry> parse(XMLEventReader xmlEventReader) throws XMLStreamException {
        ArrayList<MappingModuleEntry> entries = new ArrayList<MappingModuleEntry>();
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = xmlEventReader.peek();
            StartElement peekedStartElement = (StartElement)xmlEvent;
            String peekedStartElementName = StaxParserUtil.getStartElementName(peekedStartElement);
            MappingModuleEntry entry = null;
            if (!"mapping-module".equals(peekedStartElementName)) break;
            entry = this.getEntry(xmlEventReader);
            entries.add(entry);
        }
        return entries;
    }

    private MappingModuleEntry getEntry(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent = xmlEventReader.nextEvent();
        HashMap<String, Object> options = new HashMap<String, Object>();
        String codeName = null;
        StartElement policyModuleElement = (StartElement)xmlEvent;
        Iterator<Attribute> attrs = policyModuleElement.getAttributes();
        while (attrs.hasNext()) {
            Attribute attribute = attrs.next();
            QName attQName = attribute.getName();
            String attributeValue = StaxParserUtil.getAttributeValue(attribute);
            if ("code".equals(attQName.getLocalPart())) {
                codeName = attributeValue;
                continue;
            }
            if (!"type".equals(attQName.getLocalPart())) continue;
            this.typeName = attributeValue;
        }
        ModuleOptionParser moParser = new ModuleOptionParser();
        options.putAll(moParser.parse(xmlEventReader));
        return new MappingModuleEntry(codeName, options, this.typeName);
    }
}

