/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve;

import Acme.Serve.Serve;
import Acme.Serve.ThrottleItem;
import Acme.Serve.ThrottledOutputStream;
import Acme.Utils;
import Acme.WildcardDictionary;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Deprecated
public class FileServlet
extends HttpServlet {
    static WildcardDictionary throttleTab = null;
    static final String[] DEFAULTINDEXPAGES = new String[]{"index.html", "index.htm", "default.htm", "default.html"};
    static final DecimalFormat lengthftm = new DecimalFormat("#");
    static final String BYTES_UNIT = "bytes";
    protected String charSet = Serve.UTF8;
    private static final boolean logenabled = false;
    private Method canExecute;
    private Method getFreeSpace;
    private boolean useCompression;

    public FileServlet() {
        try {
            this.canExecute = File.class.getMethod("canExecute", Utils.EMPTY_CLASSES);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.getFreeSpace = File.class.getMethod("getFreeSpace", Utils.EMPTY_CLASSES);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.useCompression = System.getProperty("tjws.fileservlet.usecompression") != null;
    }

    public FileServlet(String throttles, String charset) throws IOException {
        this();
        if (charset != null) {
            this.charSet = charset;
        }
        this.readThrottles(throttles);
    }

    private void readThrottles(String throttles) throws IOException {
        WildcardDictionary newThrottleTab = ThrottledOutputStream.parseThrottleFile(throttles);
        if (throttleTab == null) {
            throttleTab = newThrottleTab;
        } else {
            Enumeration keys = newThrottleTab.keys();
            Enumeration elements = newThrottleTab.elements();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object element = elements.nextElement();
                throttleTab.put(key, element);
            }
        }
    }

    public String getServletInfo() {
        return "File servlet similar to httpd";
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean headOnly;
        if (req.getMethod().equalsIgnoreCase("get") || req.getAttribute("javax.servlet.forward.request_uri") != null || req.getAttribute("javax.servlet.include.request_uri") != null) {
            headOnly = false;
        } else if (req.getMethod().equalsIgnoreCase("head")) {
            headOnly = true;
        } else {
            res.sendError(501);
            return;
        }
        req.setCharacterEncoding(Serve.UTF8);
        String path = Utils.canonicalizePath(req.getPathInfo());
        this.dispatchPathname(req, res, headOnly, path);
    }

    private void dispatchPathname(HttpServletRequest req, HttpServletResponse res, boolean headOnly, String path) throws IOException {
        this.log("path trans: " + req.getPathTranslated());
        String filename = req.getPathTranslated() != null ? req.getPathTranslated().replace('/', File.separatorChar) : "";
        File file = new File(filename);
        this.log("showing '" + filename + "' for path " + path);
        if (file.exists()) {
            if (!file.isDirectory()) {
                this.serveFile(req, res, headOnly, path, file);
            } else {
                this.log("showing dir " + file);
                if (!this.redirectDirectory(req, res, path, file)) {
                    this.showIdexFile(req, res, headOnly, path, filename);
                }
            }
        } else {
            res.sendError(404);
        }
    }

    private void showIdexFile(HttpServletRequest req, HttpServletResponse res, boolean headOnly, String path, String parent) throws IOException {
        this.log("showing index in directory " + parent);
        for (int i = 0; i < DEFAULTINDEXPAGES.length; ++i) {
            File indexFile = new File(parent, DEFAULTINDEXPAGES[i]);
            if (!indexFile.exists()) continue;
            this.serveFile(req, res, headOnly, path, indexFile);
            return;
        }
        this.serveDirectory(req, res, headOnly, path, new File(parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serveFile(HttpServletRequest req, HttpServletResponse res, boolean headOnly, String path, File file) throws IOException {
        block34: {
            String contentType;
            this.log("getting " + file);
            if (!file.canRead()) {
                res.sendError(403);
                return;
            }
            try {
                file.getCanonicalPath();
            }
            catch (Exception e) {
                res.sendError(403, "Forbidden, exception:" + e);
                return;
            }
            res.setStatus(200);
            long lastMod = file.lastModified();
            long ifModSince = req.getDateHeader("If-Modified-Since");
            if (ifModSince != -1L && ifModSince >= lastMod) {
                res.setStatus(304);
                headOnly = true;
            }
            if ((contentType = this.getServletContext().getMimeType(file.getName())) != null) {
                res.setContentType(contentType);
            }
            long flen = file.length();
            String range = req.getHeader("Range");
            long sr = 0L;
            long er = -1L;
            if (range != null) {
                int i;
                this.log("Range:" + range);
                if (range.regionMatches(true, 0, BYTES_UNIT, 0, BYTES_UNIT.length()) && (i = range.indexOf(45)) > 0) {
                    try {
                        sr = Long.parseLong(range.substring(BYTES_UNIT.length() + 1, i));
                        if (sr < 0L) {
                            throw new NumberFormatException("Invalid start range value:" + sr);
                        }
                        try {
                            er = Long.parseLong(range.substring(i + 1));
                        }
                        catch (NumberFormatException nfe) {
                            er = flen - 1L;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.log("range values " + sr + " to " + er);
            }
            long clen = er < 0L ? flen : er - sr + 1L;
            res.setDateHeader("Last-modified", lastMod);
            if (er > 0L) {
                if (sr > er || er >= flen) {
                    res.setHeader("Content-Range", "bytes */" + flen);
                    res.setStatus(416);
                    return;
                }
                res.setStatus(206);
                res.setHeader("Content-Range", "bytes " + sr + '-' + er + '/' + flen);
                this.log("content-range:bytes " + sr + '-' + er + '/' + flen);
            }
            boolean doCompress = false;
            if (this.useCompression && contentType != null && contentType.startsWith("text") && Utils.isGzipAccepted(req.getHeader("Accept-Encoding")) > 0.0f) {
                res.setHeader("Content-Encoding", "gzip");
                doCompress = true;
            }
            if (!doCompress || headOnly) {
                if (clen < Integer.MAX_VALUE) {
                    res.setContentLength((int)clen);
                } else {
                    res.setHeader("Content-Length", Long.toString(clen));
                }
            }
            FilterOutputStream out = null;
            InputStream in = null;
            try {
                ThrottleItem throttleItem;
                if (headOnly) break block34;
                FilterOutputStream filterOutputStream = out = doCompress ? new GZIPOutputStream((OutputStream)res.getOutputStream()) : res.getOutputStream();
                if (throttleTab != null && (throttleItem = (ThrottleItem)throttleTab.get(path)) != null) {
                    out = new ThrottledOutputStream(out, throttleItem.getMaxBps());
                }
                in = new FileInputStream(file);
                while (sr > 0L) {
                    long sl = in.skip(sr);
                    if (sl > 0L) {
                        sr -= sl;
                        continue;
                    }
                    res.sendError(409, "Conflict");
                    return;
                }
                this.copyStream(in, out, clen);
                if (doCompress) {
                    ((GZIPOutputStream)out).finish();
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                }
            }
        }
    }

    public void copyStream(InputStream in, OutputStream out, long len) throws IOException {
        Utils.copyStream(in, out, len);
    }

    private void serveDirectory(HttpServletRequest req, HttpServletResponse res, boolean headOnly, String path, File file) throws IOException {
        this.log("indexing " + file);
        if (!file.canRead()) {
            res.sendError(403);
            return;
        }
        res.setStatus(200);
        res.setContentType("text/html;charset=" + this.charSet);
        ServletOutputStream out = res.getOutputStream();
        if (!headOnly) {
            Object[] names = file.list();
            if (names == null) {
                res.sendError(403, "Can't access " + req.getRequestURI());
                return;
            }
            PrintStream p = new PrintStream((OutputStream)new BufferedOutputStream((OutputStream)out), false, this.charSet);
            p.println("<HTML><HEAD>");
            p.println("<META HTTP-EQUIV=\"Content-Type\" CONTENT=\"text/html; charset=" + this.charSet + "\">");
            p.println("<TITLE>Index of " + path + "</TITLE>");
            p.println("</HEAD><BODY BGCOLOR=\"#D1E9FE\"");
            p.println("><H2>Index of " + path + "</H2>");
            p.println("<PRE>");
            p.println("mode         bytes  last-changed    name");
            p.println("<HR>");
            Arrays.sort(names);
            long total = 0L;
            for (int i = 0; i < names.length; ++i) {
                File aFile = new File(file, (String)names[i]);
                String aFileType = aFile.isDirectory() ? "d" : (aFile.isFile() ? "-" : "?");
                String aFileRead = aFile.canRead() ? "r" : "-";
                String aFileWrite = aFile.canWrite() ? "w" : "-";
                String aFileExe = "-";
                if (this.canExecute != null) {
                    try {
                        if (((Boolean)this.canExecute.invoke((Object)aFile, Utils.EMPTY_OBJECTS)).booleanValue()) {
                            aFileExe = "x";
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                }
                long aFileLen = aFile.length();
                String aFileSize = lengthftm.format(aFileLen);
                total += (aFileLen + 1023L) / 1024L;
                while (aFileSize.length() < 12) {
                    aFileSize = " " + aFileSize;
                }
                String aFileDate = Utils.lsDateStr(new Date(aFile.lastModified()));
                while (aFileDate.length() < 14) {
                    aFileDate = aFileDate + " ";
                }
                String aFileDirsuf = aFile.isDirectory() ? "/" : "";
                String aFileSuf = aFile.isDirectory() ? "/" : "";
                p.println(aFileType + aFileRead + aFileWrite + aFileExe + "  " + aFileSize + "  " + aFileDate + "  " + "<A HREF=\"" + URLEncoder.encode((String)names[i], this.charSet) + aFileDirsuf + "\">" + (String)names[i] + aFileSuf + "</A>");
            }
            if (total != 0L) {
                total += 3L;
            }
            p.println("total " + total);
            p.println("</PRE>");
            p.println("<HR>");
            p.print("<ADDRESS><A HREF=\"http://tjws.sourceforge.net\">D. Rogatkin's TJWS based on Acme.Serve Version 1.70, $Revision: 1.194 $</A></ADDRESS>");
            p.println("</BODY></HTML>");
            p.flush();
        }
        out.close();
    }

    private boolean redirectDirectory(HttpServletRequest req, HttpServletResponse res, String path, File file) throws IOException {
        int pl = path.length();
        if (pl > 0 && path.charAt(pl - 1) != '/') {
            int sp = path.lastIndexOf(47);
            path = sp < 0 ? path + '/' : path.substring(sp + 1) + '/';
            this.log("redirecting dir " + path);
            res.sendRedirect(path);
            return true;
        }
        return false;
    }

    public void log(String msg) {
    }
}

