/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.idm.model.data;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.openssl.PEMWriter;
import org.jboss.resteasy.security.PemUtils;

public class Realm
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected long tokenLifespan = 86400L;
    protected long accessCodeLifespan = 300L;
    protected boolean enabled;
    protected boolean sslNotRequired;
    protected boolean cookieLoginAllowed;
    protected String publicKeyPem;
    protected String privateKeyPem;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isSslNotRequired() {
        return this.sslNotRequired;
    }

    public void setSslNotRequired(boolean sslNotRequired) {
        this.sslNotRequired = sslNotRequired;
    }

    public boolean isCookieLoginAllowed() {
        return this.cookieLoginAllowed;
    }

    public void setCookieLoginAllowed(boolean cookieLoginAllowed) {
        this.cookieLoginAllowed = cookieLoginAllowed;
    }

    public long getTokenLifespan() {
        return this.tokenLifespan;
    }

    public void setTokenLifespan(long tokenLifespan) {
        this.tokenLifespan = tokenLifespan;
    }

    public long getAccessCodeLifespan() {
        return this.accessCodeLifespan;
    }

    public void setAccessCodeLifespan(long accessCodeLifespan) {
        this.accessCodeLifespan = accessCodeLifespan;
    }

    public String getPublicKeyPem() {
        return this.publicKeyPem;
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.publicKeyPem = publicKeyPem;
        this.publicKey = null;
    }

    public String getPrivateKeyPem() {
        return this.privateKeyPem;
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.privateKeyPem = privateKeyPem;
        this.privateKey = null;
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        if (this.publicKeyPem != null) {
            try {
                this.publicKey = PemUtils.decodePublicKey((String)this.publicKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)publicKey);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = writer.toString();
        this.publicKeyPem = PemUtils.removeBeginEnd((String)s);
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        if (this.privateKeyPem != null) {
            try {
                this.privateKey = PemUtils.decodePrivateKey((String)this.privateKeyPem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)privateKey);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = writer.toString();
        this.privateKeyPem = PemUtils.removeBeginEnd((String)s);
    }
}

