/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.as7;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.login.LoginException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Providers;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.bouncycastle.openssl.PEMWriter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.JavaType;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.jose.jws.JWSBuilder;
import org.jboss.resteasy.jose.jws.JWSInput;
import org.jboss.resteasy.jose.jws.crypto.RSAProvider;
import org.jboss.resteasy.jwt.JsonSerialization;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.security.PemUtils;
import org.jboss.resteasy.skeleton.key.EnvUtil;
import org.jboss.resteasy.skeleton.key.ResourceMetadata;
import org.jboss.resteasy.skeleton.key.SkeletonKeySession;
import org.jboss.resteasy.skeleton.key.as7.CatalinaBearerTokenAuthenticator;
import org.jboss.resteasy.skeleton.key.as7.UserSessionManagement;
import org.jboss.resteasy.skeleton.key.as7.config.AuthServerConfig;
import org.jboss.resteasy.skeleton.key.as7.config.ManagedResourceConfig;
import org.jboss.resteasy.skeleton.key.representations.AccessTokenResponse;
import org.jboss.resteasy.skeleton.key.representations.SkeletonKeyToken;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.util.BasicAuthHelper;

public class OAuthAuthenticationServerValve
extends FormAuthenticator
implements LifecycleListener {
    protected ConcurrentHashMap<String, AccessCode> accessCodeMap = new ConcurrentHashMap();
    private static final Logger log = Logger.getLogger(OAuthAuthenticationServerValve.class);
    private static AtomicLong counter = new AtomicLong(1L);
    protected AuthServerConfig skeletonKeyConfig;
    protected PrivateKey realmPrivateKey;
    protected PublicKey realmPublicKey;
    protected String realmPublicKeyPem;
    protected ResteasyProviderFactory providers;
    protected ResourceMetadata resourceMetadata;
    protected UserSessionManagement userSessionManagement = new UserSessionManagement();
    protected ObjectMapper mapper;
    protected ObjectWriter accessTokenResponseWriter;
    protected ObjectWriter mapWriter;

    private static String generateId() {
        return counter.getAndIncrement() + "." + UUID.randomUUID().toString();
    }

    private static KeyStore loadKeyStore(String filename, String password) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        File truststoreFile = new File(filename);
        FileInputStream trustStream = new FileInputStream(truststoreFile);
        trustStore.load(trustStream, password.toCharArray());
        trustStream.close();
        return trustStore;
    }

    public void start() throws LifecycleException {
        super.start();
        StandardContext standardContext = (StandardContext)this.context;
        standardContext.addLifecycleListener((LifecycleListener)this);
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        this.mapper = new ObjectMapper();
        this.mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        this.accessTokenResponseWriter = this.mapper.writerWithType(AccessTokenResponse.class);
        this.mapWriter = this.mapper.writerWithType((JavaType)this.mapper.getTypeFactory().constructMapType(Map.class, String.class, String.class));
        InputStream is = null;
        String path = this.context.getServletContext().getInitParameter("skeleton.key.config.file");
        if (path == null) {
            is = this.context.getServletContext().getResourceAsStream("/WEB-INF/resteasy-oauth.json");
        } else {
            try {
                is = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.skeletonKeyConfig = (AuthServerConfig)this.mapper.readValue(is, AuthServerConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.skeletonKeyConfig.getLoginRole() == null) {
            throw new RuntimeException("You must define the login-role in your config file");
        }
        if (this.skeletonKeyConfig.getClientRole() == null) {
            throw new RuntimeException("You must define the oauth-client-role in your config file");
        }
        if (this.skeletonKeyConfig.getRealmPrivateKey() != null) {
            try {
                this.realmPrivateKey = PemUtils.decodePrivateKey((String)this.skeletonKeyConfig.getRealmPrivateKey());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.skeletonKeyConfig.getRealmPublicKey() != null) {
            try {
                this.realmPublicKey = PemUtils.decodePublicKey((String)this.skeletonKeyConfig.getRealmPublicKey());
                this.realmPublicKeyPem = this.skeletonKeyConfig.getRealmPublicKey();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.skeletonKeyConfig.getRealmKeyStore() != null) {
            if (this.skeletonKeyConfig.getRealmKeyAlias() == null) {
                throw new RuntimeException("Must define realm-key-alias");
            }
            String keystorePath = EnvUtil.replace((String)this.skeletonKeyConfig.getRealmKeyStore());
            try {
                KeyStore ks = OAuthAuthenticationServerValve.loadKeyStore(keystorePath, this.skeletonKeyConfig.getRealmKeystorePassword());
                if (this.realmPrivateKey == null) {
                    this.realmPrivateKey = (PrivateKey)ks.getKey(this.skeletonKeyConfig.getRealmKeyAlias(), this.skeletonKeyConfig.getRealmPrivateKeyPassword().toCharArray());
                }
                if (this.realmPublicKey == null) {
                    Certificate cert = ks.getCertificate(this.skeletonKeyConfig.getRealmKeyAlias());
                    this.realmPublicKey = cert.getPublicKey();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.realmPublicKey == null) {
            throw new RuntimeException("You have not declared a keystore or public key");
        }
        if (this.realmPrivateKey == null) {
            throw new RuntimeException("You have not declared a keystore or private key");
        }
        if (this.realmPublicKeyPem == null) {
            StringWriter sw = new StringWriter();
            PEMWriter writer = new PEMWriter((Writer)sw);
            try {
                writer.writeObject((Object)this.realmPublicKey);
                writer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.realmPublicKeyPem = sw.toString();
            this.realmPublicKeyPem = PemUtils.removeBeginEnd((String)this.realmPublicKeyPem);
        }
        this.providers = new ResteasyProviderFactory();
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(OAuthAuthenticationServerValve.class.getClassLoader());
        try {
            ResteasyProviderFactory.getInstance();
            RegisterBuiltin.register((ResteasyProviderFactory)this.providers);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        this.resourceMetadata = new ResourceMetadata();
        this.resourceMetadata.setRealm(this.skeletonKeyConfig.getRealm());
        this.resourceMetadata.setRealmKey(this.realmPublicKey);
        String truststore = this.skeletonKeyConfig.getTruststore();
        if (truststore != null) {
            truststore = EnvUtil.replace((String)truststore);
            String truststorePassword = this.skeletonKeyConfig.getTruststorePassword();
            KeyStore trust = null;
            try {
                trust = OAuthAuthenticationServerValve.loadKeyStore(truststore, truststorePassword);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load truststore", e);
            }
            this.resourceMetadata.setTruststore(trust);
        }
        String clientKeystore = this.skeletonKeyConfig.getClientKeystore();
        String clientKeyPassword = null;
        if (clientKeystore != null) {
            clientKeystore = EnvUtil.replace((String)clientKeystore);
            String clientKeystorePassword = this.skeletonKeyConfig.getClientKeystorePassword();
            KeyStore serverKS = null;
            try {
                serverKS = OAuthAuthenticationServerValve.loadKeyStore(clientKeystore, clientKeystorePassword);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load keystore", e);
            }
            this.resourceMetadata.setClientKeystore(serverKS);
            clientKeyPassword = this.skeletonKeyConfig.getClientKeyPassword();
            this.resourceMetadata.setClientKeyPassword(clientKeyPassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        try {
            SkeletonKeySession skSession;
            String contextPath = request.getContextPath();
            String requestURI = request.getDecodedRequestURI();
            log.info((Object)("--- invoke: " + requestURI));
            if (request.getMethod().equalsIgnoreCase("GET") && this.context.getLoginConfig().getLoginPage().equals(request.getRequestPathMB().toString())) {
                if (this.handleLoginPage(request, response)) {
                    return;
                }
            } else {
                if (request.getMethod().equalsIgnoreCase("GET") && requestURI.endsWith("j_oauth_logout")) {
                    this.logoutCurrentUser(request, (HttpServletResponse)response);
                    return;
                }
                if (request.getMethod().equalsIgnoreCase("POST") && requestURI.endsWith("j_oauth_admin_forced_logout")) {
                    this.adminLogout(request, (HttpServletResponse)response);
                    return;
                }
                if (request.getMethod().equalsIgnoreCase("POST") && requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check") && request.getParameter("client_id") != null) {
                    this.handleOAuth(request, response);
                    return;
                }
                if (request.getMethod().equalsIgnoreCase("POST") && requestURI.endsWith("j_oauth_token_grant")) {
                    this.tokenGrant(request, response);
                    return;
                }
                if (request.getMethod().equalsIgnoreCase("POST") && requestURI.startsWith(contextPath) && requestURI.endsWith("j_oauth_resolve_access_code")) {
                    this.resolveAccessCode(request, response);
                    return;
                }
                if (request.getMethod().equalsIgnoreCase("GET") && requestURI.startsWith(contextPath) && requestURI.endsWith("j_oauth_realm_info.html")) {
                    this.publishRealmInfoHtml(request, (HttpServletResponse)response);
                    return;
                }
            }
            if (!this.skeletonKeyConfig.isCancelPropagation() && request.getAttribute(SkeletonKeySession.class.getName()) == null && request.getSessionInternal() != null && (skSession = (SkeletonKeySession)request.getSessionInternal().getNote(SkeletonKeySession.class.getName())) != null) {
                request.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
                ResteasyProviderFactory.pushContext(SkeletonKeySession.class, (Object)skSession);
            }
            request.setAttribute("OAUTH_FORM_ACTION", (Object)"j_security_check");
            super.invoke(request, response);
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
    }

    protected boolean handleLoginPage(Request request, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        String client_id = request.getParameter("client_id");
        if (client_id == null) {
            return false;
        }
        String redirect_uri = request.getParameter("redirect_uri");
        String state = request.getParameter("state");
        if (redirect_uri == null) {
            response.sendError(400, "No oauth redirect query parameter set");
            return true;
        }
        if (!this.skeletonKeyConfig.isSsoDisabled() && request.getSessionInternal() != null && request.getSessionInternal().getPrincipal() != null && request.getParameter("login") != null) {
            log.info((Object)"We're ALREADY LOGGED IN!!!");
            GenericPrincipal gp = (GenericPrincipal)request.getSessionInternal().getPrincipal();
            this.redirectAccessCode(true, response, redirect_uri, client_id, state, gp);
        } else {
            UriBuilder builder = UriBuilder.fromUri((String)"j_security_check").queryParam("redirect_uri", new Object[]{redirect_uri}).queryParam("client_id", new Object[]{client_id});
            if (state != null) {
                builder.queryParam("state", new Object[]{state});
            }
            String loginAction = builder.build(new Object[0]).toString();
            request.setAttribute("OAUTH_FORM_ACTION", (Object)loginAction);
            this.getNext().invoke(request, response);
        }
        return true;
    }

    protected GenericPrincipal checkLoggedIn(Request request, HttpServletResponse response) {
        if (request.getPrincipal() != null) {
            return (GenericPrincipal)request.getPrincipal();
        }
        if (request.getSessionInternal() != null && request.getSessionInternal().getPrincipal() != null) {
            return (GenericPrincipal)request.getSessionInternal().getPrincipal();
        }
        return null;
    }

    protected void adminLogout(Request request, HttpServletResponse response) throws IOException {
        log.info((Object)"<< adminLogout");
        GenericPrincipal gp = this.checkLoggedIn(request, response);
        if (gp == null) {
            if (this.bearer(request, response, false)) {
                gp = (GenericPrincipal)request.getPrincipal();
            } else {
                response.sendError(403);
                return;
            }
        }
        if (!gp.hasRole(this.skeletonKeyConfig.getAdminRole())) {
            response.sendError(403);
            return;
        }
        String logoutUser = request.getParameter("user");
        if (logoutUser != null) {
            this.userSessionManagement.logout(logoutUser);
            this.logoutResources(logoutUser, gp.getName());
        } else {
            this.userSessionManagement.logoutAllBut(gp.getName());
            this.logoutResources(null, gp.getName());
        }
        String forwardTo = request.getParameter("forward");
        if (forwardTo == null) {
            response.setStatus(204);
            return;
        }
        RequestDispatcher disp = this.context.getServletContext().getRequestDispatcher(forwardTo);
        try {
            disp.forward((ServletRequest)request.getRequest(), (ServletResponse)response);
        }
        catch (Throwable t) {
            request.setAttribute("javax.servlet.error.exception", (Object)t);
            response.sendError(500, "failed to forward");
        }
    }

    protected void logoutCurrentUser(Request request, HttpServletResponse response) throws IOException {
        String username;
        if (request.getSessionInternal() == null || request.getSessionInternal().getPrincipal() == null) {
            this.redirectToWelcomePage(request, response);
            return;
        }
        GenericPrincipal principal = (GenericPrincipal)request.getSessionInternal().getPrincipal();
        String admin = username = principal.getName();
        this.userSessionManagement.logout(username);
        request.setUserPrincipal(null);
        request.setAuthType(null);
        this.logoutResources(username, admin);
        this.redirectToWelcomePage(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logoutResources(String username, String admin) {
        if (this.skeletonKeyConfig.getResources().size() != 0) {
            SkeletonKeyToken token = new SkeletonKeyToken();
            token.id(OAuthAuthenticationServerValve.generateId());
            token.principal(admin);
            token.audience(this.skeletonKeyConfig.getRealm());
            SkeletonKeyToken.Access realmAccess = new SkeletonKeyToken.Access();
            realmAccess.addRole(this.skeletonKeyConfig.getAdminRole());
            token.setRealmAccess(realmAccess);
            String tokenString = this.buildTokenString(this.realmPrivateKey, token);
            ResteasyClient client = new ResteasyClientBuilder().providerFactory(this.providers).hostnameVerification(ResteasyClientBuilder.HostnameVerificationPolicy.ANY).trustStore(this.resourceMetadata.getTruststore()).keyStore(this.resourceMetadata.getClientKeystore(), this.resourceMetadata.getClientKeyPassword()).build();
            try {
                for (String resource : this.skeletonKeyConfig.getResources()) {
                    try {
                        Response response;
                        log.info((Object)("logging out: " + resource));
                        ResteasyWebTarget target = client.target(resource).path("j_oauth_remote_logout");
                        if (username != null) {
                            target = target.queryParam("user", new Object[]{username});
                        }
                        if ((response = target.request().header("Authorization", (Object)("Bearer " + tokenString)).put(null)).getStatus() != 204) {
                            log.error((Object)"Failed to log out");
                        }
                        response.close();
                    }
                    catch (Exception ignored) {
                        log.error((Object)"Failed to log out", (Throwable)ignored);
                    }
                }
            }
            finally {
                client.close();
            }
        }
    }

    protected void redirectToWelcomePage(Request request, HttpServletResponse response) throws IOException {
        ResteasyUriInfo uriInfo = ServletUtil.extractUriInfo((HttpServletRequest)request, null);
        String[] welcomes = this.context.findWelcomeFiles();
        if (welcomes.length > 0) {
            UriBuilder welcome = uriInfo.getBaseUriBuilder().path(welcomes[0]);
            response.sendRedirect(welcome.toTemplate());
        } else {
            response.setStatus(204);
        }
    }

    protected void publishRealmInfoHtml(Request request, HttpServletResponse response) throws IOException {
        ManagedResourceConfig rep = this.getRealmRepresentation(request);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        mapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT});
        StringBuffer html = new StringBuffer();
        html.append("<html><body bgcolor=\"#CED8F6\">");
        html.append("<h1>Realm: ").append(rep.getRealm()).append("</h1>");
        ManagedResourceConfig bearer = new ManagedResourceConfig();
        bearer.setRealm(rep.getRealm());
        bearer.setRealmKey(rep.getRealmKey());
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)bearer);
        String json = writer.toString();
        html.append("<h3>BearerTokenAuthValve Json Config</h3>");
        html.append("<form><textarea rows=\"7\" cols=\"80\">").append(json).append("</textarea></form>");
        html.append("<br>");
        writer = new StringWriter();
        rep.getClientCredentials().put("password", "REQUIRED");
        rep.setClientId("REQUIRED");
        rep.setTruststore("REQUIRED");
        rep.setTruststorePassword("REQUIRED");
        mapper.writeValue((Writer)writer, (Object)rep);
        json = writer.toString();
        html.append("<h3>OAuthManagedResourceValve Json Config</h3>");
        html.append("<form><textarea rows=\"20\" cols=\"80\">").append(json).append("</textarea></form>");
        html.append("</body></html>");
        response.setStatus(200);
        response.setContentType("text/html");
        response.getOutputStream().println(html.toString());
        response.getOutputStream().flush();
    }

    protected ManagedResourceConfig getRealmRepresentation(Request request) {
        ManagedResourceConfig rep = new ManagedResourceConfig();
        ResteasyUriInfo uriInfo = ServletUtil.extractUriInfo((HttpServletRequest)request, null);
        UriBuilder authUrl = uriInfo.getBaseUriBuilder().path(this.context.getLoginConfig().getLoginPage());
        UriBuilder codeUrl = uriInfo.getBaseUriBuilder().path("j_oauth_resolve_access_code");
        rep.setRealm(this.skeletonKeyConfig.getRealm());
        rep.setRealmKey(this.realmPublicKeyPem);
        rep.setAuthUrl(authUrl.toTemplate());
        rep.setCodeUrl(codeUrl.toTemplate());
        rep.setAdminRole(this.skeletonKeyConfig.getAdminRole());
        return rep;
    }

    public boolean bearer(Request request, HttpServletResponse response, boolean propagate) throws IOException {
        if (request.getHeader("Authorization") != null) {
            CatalinaBearerTokenAuthenticator bearer = new CatalinaBearerTokenAuthenticator(this.resourceMetadata, true, false);
            try {
                if (bearer.login(request, response)) {
                    return true;
                }
            }
            catch (LoginException e) {
                // empty catch block
            }
        }
        return false;
    }

    protected void register(Request request, HttpServletResponse response, Principal principal, String authType, String username, String password) {
        GenericPrincipal gp;
        super.register(request, response, principal, authType, username, password);
        log.info((Object)("authenticate userSessionManage.login(): " + principal.getName()));
        this.userSessionManagement.login(request.getSessionInternal(), principal.getName());
        if (!this.skeletonKeyConfig.isCancelPropagation() && (gp = (GenericPrincipal)request.getPrincipal()) != null) {
            SkeletonKeyToken token = this.buildToken(gp);
            String stringToken = this.buildTokenString(this.realmPrivateKey, token);
            SkeletonKeySession skSession = new SkeletonKeySession(stringToken, this.resourceMetadata);
            request.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
            ResteasyProviderFactory.pushContext(SkeletonKeySession.class, (Object)skSession);
            request.getSessionInternal(true).setNote(SkeletonKeySession.class.getName(), (Object)skSession);
        }
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        if (this.bearer(request, response, true)) {
            return true;
        }
        return super.authenticate(request, response, config);
    }

    protected void resolveAccessCode(Request request, org.apache.catalina.connector.Response response) throws IOException {
        if (!request.isSecure()) {
            response.sendError(400);
            return;
        }
        String code = request.getParameter("code");
        JWSInput input = new JWSInput(code, (Providers)this.providers);
        boolean verifiedCode = false;
        try {
            verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)this.realmPublicKey);
        }
        catch (Exception ignored) {
            log.debug((Object)"Failed to verify signature", (Throwable)ignored);
        }
        if (!verifiedCode) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Unable to verify code signature");
            response.sendError(400);
            response.setContentType("application/json");
            this.mapWriter.writeValue((OutputStream)response.getOutputStream(), res);
            response.getOutputStream().flush();
            return;
        }
        String key = (String)input.readContent(String.class);
        AccessCode accessCode = this.accessCodeMap.remove(key);
        String redirect = request.getParameter("redirect_uri");
        GenericPrincipal gp = this.basicAuth(request, response);
        if (gp == null) {
            log.error((Object)"Failed to authenticate client_id");
            return;
        }
        if (accessCode == null) {
            log.error((Object)("No access code: " + code));
            response.sendError(400);
            return;
        }
        if (accessCode.isExpired()) {
            log.error((Object)"Access code expired");
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code is expired");
            response.setStatus(400);
            response.setContentType("application/json");
            this.mapWriter.writeValue((OutputStream)response.getOutputStream(), res);
            response.getOutputStream().flush();
            return;
        }
        if (!accessCode.getToken().isActive()) {
            log.error((Object)"token not active");
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Token expired");
            response.setStatus(400);
            response.setContentType("application/json");
            this.mapWriter.writeValue((OutputStream)response.getOutputStream(), res);
            response.getOutputStream().flush();
            return;
        }
        if (!gp.getName().equals(accessCode.getClient())) {
            log.error((Object)"not equal client");
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Auth error");
            response.setStatus(400);
            response.setContentType("application/json");
            this.mapWriter.writeValue((OutputStream)response.getOutputStream(), res);
            response.getOutputStream().flush();
            return;
        }
        if (!accessCode.getRedirect().equals(redirect)) {
            log.error((Object)"not equal redirect");
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Auth error");
            response.setStatus(400);
            response.setContentType("application/json");
            this.mapWriter.writeValue((OutputStream)response.getOutputStream(), res);
            response.getOutputStream().flush();
            return;
        }
        if (accessCode.isSso() && !gp.hasRole(this.skeletonKeyConfig.getLoginRole())) {
            log.error((Object)"does not have login permission");
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Auth error");
            response.setStatus(400);
            response.setContentType("application/json");
            this.mapWriter.writeValue((OutputStream)response.getOutputStream(), res);
            response.getOutputStream().flush();
            return;
        }
        if (!gp.hasRole(this.skeletonKeyConfig.getClientRole()) && !gp.hasRole(this.skeletonKeyConfig.getLoginRole())) {
            log.error((Object)"does not have login or client role permission for access token request");
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Auth error");
            response.setStatus(400);
            response.setContentType("application/json");
            this.mapWriter.writeValue((OutputStream)response.getOutputStream(), res);
            response.getOutputStream().flush();
            return;
        }
        String wildcard = this.skeletonKeyConfig.getWildcardRole() == null ? "*" : this.skeletonKeyConfig.getWildcardRole();
        Set codeRoles = accessCode.getToken().getRealmAccess().getRoles();
        if (codeRoles != null && (codeRoles.contains(this.skeletonKeyConfig.getClientRole()) || codeRoles.contains(this.skeletonKeyConfig.getLoginRole()))) {
            HashSet<String> newRoles = new HashSet<String>();
            if (codeRoles.contains(this.skeletonKeyConfig.getClientRole())) {
                newRoles.add(this.skeletonKeyConfig.getClientRole());
            }
            if (codeRoles.contains(this.skeletonKeyConfig.getLoginRole())) {
                newRoles.add(this.skeletonKeyConfig.getLoginRole());
            }
            if (codeRoles.contains(wildcard)) {
                newRoles.add(wildcard);
            }
            codeRoles.clear();
            codeRoles.addAll(newRoles);
        }
        if (codeRoles != null && !gp.hasRole(wildcard) && !gp.hasRole(this.skeletonKeyConfig.getLoginRole())) {
            HashSet<String> clientAllowed = new HashSet<String>();
            for (String role : gp.getRoles()) {
                clientAllowed.add(role);
            }
            HashSet newRoles = new HashSet();
            newRoles.addAll(codeRoles);
            for (String role : newRoles) {
                if (clientAllowed.contains(role)) continue;
                codeRoles.remove(role);
            }
        }
        AccessTokenResponse res = this.accessTokenResponse(this.realmPrivateKey, accessCode.getToken());
        response.setStatus(200);
        response.setContentType("application/json");
        this.accessTokenResponseWriter.writeValue((OutputStream)response.getOutputStream(), (Object)res);
        response.getOutputStream().flush();
    }

    protected AccessTokenResponse accessTokenResponse(PrivateKey privateKey, SkeletonKeyToken token) {
        String encodedToken = this.buildTokenString(privateKey, token);
        AccessTokenResponse res = new AccessTokenResponse();
        res.setToken(encodedToken);
        res.setTokenType("bearer");
        if (token.getExpiration() != 0L) {
            long time = token.getExpiration() - System.currentTimeMillis() / 1000L;
            res.setExpiresIn(time);
        }
        return res;
    }

    protected String buildTokenString(PrivateKey privateKey, SkeletonKeyToken token) {
        byte[] tokenBytes = null;
        try {
            tokenBytes = JsonSerialization.toByteArray((Object)token, (boolean)false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new JWSBuilder().content(tokenBytes).rsa256(privateKey);
    }

    protected void handleOAuth(Request request, org.apache.catalina.connector.Response response) throws IOException {
        log.info((Object)"<--- Begin oauthAuthenticate");
        String redirect_uri = request.getParameter("redirect_uri");
        String client_id = request.getParameter("client_id");
        String state = request.getParameter("state");
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        Principal principal = this.context.getRealm().authenticate(username, password);
        if (principal == null) {
            UriBuilder builder = UriBuilder.fromUri((String)redirect_uri).queryParam("error", new Object[]{"unauthorized_client"});
            if (state != null) {
                builder.queryParam("state", new Object[]{state});
            }
            response.sendRedirect(builder.toTemplate());
            return;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        this.register(request, (HttpServletResponse)response, principal, "FORM", username, password);
        this.userSessionManagement.login(request.getSessionInternal(), username);
        this.redirectAccessCode(false, response, redirect_uri, client_id, state, gp);
    }

    protected void tokenGrant(Request request, org.apache.catalina.connector.Response response) throws IOException {
        if (!request.isSecure()) {
            response.sendError(400);
            return;
        }
        GenericPrincipal gp = this.basicAuth(request, response);
        if (gp == null) {
            return;
        }
        SkeletonKeyToken token = this.buildToken(gp);
        AccessTokenResponse res = this.accessTokenResponse(this.realmPrivateKey, token);
        response.setStatus(200);
        response.setContentType("application/json");
        this.accessTokenResponseWriter.writeValue((OutputStream)response.getOutputStream(), (Object)res);
        response.getOutputStream().flush();
    }

    protected GenericPrincipal basicAuth(Request request, org.apache.catalina.connector.Response response) throws IOException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            this.basicAuthError(response);
            return null;
        }
        String[] creds = BasicAuthHelper.parseHeader((String)authHeader);
        if (creds == null) {
            this.basicAuthError(response);
            return null;
        }
        String username = creds[0];
        String password = creds[1];
        GenericPrincipal gp = (GenericPrincipal)this.context.getRealm().authenticate(username, password);
        if (gp == null) {
            this.basicAuthError(response);
            return null;
        }
        return gp;
    }

    protected void basicAuthError(org.apache.catalina.connector.Response response) throws IOException {
        response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.context.getLoginConfig().getRealmName() + "\"");
        response.sendError(401);
    }

    protected void redirectAccessCode(boolean sso, org.apache.catalina.connector.Response response, String redirect_uri, String client_id, String state, GenericPrincipal gp) throws IOException {
        SkeletonKeyToken token = this.buildToken(gp);
        AccessCode code = new AccessCode();
        code.setToken(token);
        code.setClient(client_id);
        code.setSso(sso);
        code.setRedirect(redirect_uri);
        int expiration = this.skeletonKeyConfig.getAccessCodeLifetime() == 0 ? 300 : this.skeletonKeyConfig.getAccessCodeLifetime();
        code.setExpiration(System.currentTimeMillis() / 1000L + (long)expiration);
        this.accessCodeMap.put(code.getId(), code);
        log.info((Object)"--- sign access code");
        String accessCode = null;
        try {
            accessCode = new JWSBuilder().content(code.getId().getBytes("UTF-8")).rsa256(this.realmPrivateKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        log.info((Object)"--- build redirect");
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect_uri).queryParam("code", new Object[]{accessCode});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        response.sendRedirect(redirectUri.toTemplate());
        log.info((Object)"<--- end oauthAuthenticate");
    }

    protected SkeletonKeyToken buildToken(GenericPrincipal gp) {
        int expiration;
        SkeletonKeyToken token = new SkeletonKeyToken();
        token.id(OAuthAuthenticationServerValve.generateId());
        token.principal(gp.getName());
        token.audience(this.skeletonKeyConfig.getRealm());
        int n = expiration = this.skeletonKeyConfig.getAccessCodeLifetime() == 0 ? 3600 : this.skeletonKeyConfig.getAccessCodeLifetime();
        if (this.skeletonKeyConfig.getTokenLifetime() > 0) {
            token.expiration(System.currentTimeMillis() / 1000L + (long)expiration);
        }
        SkeletonKeyToken.Access realmAccess = new SkeletonKeyToken.Access();
        for (String role : gp.getRoles()) {
            realmAccess.addRole(role);
        }
        token.setRealmAccess(realmAccess);
        return token;
    }

    public static class AccessCode {
        protected String id = UUID.randomUUID().toString() + System.currentTimeMillis();
        protected long expiration;
        protected SkeletonKeyToken token;
        protected String client;
        protected boolean sso;
        protected String redirect;

        public boolean isExpired() {
            return this.expiration != 0L && System.currentTimeMillis() / 1000L > this.expiration;
        }

        public String getId() {
            return this.id;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public void setExpiration(long expiration) {
            this.expiration = expiration;
        }

        public SkeletonKeyToken getToken() {
            return this.token;
        }

        public void setToken(SkeletonKeyToken token) {
            this.token = token;
        }

        public String getClient() {
            return this.client;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public boolean isSso() {
            return this.sso;
        }

        public void setSso(boolean sso) {
            this.sso = sso;
        }

        public String getRedirect() {
            return this.redirect;
        }

        public void setRedirect(String redirect) {
            this.redirect = redirect;
        }
    }
}

