/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.wadl;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.xml.bind.JAXBException;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.wadl.ResteasyWadlGenerator;
import org.jboss.resteasy.wadl.ResteasyWadlServiceRegistry;
import org.jboss.resteasy.wadl.ResteasyWadlWriter;
import org.jboss.resteasy.wadl.i18n.LogMessages;
import org.jboss.resteasy.wadl.i18n.Messages;

public abstract class ResteasyWadlDefaultResource {
    private Map<String, ResteasyWadlServiceRegistry> services = new HashMap<String, ResteasyWadlServiceRegistry>();
    ResteasyWadlWriter wadlWriter = new ResteasyWadlWriter();

    private void loadServices(ResteasyDeployment deployment) {
        this.services.put("/", ResteasyWadlGenerator.generateServiceRegistry(deployment));
    }

    public Map<String, ResteasyWadlServiceRegistry> getServices() {
        return this.services;
    }

    public ResteasyWadlWriter getWadlWriter() {
        return this.wadlWriter;
    }

    @GET
    @Path(value="/application.xml")
    @Produces(value={"application/xml"})
    public String output(@Context ResteasyDeployment deployment) {
        this.loadServices(deployment);
        try {
            return this.wadlWriter.getStringWriter("", this.services).toString();
        }
        catch (JAXBException e) {
            LogMessages.LOGGER.error(Messages.MESSAGES.cantProcessWadl(), e);
            return null;
        }
    }

    @GET
    @Path(value="/wadl-extended/{path}")
    @Produces(value={"application/xml"})
    public Response grammars(@PathParam(value="path") String path, @Context ResteasyDeployment deployment) {
        this.loadServices(deployment);
        this.wadlWriter.createApplication("", this.services);
        return Response.ok().type(MediaType.APPLICATION_XML_TYPE).entity((Object)this.wadlWriter.getWadlGrammar().getSchemaOfUrl(path)).build();
    }
}

