/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.wadl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.wadl.ResteasyWadlGenerator;
import org.jboss.resteasy.wadl.ResteasyWadlServiceRegistry;
import org.jboss.resteasy.wadl.ResteasyWadlServletWriter;
import org.jboss.resteasy.wadl.i18n.LogMessages;
import org.jboss.resteasy.wadl.i18n.Messages;

public class ResteasyWadlServlet
extends HttpServlet {
    private Map<String, ResteasyWadlServiceRegistry> services;
    private ResteasyWadlServletWriter apiWriter = new ResteasyWadlServletWriter();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        LogMessages.LOGGER.debug(Messages.MESSAGES.loadingResteasyWadlServlet());
        this.scanResources();
        LogMessages.LOGGER.debug(Messages.MESSAGES.resteasyWadlServletLoaded());
        ServletContext servletContext = config.getServletContext();
        servletContext.setAttribute(((Object)((Object)this)).getClass().getName(), (Object)this);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        String uri = req.getRequestURL().toString();
        uri = uri.substring(0, uri.length() - req.getServletPath().length());
        LogMessages.LOGGER.debug(Messages.MESSAGES.servingPathInfo(pathInfo));
        LogMessages.LOGGER.debug(Messages.MESSAGES.query(req.getQueryString()));
        if (this.services == null) {
            this.scanResources();
        }
        if (this.services == null) {
            resp.sendError(503, Messages.MESSAGES.noResteasyDeployments());
        }
        resp.setContentType("application/xml");
        this.apiWriter.writeWadl(uri, req, resp, this.services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanResources() {
        ServletConfig config = this.getServletConfig();
        ServletContext servletContext = config.getServletContext();
        Map deployments = (Map)servletContext.getAttribute("resteasy.deployments");
        if (deployments == null) {
            return;
        }
        ResteasyWadlServlet resteasyWadlServlet = this;
        synchronized (resteasyWadlServlet) {
            this.services = new HashMap<String, ResteasyWadlServiceRegistry>();
            for (Map.Entry entry : deployments.entrySet()) {
                this.services.put((String)entry.getKey(), ResteasyWadlGenerator.generateServiceRegistry((ResteasyDeployment)entry.getValue()));
            }
        }
    }
}

