/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.vertx;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.plugins.server.vertx.ChunkOutputStream;
import org.jboss.resteasy.plugins.server.vertx.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class VertxHttpResponse
implements HttpResponse {
    private int status = 200;
    private OutputStream os;
    private MultivaluedMap<String, Object> outputHeaders = new MultivaluedMapImpl();
    final HttpServerResponse response;
    private boolean committed;
    private ResteasyProviderFactory providerFactory;
    private final HttpMethod method;
    private Throwable vertxException;
    private boolean ended;

    public VertxHttpResponse(HttpServerResponse response, ResteasyProviderFactory providerFactory) {
        this(response, providerFactory, null);
    }

    public VertxHttpResponse(HttpServerResponse response, ResteasyProviderFactory providerFactory, HttpMethod method) {
        this.method = method;
        this.os = method == null || !method.equals((Object)HttpMethod.HEAD) ? new ChunkOutputStream(this, 1000) : null;
        this.response = response;
        this.providerFactory = providerFactory;
        response.exceptionHandler(t -> {
            this.vertxException = t;
        });
        response.closeHandler(v -> {
            this.vertxException = new IOException("Connection closed");
        });
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add((Object)"Set-Cookie", (Object)cookie);
    }

    void checkException() throws IOException {
        if (this.vertxException instanceof IOException) {
            throw (IOException)this.vertxException;
        }
        if (this.vertxException != null) {
            throw new IOException(this.vertxException);
        }
    }

    public void sendError(int status) throws IOException {
        this.checkException();
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        this.checkException();
        if (this.committed) {
            throw new IllegalStateException();
        }
        this.response.setStatusCode(status);
        if (message != null) {
            this.response.end(message);
        } else {
            this.response.end();
        }
        this.committed = true;
        this.ended = true;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException(Messages.MESSAGES.alreadyCommitted());
        }
        this.outputHeaders.clear();
    }

    public static void transformHeaders(VertxHttpResponse vertxResponse, HttpServerResponse response, ResteasyProviderFactory factory) {
        for (Map.Entry entry : vertxResponse.getOutputHeaders().entrySet()) {
            String key = (String)entry.getKey();
            for (Object value : (List)entry.getValue()) {
                RuntimeDelegate.HeaderDelegate delegate = factory.getHeaderDelegate(value.getClass());
                if (delegate != null) {
                    response.headers().add(key, delegate.toString(value));
                    continue;
                }
                response.headers().set(key, value.toString());
            }
        }
    }

    public void prepareChunkStream() {
        this.committed = true;
        this.response.setStatusCode(this.getStatus());
        this.response.setChunked(true);
        VertxHttpResponse.transformHeaders(this, this.response, this.providerFactory);
    }

    private void prepareEmptyResponse() {
        this.committed = true;
        this.response.setStatusCode(this.getStatus());
        VertxHttpResponse.transformHeaders(this, this.response, this.providerFactory);
        this.response.headersEndHandler(h -> {
            this.response.headers().remove(HttpHeaders.CONTENT_LENGTH);
            this.response.headers().set(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE);
        });
    }

    public void finish() throws IOException {
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.checkException();
        if (this.os != null) {
            this.os.flush();
            if (!this.isCommitted()) {
                this.prepareChunkStream();
            }
        } else {
            this.prepareEmptyResponse();
        }
        this.response.end();
    }

    public void flushBuffer() throws IOException {
        this.checkException();
        if (this.os != null) {
            this.os.flush();
        }
    }
}

