/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.vertx;

import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.resteasy.plugins.server.vertx.VertxHttpResponse;
import org.jboss.resteasy.plugins.server.vertx.i18n.Messages;

public class ChunkOutputStream
extends OutputStream {
    private Buffer buffer;
    private final VertxHttpResponse response;
    private final int chunkSize;

    ChunkOutputStream(VertxHttpResponse response, int chunksize) {
        this.response = response;
        if (chunksize < 1) {
            throw new IllegalArgumentException(Messages.MESSAGES.chunkSizeMustBeAtLeastOne());
        }
        this.chunkSize = chunksize;
        this.buffer = Buffer.buffer((int)chunksize);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer.length() >= this.chunkSize - 1) {
            this.flush();
        }
        this.buffer.appendByte((byte)b);
    }

    public void reset() {
        if (this.response.isCommitted()) {
            throw new IllegalStateException(Messages.MESSAGES.responseIsCommitted());
        }
        this.buffer = Buffer.buffer((int)this.chunkSize);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int dataLengthLeftToWrite;
        int spaceLeftInCurrentChunk;
        int dataToWriteOffset = off;
        for (dataLengthLeftToWrite = len; (spaceLeftInCurrentChunk = this.chunkSize - this.buffer.length()) < dataLengthLeftToWrite; dataLengthLeftToWrite -= spaceLeftInCurrentChunk) {
            this.buffer.appendBytes(b, dataToWriteOffset, spaceLeftInCurrentChunk);
            dataToWriteOffset += spaceLeftInCurrentChunk;
            this.flush();
        }
        if (dataLengthLeftToWrite > 0) {
            this.buffer.appendBytes(b, dataToWriteOffset, dataLengthLeftToWrite);
        }
    }

    @Override
    public void flush() throws IOException {
        int readable = this.buffer.length();
        if (readable == 0) {
            return;
        }
        if (!this.response.isCommitted()) {
            this.response.prepareChunkStream();
        }
        this.response.checkException();
        this.response.response.write(this.buffer);
        this.buffer = Buffer.buffer();
        super.flush();
    }
}

