/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.spring;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.plugins.spring.ResteasyRegistration;
import org.jboss.resteasy.plugins.spring.SpringResourceFactory;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanProcessor
implements BeanFactoryPostProcessor {
    protected Registry registry;
    protected ResteasyProviderFactory providerFactory;
    protected Dispatcher dispatcher;
    protected Map<String, SpringResourceFactory> resourceFactories = new HashMap<String, SpringResourceFactory>();

    public SpringBeanProcessor(Dispatcher dispatcher) {
        this(dispatcher, dispatcher.getRegistry(), dispatcher.getProviderFactory());
    }

    public SpringBeanProcessor(Dispatcher dispatcher, Registry registry, ResteasyProviderFactory providerFactory) {
        this.setRegistry(registry);
        this.setProviderFactory(providerFactory);
        this.setDispatcher(dispatcher);
    }

    @Deprecated
    public SpringBeanProcessor(Registry registry, ResteasyProviderFactory providerFactory) {
        this.setRegistry(registry);
        this.setProviderFactory(providerFactory);
    }

    public SpringBeanProcessor() {
    }

    @Required
    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    private Collection<String> createIgnoreList(ConfigurableListableBeanFactory beanFactory) {
        Map registries = beanFactory.getBeansOfType(ResteasyRegistration.class);
        HashSet<String> ignoreBeansList = new HashSet<String>();
        for (ResteasyRegistration registration : registries.values()) {
            String beanName = registration.getBeanName();
            ignoreBeansList.add(beanName);
            BeanDefinition beanDef = beanFactory.getBeanDefinition(beanName);
            Class<?> beanClass = null;
            try {
                beanClass = Thread.currentThread().getContextClassLoader().loadClass(beanDef.getBeanClassName());
                SpringResourceFactory reg = new SpringResourceFactory(beanName, (BeanFactory)beanFactory, beanClass);
                this.getRegistry().addResourceFactory((ResourceFactory)reg, registration.getContext());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return ignoreBeansList;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerResolvableDependency(Registry.class, (Object)this.getRegistry());
        beanFactory.registerResolvableDependency(ResteasyProviderFactory.class, (Object)this.getProviderFactory());
        if (this.dispatcher != null) {
            beanFactory.registerResolvableDependency(Dispatcher.class, (Object)this.getDispatcher());
        }
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ResteasyBeanPostProcessor());
        Collection<String> ignoreList = this.createIgnoreList(beanFactory);
        for (String name : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDef;
            if (ignoreList.contains(name) || (beanDef = beanFactory.getBeanDefinition(name)).getBeanClassName() == null || beanDef.isAbstract()) continue;
            Class<?> beanClass = null;
            try {
                beanClass = Thread.currentThread().getContextClassLoader().loadClass(beanDef.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (GetRestful.isRootResource(beanClass)) {
                SpringResourceFactory resourceFactory = new SpringResourceFactory(name, (BeanFactory)beanFactory, beanClass);
                this.resourceFactories.put(name, resourceFactory);
                this.getRegistry().addResourceFactory((ResourceFactory)resourceFactory);
                continue;
            }
            if (!beanClass.isAnnotationPresent(Provider.class)) continue;
            this.getProviderFactory().registerProviderInstance(beanFactory.getBean(name));
        }
    }

    protected class ResteasyBeanPostProcessor
    implements BeanPostProcessor {
        protected ResteasyBeanPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            SpringResourceFactory resourceFactory = SpringBeanProcessor.this.resourceFactories.get(beanName);
            if (resourceFactory == null) {
                return bean;
            }
            PropertyInjector propertyInjector = resourceFactory.getPropertyInjector();
            HttpRequest request = (HttpRequest)ResteasyProviderFactory.getContextData(HttpRequest.class);
            if (request == null) {
                propertyInjector.inject(bean);
            } else {
                HttpResponse response = (HttpResponse)ResteasyProviderFactory.getContextData(HttpResponse.class);
                propertyInjector.inject(request, response, bean);
            }
            return bean;
        }
    }
}

