/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.reactor.netty;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.jboss.resteasy.plugins.server.reactor.netty.ChunkOutputStream;
import org.jboss.resteasy.plugins.server.reactor.netty.SinkSubscriber;
import org.jboss.resteasy.plugins.server.reactor.netty.i18n.Messages;
import org.jboss.resteasy.spi.HttpResponse;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.netty.http.server.HttpServerResponse;

@Deprecated(forRemoval=true, since="6.2.13.Final")
public class ReactorNettyHttpResponse
implements HttpResponse {
    private static final Logger log = Logger.getLogger(ReactorNettyHttpResponse.class);
    private final HttpServerResponse resp;
    private OutputStream out;
    private boolean committed;
    private final Sinks.Empty<Void> completionSink;

    public ReactorNettyHttpResponse(HttpMethod method, HttpServerResponse resp, Sinks.Empty<Void> completionSink) {
        this.resp = resp;
        this.completionSink = completionSink;
        if (method == null || !method.equals((Object)HttpMethod.HEAD)) {
            this.out = new ChunkOutputStream(this, resp, completionSink);
        } else {
            resp.responseHeaders().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        }
    }

    public int getStatus() {
        return this.resp.status().code();
    }

    public void setStatus(int status) {
        this.resp.status(status);
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        final HttpHeaders headers = this.resp.responseHeaders();
        return new MultivaluedMap<String, Object>(){

            public void putSingle(String key, Object value) {
                headers.remove(key);
                headers.add(key, value);
            }

            public void add(String key, Object value) {
                headers.add(key, value);
            }

            public Object getFirst(String key) {
                List values = headers.getAll(key);
                if (values.isEmpty()) {
                    return null;
                }
                return values.get(0);
            }

            public void addAll(String key, Object ... newValues) {
                headers.add(key, (Object)newValues);
            }

            public void addAll(String key, List<Object> valueList) {
                headers.add(key, valueList);
            }

            public void addFirst(String key, Object value) {
                headers.getAll(key).add(0, (String)value);
            }

            public boolean equalsIgnoreValueOrder(MultivaluedMap<String, Object> otherMap) {
                throw new UnsupportedOperationException();
            }

            public int size() {
                return headers.size();
            }

            public boolean isEmpty() {
                return headers.isEmpty();
            }

            public boolean containsKey(Object key) {
                return headers.contains((String)key);
            }

            public boolean containsValue(Object value) {
                return headers.entries().stream().anyMatch(e -> ((String)e.getValue()).equals(value));
            }

            public List<Object> get(Object key) {
                if (key == null) {
                    return null;
                }
                return headers.getAll(key.toString());
            }

            public List<Object> put(String key, List<Object> value) {
                Object previous = this.get(key);
                headers.add(key, value);
                return previous;
            }

            public List<Object> remove(Object key) {
                Object previous = this.get(key);
                headers.remove(key.toString());
                return previous;
            }

            public void putAll(Map<? extends String, ? extends List<Object>> m) {
                m.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
            }

            public void clear() {
                headers.clear();
            }

            public Set<String> keySet() {
                return headers.names();
            }

            public Collection<List<Object>> values() {
                return headers.entries().stream().map(e -> this.get(e.getKey())).collect(Collectors.toList());
            }

            public Set<Map.Entry<String, List<Object>>> entrySet() {
                HashSet<Map.Entry<String, List<Object>>> entries = new HashSet<Map.Entry<String, List<Object>>>();
                headers.names().forEach(name -> entries.add(new Map.Entry<String, List<Object>>(){

                    @Override
                    public String getKey() {
                        return name;
                    }

                    @Override
                    public List<Object> getValue() {
                        return this.get(name);
                    }

                    @Override
                    public List<Object> setValue(List<Object> value) {
                        throw new UnsupportedOperationException("Read Only Entry!");
                    }
                }));
                return entries;
            }
        };
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setOutputStream(OutputStream os) {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                log.warn((Object)"Failed to close OutputStream", (Throwable)e);
            }
        }
        this.out = os;
    }

    public void addNewCookie(NewCookie cookie) {
        this.resp.responseHeaders().add("Set-Cookie", (Object)cookie);
    }

    public void sendError(int status) {
        Mono respMono = this.resp.status(status).header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)HttpHeaderValues.ZERO).then();
        this.committed = true;
        SinkSubscriber.subscribe(this.completionSink, (Mono<Void>)respMono);
        this.committed();
    }

    public void sendError(int status, String message) {
        Mono respMono = this.resp.status(status).header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(message.length())).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.TEXT_PLAIN).sendString((Publisher)Mono.just((Object)message)).then();
        SinkSubscriber.subscribe(this.completionSink, (Mono<Void>)respMono);
        this.committed();
    }

    public boolean isCommitted() {
        return this.committed;
    }

    void committed() {
        this.committed = true;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException(Messages.MESSAGES.alreadyCommitted());
        }
        this.resp.responseHeaders().clear();
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.flush();
            this.out.close();
        } else {
            SinkSubscriber.subscribe(this.completionSink, (Mono<Void>)Mono.empty());
        }
    }

    public void flushBuffer() throws IOException {
        this.out.flush();
    }
}

