/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.jboss.resteasy.auth.oauth.OAuthConsumer;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthProviderChecker;
import org.jboss.resteasy.auth.oauth.OAuthToken;
import org.jboss.resteasy.auth.oauth.OAuthValidator;
import org.jboss.resteasy.auth.oauth.URLUtils;
import org.jboss.resteasy.auth.oauth.i18n.LogMessages;
import org.jboss.resteasy.auth.oauth.i18n.Messages;

public class OAuthUtils {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String OAUTH_VERIFIER_PARAM = "oauth_verifier";
    public static final String OAUTH_CALLBACK_CONFIRMED_PARAM = "oauth_callback_confirmed";
    private static final String ATTR_OAUTH_VALIDATOR = OAuthValidator.class.getName();
    private static final String ATTR_OAUTH_PROVIDER = OAuthProvider.class.getName();

    public static String encodeForOAuth(String value) {
        try {
            return URLUtils.encodePart(value, "UTF-8", URLUtils.UNRESERVED);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(Messages.MESSAGES.utf8EncodingShouldBeSupported(), e);
        }
    }

    public static void sendValues(HttpServletResponse resp, String ... params) throws IOException {
        PrintWriter writer = resp.getWriter();
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException(Messages.MESSAGES.argumentsShouldBeNameValue());
        }
        for (int i = 0; i < params.length; i += 2) {
            if (i > 0) {
                writer.append('&');
            }
            writer.append(OAuthUtils.encodeForOAuth(params[i]));
            writer.append('=');
            writer.append(OAuthUtils.encodeForOAuth(params[i + 1]));
        }
    }

    public static OAuthMessage readMessage(HttpServletRequest req) {
        String authorizationHeader = req.getHeader(AUTHORIZATION_HEADER);
        HashSet<OAuth.Parameter> parameters = new HashSet<OAuth.Parameter>();
        if (authorizationHeader != null) {
            for (OAuth.Parameter param : OAuthMessage.decodeAuthorization((String)authorizationHeader)) {
                if ("realm".equalsIgnoreCase(param.getValue())) continue;
                parameters.add(param);
            }
        }
        ArrayList<String> parameterNames = Collections.list(req.getParameterNames());
        for (String parameterName : parameterNames) {
            for (String value : req.getParameterValues(parameterName)) {
                LogMessages.LOGGER.debug(Messages.MESSAGES.addingParameter(parameterName, value));
                parameters.add(new OAuth.Parameter(parameterName, value));
            }
        }
        return new OAuthMessage(req.getMethod(), req.getRequestURL().toString(), parameters);
    }

    public static void makeErrorResponse(HttpServletResponse resp, String message, int httpCode, OAuthProvider provider) throws IOException {
        LogMessages.LOGGER.debug(Messages.MESSAGES.errorHttpCode(httpCode, message));
        resp.getWriter().append(message);
        resp.setStatus(httpCode);
        String headerValue = "OAuth";
        if (provider.getRealm() != null && provider.getRealm().length() > 0) {
            headerValue = headerValue + " realm=\"" + provider.getRealm() + "\"";
        }
        resp.setHeader(AUTHENTICATE_HEADER, headerValue);
    }

    public static long parseTimestamp(String timestampString) throws OAuthException {
        try {
            long timestamp = Long.parseLong(timestampString);
            if (timestamp > 0L) {
                return timestamp;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new OAuthException(401, Messages.MESSAGES.invalidTimestampString(timestampString));
    }

    public static int getHttpCode(OAuthProblemException x) {
        Integer httpCode = (Integer)OAuth.Problems.TO_HTTP_CODE.get(x.getProblem());
        if (httpCode != null) {
            return httpCode;
        }
        return 500;
    }

    public static OAuthProvider getOAuthProvider(ServletContext context) throws ServletException {
        OAuthProvider provider = (OAuthProvider)context.getAttribute(ATTR_OAUTH_PROVIDER);
        if (provider != null) {
            return provider;
        }
        String providerClassName = context.getInitParameter("oauth.provider.provider-class");
        if (providerClassName == null) {
            throw new ServletException("oauth.provider.provider-class" + Messages.MESSAGES.parameterRequired());
        }
        try {
            LogMessages.LOGGER.info(Messages.MESSAGES.loadingOAuthProvider(providerClassName));
            Class<?> providerClass = Class.forName(providerClassName);
            if (!OAuthProvider.class.isAssignableFrom(providerClass)) {
                throw new ServletException("oauth.provider.provider-class" + Messages.MESSAGES.classMustBeInstanceOAuthProvider(providerClassName));
            }
            provider = new OAuthProviderChecker((OAuthProvider)providerClass.newInstance());
            context.setAttribute(ATTR_OAUTH_PROVIDER, (Object)provider);
            return provider;
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("oauth.provider.provider-class" + Messages.MESSAGES.classNotFound(providerClassName));
        }
        catch (Exception e) {
            throw new ServletException("oauth.provider.provider-class" + Messages.MESSAGES.classCouldNotBeInstantiated(providerClassName), (Throwable)e);
        }
    }

    public static OAuthValidator getValidator(ServletContext context, OAuthProvider provider) {
        OAuthValidator validator = (OAuthValidator)((Object)context.getAttribute(ATTR_OAUTH_VALIDATOR));
        if (validator != null) {
            return validator;
        }
        validator = new OAuthValidator(provider);
        context.setAttribute(ATTR_OAUTH_VALIDATOR, (Object)validator);
        return validator;
    }

    public static void validateRequestWithAccessToken(HttpServletRequest request, OAuthMessage message, OAuthToken accessToken, OAuthValidator validator, OAuthConsumer consumer) throws Exception {
        net.oauth.OAuthConsumer _consumer = new net.oauth.OAuthConsumer(null, consumer.getKey(), accessToken.getConsumer().getSecret(), null);
        OAuthAccessor accessor = new OAuthAccessor(_consumer);
        accessor.accessToken = accessToken.getToken();
        accessor.tokenSecret = accessToken.getSecret();
        validator.validateMessage(message, accessor, accessToken);
        if (!OAuthUtils.validateUriScopes(request.getRequestURL().toString(), accessToken.getScopes())) {
            throw new OAuthException(400, Messages.MESSAGES.wrongURIScope());
        }
    }

    public static void validateRequestWithoutAccessToken(HttpServletRequest request, OAuthMessage message, OAuthValidator validator, OAuthConsumer consumer) throws Exception {
        String[] scopes = consumer.getScopes();
        if (scopes == null || !OAuthUtils.validateUriScopes(request.getRequestURL().toString(), scopes)) {
            throw new OAuthException(400, Messages.MESSAGES.wrongURIScope());
        }
        net.oauth.OAuthConsumer _consumer = new net.oauth.OAuthConsumer(null, consumer.getKey(), consumer.getSecret(), null);
        OAuthAccessor accessor = new OAuthAccessor(_consumer);
        validator.validateMessage(message, accessor, null);
    }

    public static boolean validateUriScopes(String requestURI, String[] scopes) {
        if (scopes == null) {
            return true;
        }
        for (String scope : scopes) {
            if (!requestURI.startsWith(scope)) continue;
            return true;
        }
        return false;
    }
}

