/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthToken;
import org.jboss.resteasy.auth.oauth.OAuthUtils;
import org.jboss.resteasy.auth.oauth.OAuthValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthFilter
implements Filter {
    public static final String OAUTH_AUTH_METHOD = "OAuth";
    private static final Logger logger = LoggerFactory.getLogger(OAuthFilter.class);
    private OAuthProvider provider;
    private OAuthValidator validator;

    public void init(FilterConfig config) throws ServletException {
        logger.info("Loading OAuth Filter");
        ServletContext context = config.getServletContext();
        this.provider = OAuthUtils.getOAuthProvider(context);
        this.validator = OAuthUtils.getValidator(context, this.provider);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this._doFilter((HttpServletRequest)request, (HttpServletResponse)response, filterChain);
    }

    private void _doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        logger.debug("Filtering " + request.getMethod() + " " + request.getRequestURL().toString());
        OAuthMessage message = OAuthUtils.readMessage(request);
        try {
            message.requireParameters(new String[]{"oauth_consumer_key", "oauth_token", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce"});
            logger.debug("Parameters present");
            String consumerKey = message.getParameter("oauth_consumer_key");
            String accessTokenString = message.getParameter("oauth_token");
            OAuthToken accessToken = this.provider.getAccessToken(consumerKey, accessTokenString);
            OAuthConsumer consumer = new OAuthConsumer(null, consumerKey, accessToken.getConsumer().getSecret(), null);
            OAuthAccessor accessor = new OAuthAccessor(consumer);
            accessor.accessToken = accessTokenString;
            accessor.tokenSecret = accessToken.getSecret();
            this.validator.validateMessage(message, accessor, accessToken);
            final Principal principal = accessToken.getPrincipal();
            final Set<String> roles = accessToken.getRoles();
            HttpServletRequestWrapper newRequest = new HttpServletRequestWrapper(request){

                public Principal getUserPrincipal() {
                    return principal;
                }

                public boolean isUserInRole(String role) {
                    return roles.contains(role);
                }

                public String getAuthType() {
                    return OAuthFilter.OAUTH_AUTH_METHOD;
                }
            };
            logger.debug("doFilter");
            filterChain.doFilter((ServletRequest)newRequest, (ServletResponse)response);
        }
        catch (OAuthException x) {
            OAuthUtils.makeErrorResponse(response, x.getMessage(), x.getHttpCode(), this.provider);
        }
        catch (OAuthProblemException x) {
            OAuthUtils.makeErrorResponse(response, x.getProblem(), OAuthUtils.getHttpCode(x), this.provider);
        }
        catch (Exception x) {
            logger.error("Exception ", (Throwable)x);
            OAuthUtils.makeErrorResponse(response, x.getMessage(), 500, this.provider);
        }
    }
}

