/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.jboss.resteasy.auth.oauth.OAuthConsumer;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthToken;
import org.jboss.resteasy.auth.oauth.OAuthUtils;
import org.jboss.resteasy.auth.oauth.OAuthValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthServlet
extends HttpServlet {
    private static final long serialVersionUID = 3083924242786185155L;
    private static final Logger logger = LoggerFactory.getLogger(OAuthServlet.class);
    static final String PARAM_REQUEST_TOKEN_URL = "oauth.provider.tokens.request";
    static final String PARAM_ACCESS_TOKEN_URL = "oauth.provider.tokens.access";
    static final String PARAM_PROVIDER_CLASS = "oauth.provider.provider-class";
    private String requestTokenURL;
    private String accessTokenURL;
    private OAuthProvider provider;
    private OAuthValidator validator;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        logger.info("Loading OAuth Servlet");
        ServletContext context = config.getServletContext();
        this.requestTokenURL = context.getInitParameter(PARAM_REQUEST_TOKEN_URL);
        if (this.requestTokenURL == null) {
            this.requestTokenURL = "/requestToken";
        }
        this.accessTokenURL = context.getInitParameter(PARAM_ACCESS_TOKEN_URL);
        if (this.accessTokenURL == null) {
            this.accessTokenURL = "/accessToken";
        }
        logger.info("Request token URL: " + this.requestTokenURL);
        logger.info("Access token URL: " + this.accessTokenURL);
        this.provider = OAuthUtils.getOAuthProvider(context);
        this.validator = OAuthUtils.getValidator(context, this.provider);
        logger.debug("OAuthServlet loaded");
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        logger.debug("Serving " + pathInfo);
        logger.debug("Query " + req.getQueryString());
        if (pathInfo.equals(this.requestTokenURL)) {
            this.serveRequestToken(req, resp);
        } else if (pathInfo.equals(this.accessTokenURL)) {
            this.serveAccessToken(req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void serveRequestToken(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug("Request token");
        OAuthMessage message = OAuthUtils.readMessage(req);
        try {
            message.requireParameters(new String[]{"oauth_consumer_key", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce", "oauth_callback"});
            logger.debug("Parameters present");
            String consumerKey = message.getParameter("oauth_consumer_key");
            OAuthConsumer consumer = this.provider.getConsumer(consumerKey);
            net.oauth.OAuthConsumer _consumer = new net.oauth.OAuthConsumer(null, consumerKey, consumer.getSecret(), null);
            OAuthAccessor accessor = new OAuthAccessor(_consumer);
            this.validator.validateMessage(message, accessor, null);
            OAuthToken token = this.provider.makeRequestToken(consumerKey, message.getParameter("oauth_callback"));
            OAuthUtils.sendValues(resp, "oauth_token", token.getToken(), "oauth_token_secret", token.getSecret(), "oauth_callback_confirmed", "true");
            resp.setStatus(200);
            logger.debug("All OK");
        }
        catch (OAuthException x) {
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), x.getHttpCode(), this.provider);
        }
        catch (OAuthProblemException x) {
            OAuthUtils.makeErrorResponse(resp, x.getProblem(), OAuthUtils.getHttpCode(x), this.provider);
        }
        catch (Exception x) {
            logger.error("Exception ", (Throwable)x);
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), 500, this.provider);
        }
    }

    private void serveAccessToken(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug("Access token");
        OAuthMessage message = OAuthUtils.readMessage(req);
        try {
            message.requireParameters(new String[]{"oauth_consumer_key", "oauth_token", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce", "oauth_verifier"});
            logger.debug("Parameters present");
            String consumerKey = message.getParameter("oauth_consumer_key");
            String requestTokenString = message.getParameter("oauth_token");
            String verifier = message.getParameter("oauth_verifier");
            OAuthToken requestToken = this.provider.getRequestToken(consumerKey, requestTokenString);
            net.oauth.OAuthConsumer consumer = new net.oauth.OAuthConsumer(null, consumerKey, requestToken.getConsumer().getSecret(), null);
            OAuthAccessor accessor = new OAuthAccessor(consumer);
            accessor.requestToken = requestTokenString;
            accessor.tokenSecret = requestToken.getSecret();
            this.validator.validateMessage(message, accessor, requestToken);
            OAuthToken tokens = this.provider.makeAccessToken(consumerKey, requestTokenString, verifier);
            OAuthUtils.sendValues(resp, "oauth_token", tokens.getToken(), "oauth_token_secret", tokens.getSecret());
            resp.setStatus(200);
            logger.debug("All OK");
        }
        catch (OAuthException x) {
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), x.getHttpCode(), this.provider);
        }
        catch (OAuthProblemException x) {
            OAuthUtils.makeErrorResponse(resp, x.getProblem(), OAuthUtils.getHttpCode(x), this.provider);
        }
        catch (Exception x) {
            logger.error("Exception ", (Throwable)x);
            OAuthUtils.makeErrorResponse(resp, x.getMessage(), 500, this.provider);
        }
    }
}

