/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jboss.resteasy.auth.oauth.OAuthConsumer;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthToken;

public class OAuthMemoryProvider
implements OAuthProvider {
    private String realm;
    private Map<String, Consumer> consumers = Collections.synchronizedMap(new HashMap());

    public OAuthMemoryProvider(String realm) {
        this.realm = realm;
    }

    private static String makeRandomString() {
        return UUID.randomUUID().toString();
    }

    protected void addConsumer(String consumerKey, String consumerSecret) {
        this.consumers.put(consumerKey, new Consumer(consumerKey, consumerSecret));
    }

    protected void addRequestKey(String consumerKey, String requestToken, String requestSecret, String callback) throws OAuthException {
        Consumer consumer = this._getConsumer(consumerKey);
        RequestToken token = new RequestToken(consumer, requestToken, requestSecret, callback);
        consumer.tokens.put(requestToken, token);
    }

    protected void addAccessKey(String consumerKey, String accessToken, String accessSecret, String principalName, String ... roles) throws OAuthException {
        Consumer consumer = this._getConsumer(consumerKey);
        Token token = new Token(consumer, accessToken, accessSecret, 0L);
        token.setPrincipalName(principalName);
        token.setRoles(new HashSet<String>(Arrays.asList(roles)));
        consumer.tokens.put(accessToken, token);
    }

    protected void authoriseRequestToken(String consumerKey, String requestToken, String verifier) throws OAuthException {
        this._getConsumer(consumerKey).getRequestToken(requestToken).setVerifier(verifier);
    }

    protected Consumer _getConsumer(String consumerKey) throws OAuthException {
        Consumer ret = this.consumers.get(consumerKey);
        if (ret == null) {
            throw new OAuthException(401, "No such consumer key " + consumerKey);
        }
        return ret;
    }

    public String getRealm() {
        return this.realm;
    }

    public String authoriseRequestToken(String consumerKey, String requestToken) throws OAuthException {
        return this._getConsumer(consumerKey).getRequestToken(requestToken).authorise();
    }

    public OAuthConsumer getConsumer(String consumerKey) throws OAuthException {
        return this._getConsumer(consumerKey);
    }

    public OAuthToken getRequestToken(String consumerKey, String requestToken) throws OAuthException {
        return this._getConsumer(consumerKey).getRequestToken(requestToken);
    }

    public OAuthToken getAccessToken(String consumerKey, String accessToken) throws OAuthException {
        return this._getConsumer(consumerKey).getAccessToken(accessToken);
    }

    public void checkTimestamp(OAuthToken token, long timestamp) throws OAuthException {
        ((Token)token).setTimestamp(timestamp);
    }

    public OAuthToken makeAccessToken(String consumerKey, String requestToken, String verifier) throws OAuthException {
        Consumer consumer = this._getConsumer(consumerKey);
        long timestamp = consumer.verifyAndRemoveRequestToken(requestToken, verifier);
        return consumer.makeAccessTokens(requestToken, timestamp);
    }

    public OAuthToken makeRequestToken(String consumerKey, String callback) throws OAuthException {
        return this._getConsumer(consumerKey).makeRequestTokens(callback);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Token
    implements OAuthToken {
        protected String token;
        protected String secret;
        protected long timestamp;
        private Set<String> roles;
        private String principalName;
        private Consumer consumer;

        public Token(Consumer consumer, String token, String secret) {
            this.consumer = consumer;
            this.token = token;
            this.secret = secret;
        }

        public Token(Consumer consumer, String token, String secret, long timestamp) {
            this(consumer, token, secret);
            this.timestamp = timestamp;
        }

        public boolean isRequestToken() {
            return false;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public synchronized void setTimestamp(long timestamp) throws OAuthException {
            if (this.timestamp > timestamp) {
                throw new OAuthException(401, "Invalid timestamp " + timestamp);
            }
            this.timestamp = timestamp;
        }

        @Override
        public String getToken() {
            return this.token;
        }

        @Override
        public String getSecret() {
            return this.secret;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        @Override
        public Principal getPrincipal() {
            final String principalName = this.principalName;
            return new Principal(){

                public String getName() {
                    return principalName;
                }
            };
        }

        @Override
        public Set<String> getRoles() {
            return this.roles;
        }

        public void setRoles(Set<String> roles) {
            this.roles = roles;
        }

        public void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        @Override
        public Consumer getConsumer() {
            return this.consumer;
        }
    }

    private static class RequestToken
    extends Token {
        private String verifier;
        private String callback;

        public RequestToken(Consumer consumer, String token, String secret, String callback) {
            super(consumer, token, secret);
            this.callback = callback;
        }

        public void checkVerifier(String verifier) throws OAuthException {
            if (this.verifier == null || this.verifier.length() == 0) {
                throw new OAuthException(401, "Request token was not authorized " + this.token);
            }
            if (verifier == null || !verifier.equals(this.verifier)) {
                throw new OAuthException(401, "Invalid verifier code for token " + this.token);
            }
        }

        public String getVerifier() {
            return this.verifier;
        }

        public void setVerifier(String verifier) {
            this.verifier = verifier;
        }

        public String getCallback() {
            return this.callback;
        }

        public boolean isRequestToken() {
            return true;
        }

        public String authorise() throws OAuthException {
            if (this.verifier != null && this.verifier.length() != 0) {
                throw new OAuthException(401, "Request token was already authorized " + this.token);
            }
            this.verifier = OAuthMemoryProvider.makeRandomString();
            return this.verifier;
        }
    }

    private static class Consumer
    implements OAuthConsumer {
        private String consumerKey;
        private String consumerSecret;
        private Map<String, Token> tokens = Collections.synchronizedMap(new HashMap());

        public Consumer(String consumerKey, String consumerSecret) {
            this.consumerKey = consumerKey;
            this.consumerSecret = consumerSecret;
        }

        public String getKey() {
            return this.consumerKey;
        }

        public String getSecret() {
            return this.consumerSecret;
        }

        public RequestToken getRequestToken(String requestKey) throws OAuthException {
            Token ret = this.tokens.get(requestKey);
            if (ret == null || !ret.isRequestToken()) {
                throw new OAuthException(401, "No such request key " + requestKey);
            }
            return (RequestToken)ret;
        }

        public Token getAccessToken(String accessKey) throws OAuthException {
            Token ret = this.tokens.get(accessKey);
            if (ret == null || ret.isRequestToken()) {
                throw new OAuthException(401, "No such access key " + accessKey);
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OAuthToken makeRequestTokens(String callback) {
            Map<String, Token> map = this.tokens;
            synchronized (map) {
                String newToken;
                while (this.tokens.containsKey(newToken = OAuthMemoryProvider.makeRandomString())) {
                }
                RequestToken token = new RequestToken(this, newToken, OAuthMemoryProvider.makeRandomString(), callback);
                this.tokens.put(token.getToken(), token);
                return token;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long verifyAndRemoveRequestToken(String requestToken, String verifier) throws OAuthException {
            Map<String, Token> map = this.tokens;
            synchronized (map) {
                RequestToken request = this.getRequestToken(requestToken);
                request.checkVerifier(verifier);
                this.tokens.remove(requestToken);
                return request.timestamp;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public OAuthToken makeAccessTokens(String requestToken, long timestamp) throws OAuthException {
            Map<String, Token> map = this.tokens;
            synchronized (map) {
                String newToken;
                while (this.tokens.containsKey(newToken = OAuthMemoryProvider.makeRandomString())) {
                }
                Token token = new Token(this, newToken, OAuthMemoryProvider.makeRandomString(), timestamp);
                this.tokens.put(token.getToken(), token);
                return token;
            }
        }
    }
}

