/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import jakarta.ws.rs.SeBootstrap;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.resteasy.core.ResteasyDeploymentImpl;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.plugins.server.netty.RequestHandler;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpRequestDecoder;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpResponseEncoder;
import org.jboss.resteasy.plugins.server.netty.SniConfiguration;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.util.EmbeddedServerHelper;
import org.jboss.resteasy.util.PortProvider;

public class NettyJaxrsServer
implements EmbeddedJaxrsServer<NettyJaxrsServer> {
    protected ServerBootstrap bootstrap = new ServerBootstrap();
    protected String hostname = null;
    protected int configuredPort = PortProvider.getPort();
    protected int runtimePort = -1;
    protected ResteasyDeployment deployment;
    protected String root = "";
    protected SecurityDomain domain;
    private EventLoopGroup eventLoopGroup;
    private EventLoopGroup eventExecutor;
    private int ioWorkerCount = Runtime.getRuntime().availableProcessors() * 2;
    private int executorThreadCount = 16;
    private SSLContext sslContext;
    private SniConfiguration sniConfiguration;
    private int maxRequestSize = 0xA00000;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private int maxChunkSize = 8192;
    private int backlog = 128;
    private int idleTimeout = -1;
    private List<ChannelHandler> channelHandlers = Collections.emptyList();
    private Map<ChannelOption, Object> channelOptions = Collections.emptyMap();
    private Map<ChannelOption, Object> childChannelOptions = Collections.emptyMap();
    private List<ChannelHandler> httpChannelHandlers = Collections.emptyList();
    private EmbeddedServerHelper serverHelper = new EmbeddedServerHelper();

    public NettyJaxrsServer deploy() {
        return this;
    }

    public NettyJaxrsServer start() {
        SeBootstrap.Configuration.Builder builder = SeBootstrap.Configuration.builder().host(this.hostname).port(Integer.valueOf(this.configuredPort)).rootPath(this.root).sslContext(this.sslContext);
        this.start(builder.build());
        return this;
    }

    public void start(SeBootstrap.Configuration configuration) {
        String hostname = configuration.host();
        int configuredPort = configuration.port();
        Object contextPath = configuration.rootPath();
        this.serverHelper.checkDeployment(this.deployment);
        this.eventLoopGroup = new NioEventLoopGroup(this.ioWorkerCount);
        this.eventExecutor = new NioEventLoopGroup(this.executorThreadCount);
        String appPath = this.serverHelper.checkAppDeployment(this.deployment);
        if (appPath != null && (contextPath == null || "".equals(contextPath) || "/".equals(contextPath))) {
            contextPath = appPath;
        }
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.eventLoopGroup).channel(NioServerSocketChannel.class)).childHandler(this.createChannelInitializer(configuration, (String)contextPath)).option(ChannelOption.SO_BACKLOG, (Object)this.backlog)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        for (Map.Entry<ChannelOption, Object> entry : this.channelOptions.entrySet()) {
            this.bootstrap.option(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ChannelOption, Object> entry : this.childChannelOptions.entrySet()) {
            this.bootstrap.childOption(entry.getKey(), entry.getValue());
        }
        InetSocketAddress socketAddress = null == hostname || hostname.isEmpty() ? new InetSocketAddress(configuredPort) : new InetSocketAddress(hostname, configuredPort);
        Channel channel = this.bootstrap.bind((SocketAddress)socketAddress).syncUninterruptibly().channel();
        this.runtimePort = ((InetSocketAddress)channel.localAddress()).getPort();
    }

    public void stop() {
        this.runtimePort = -1;
        this.eventLoopGroup.shutdownGracefully();
        this.eventExecutor.shutdownGracefully();
        if (this.deployment != null) {
            this.deployment.stop();
        }
    }

    public ResteasyDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = new ResteasyDeploymentImpl();
        }
        return this.deployment;
    }

    public NettyJaxrsServer setDeployment(ResteasyDeployment deployment) {
        this.deployment = deployment;
        return this;
    }

    public NettyJaxrsServer setPort(int port) {
        this.configuredPort = port;
        return this;
    }

    public int getPort() {
        return this.runtimePort > 0 ? this.runtimePort : this.configuredPort;
    }

    public NettyJaxrsServer setHostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public String getHostname() {
        return this.hostname;
    }

    public NettyJaxrsServer setRootResourcePath(String rootResourcePath) {
        this.root = rootResourcePath == null || rootResourcePath.equals("/") ? "" : (!rootResourcePath.startsWith("/") ? "/" + rootResourcePath : rootResourcePath);
        return this;
    }

    public NettyJaxrsServer setSecurityDomain(SecurityDomain sc) {
        this.domain = sc;
        return this;
    }

    public NettyJaxrsServer setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public NettyJaxrsServer setSniConfiguration(SniConfiguration sniConfiguration) {
        this.sniConfiguration = sniConfiguration;
        return this;
    }

    public SniConfiguration getSniConfiguration() {
        return this.sniConfiguration;
    }

    public NettyJaxrsServer setIoWorkerCount(int ioWorkerCount) {
        this.ioWorkerCount = ioWorkerCount;
        return this;
    }

    public NettyJaxrsServer setExecutorThreadCount(int executorThreadCount) {
        this.executorThreadCount = executorThreadCount;
        return this;
    }

    public NettyJaxrsServer setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public NettyJaxrsServer setMaxInitialLineLength(int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
        return this;
    }

    public NettyJaxrsServer setMaxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
        return this;
    }

    public NettyJaxrsServer setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public NettyJaxrsServer setBacklog(int backlog) {
        this.backlog = backlog;
        return this;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public NettyJaxrsServer setIdleTimeout(int idleTimeoutSeconds) {
        this.idleTimeout = idleTimeoutSeconds;
        return this;
    }

    public NettyJaxrsServer setChannelHandlers(List<ChannelHandler> channelHandlers) {
        this.channelHandlers = channelHandlers == null ? Collections.emptyList() : channelHandlers;
        return this;
    }

    public NettyJaxrsServer setHttpChannelHandlers(List<ChannelHandler> httpChannelHandlers) {
        this.httpChannelHandlers = httpChannelHandlers == null ? Collections.emptyList() : httpChannelHandlers;
        return this;
    }

    public NettyJaxrsServer setChannelOptions(Map<ChannelOption, Object> channelOptions) {
        this.channelOptions = channelOptions == null ? Collections.emptyMap() : channelOptions;
        return this;
    }

    public NettyJaxrsServer setChildChannelOptions(Map<ChannelOption, Object> channelOptions) {
        this.childChannelOptions = channelOptions == null ? Collections.emptyMap() : channelOptions;
        return this;
    }

    protected RequestDispatcher createRequestDispatcher() {
        if (this.deployment == null) {
            throw new IllegalArgumentException("A ResteasyDeployment object required");
        }
        return new RequestDispatcher((SynchronousDispatcher)this.deployment.getDispatcher(), this.deployment.getProviderFactory(), this.domain);
    }

    private ChannelInitializer<SocketChannel> createChannelInitializer(final SeBootstrap.Configuration configuration, final String contextPath) {
        final RequestDispatcher dispatcher = this.createRequestDispatcher();
        final String protocol = configuration.protocol().toLowerCase(Locale.ROOT);
        final SSLContext sslContext = "https".equals(protocol) ? configuration.sslContext() : null;
        if (sslContext == null && this.sniConfiguration == null) {
            return new ChannelInitializer<SocketChannel>(this){
                final /* synthetic */ NettyJaxrsServer this$0;
                {
                    this.this$0 = this$0;
                }

                public void initChannel(SocketChannel ch) throws Exception {
                    this.this$0.setupHandlers(ch, dispatcher, protocol, contextPath);
                }
            };
        }
        if (this.sniConfiguration == null) {
            return new ChannelInitializer<SocketChannel>(this){
                final /* synthetic */ NettyJaxrsServer this$0;
                {
                    this.this$0 = this$0;
                }

                public void initChannel(SocketChannel ch) throws Exception {
                    SSLEngine engine = sslContext.createSSLEngine();
                    engine.setUseClientMode(false);
                    engine.setWantClientAuth(configuration.sslClientAuthentication() == SeBootstrap.Configuration.SSLClientAuthentication.OPTIONAL);
                    engine.setNeedClientAuth(configuration.sslClientAuthentication() == SeBootstrap.Configuration.SSLClientAuthentication.MANDATORY);
                    ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(engine)});
                    this.this$0.setupHandlers(ch, dispatcher, protocol, contextPath);
                }
            };
        }
        return new ChannelInitializer<SocketChannel>(this){
            final /* synthetic */ NettyJaxrsServer this$0;
            {
                this.this$0 = this$0;
            }

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addFirst(new ChannelHandler[]{new SniHandler(this.this$0.sniConfiguration.buildMapping())});
                this.this$0.setupHandlers(ch, dispatcher, protocol, contextPath);
            }
        };
    }

    private void setupHandlers(SocketChannel ch, RequestDispatcher dispatcher, String protocol, String contextPath) {
        ChannelPipeline channelPipeline = ch.pipeline();
        channelPipeline.addLast(this.channelHandlers.toArray(new ChannelHandler[this.channelHandlers.size()]));
        if (this.idleTimeout > 0) {
            channelPipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, this.idleTimeout));
        }
        channelPipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize)});
        channelPipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        channelPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxRequestSize)});
        channelPipeline.addLast(this.httpChannelHandlers.toArray(new ChannelHandler[this.httpChannelHandlers.size()]));
        channelPipeline.addLast(new ChannelHandler[]{new RestEasyHttpRequestDecoder(dispatcher.getDispatcher(), contextPath, protocol)});
        channelPipeline.addLast(new ChannelHandler[]{new RestEasyHttpResponseEncoder()});
        channelPipeline.addLast((EventExecutorGroup)this.eventExecutor, new ChannelHandler[]{new RequestHandler(dispatcher)});
    }
}

